/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.eval.Task$Async$;
import monix.eval.Task$Context$;
import monix.eval.internal.StackFrame;
import monix.eval.internal.StackTracedContext;
import monix.eval.internal.TaskConnection$;
import monix.eval.internal.TaskRestartCallback;
import monix.eval.internal.TaskRestartCallback$;
import monix.eval.internal.TaskRunLoop;
import monix.eval.internal.TracingPlatform;
import monix.eval.tracing.TaskEvent;
import monix.eval.tracing.TaskTrace$;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.CancelableFuture;
import monix.execution.CancelableFuture$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.internal.collection.ChunkedArrayStack;
import monix.execution.internal.collection.ChunkedArrayStack$;
import monix.execution.misc.CanBindLocals$;
import monix.execution.misc.Local;
import monix.execution.misc.Local$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class TaskRunLoop$ {
    public static final TaskRunLoop$ MODULE$ = new TaskRunLoop$();
    private static final List<String> runLoopFilter = (List)new .colon.colon((Object)"monix.eval.", (List)new .colon.colon((Object)"scala.runtime.", (List)Nil$.MODULE$));
    private static volatile boolean bitmap$init$0 = true;

    public <A> void startFull(Task<A> source, Task.Context contextInit, Callback<Throwable, A> cb, TaskRestartCallback rcb, Function1<Object, Task<Object>> bFirst, ChunkedArrayStack<Function1<Object, Task<Object>>> bRest, int frameIndex) {
        Callback cba = cb;
        ObjectRef current = ObjectRef.create(source);
        ObjectRef bFirstRef = ObjectRef.create(bFirst);
        ObjectRef bRestRef = ObjectRef.create(bRest);
        boolean hasUnboxed = false;
        Object unboxed = null;
        IntRef currentIndex = IntRef.create((int)frameIndex);
        ObjectRef context = ObjectRef.create((Object)contextInit);
        ExecutionModel em = ((Task.Context)context.elem).scheduler().executionModel();
        while (currentIndex.elem != 0) {
            BoxedUnit boxedUnit;
            Task task = (Task)current.elem;
            if (task instanceof Task.FlatMap) {
                Object trace;
                Task.FlatMap flatMap = (Task.FlatMap)task;
                Task fa = flatMap.source();
                Function1 bindNext = flatMap.f();
                if (TracingPlatform.isStackTracing && (trace = flatMap.trace()) != null) {
                    ((Task.Context)context.elem).stackTracedContext().pushEvent((TaskEvent)trace);
                }
                if ((Function1)bFirstRef.elem != null) {
                    if ((ChunkedArrayStack)bRestRef.elem == null) {
                        bRestRef.elem = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    ((ChunkedArrayStack)bRestRef.elem).push((Object)((Function1)bFirstRef.elem));
                }
                bFirstRef.elem = bindNext;
                current.elem = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Now) {
                Task.Now now = (Task.Now)task;
                Object value = now.value();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Eval) {
                BoxedUnit boxedUnit2;
                Task.Eval eval = (Task.Eval)task;
                Function0 thunk = eval.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    current.elem = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current.elem = new Task.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (task instanceof Task.Map) {
                Object trace;
                Task.Map map = (Task.Map)task;
                Task fa = map.source();
                if (TracingPlatform.isStackTracing && (trace = map.trace()) != null) {
                    ((Task.Context)context.elem).stackTracedContext().pushEvent((TaskEvent)trace);
                }
                if ((Function1)bFirstRef.elem != null) {
                    if ((ChunkedArrayStack)bRestRef.elem == null) {
                        bRestRef.elem = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    ((ChunkedArrayStack)bRestRef.elem).push((Object)((Function1)bFirstRef.elem));
                }
                bFirstRef.elem = map;
                current.elem = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Suspend) {
                BoxedUnit boxedUnit4;
                Task.Suspend suspend = (Task.Suspend)task;
                Function0 thunk = suspend.thunk();
                try {
                    current.elem = (Task)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current.elem = new Task.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (task instanceof Task.Error) {
                StackFrame<Object, Task<Object>> stackFrame;
                Task.Error error = (Task.Error)task;
                Throwable error2 = error.e();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions) {
                    this.augmentException(error2, ((Task.Context)context.elem).stackTracedContext());
                }
                if ((stackFrame = this.findErrorHandler((Function1<Object, Task<Object>>)((Function1)bFirstRef.elem), (ChunkedArrayStack<Function1<Object, Task<Object>>>)((ChunkedArrayStack)bRestRef.elem))) == null) {
                    cba.onError((Object)error2);
                    return;
                }
                try {
                    current.elem = stackFrame.recover(error2);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current.elem = new Task.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                currentIndex.elem = em.nextFrameIndex(currentIndex.elem);
                bFirstRef.elem = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (task instanceof Task.Async) {
                    Task.Async async = (Task.Async)task;
                    this.executeAsyncTask(async, (Task.Context)context.elem, cba, rcb, (Function1<Object, Task<Object>>)((Function1)bFirstRef.elem), (ChunkedArrayStack<Function1<Object, Task<Object>>>)((ChunkedArrayStack)bRestRef.elem), currentIndex.elem);
                    return;
                }
                if (task instanceof Task.ContextSwitch) {
                    BoxedUnit boxedUnit8;
                    Task.ContextSwitch contextSwitch = (Task.ContextSwitch)task;
                    Task next = contextSwitch.source();
                    Function1<Task.Context, Task.Context> modify = contextSwitch.modify();
                    Function4 restore = contextSwitch.restore();
                    boolean catchError = true;
                    try {
                        boolean useLCP;
                        Task.Context old = (Task.Context)context.elem;
                        context.elem = (Task.Context)modify.apply((Object)((Task.Context)context.elem));
                        catchError = false;
                        current.elem = next;
                        if ((Task.Context)context.elem != old) {
                            em = ((Task.Context)context.elem).scheduler().executionModel();
                            if (rcb != null) {
                                rcb.contextSwitch((Task.Context)context.elem);
                            }
                            if (restore != null) {
                                current.elem = new Task.FlatMap<Object, Object>(next, new TaskRunLoop.RestoreContext(old, restore), null);
                            }
                        }
                        if ((useLCP = ((Task.Context)context.elem).options().localContextPropagation()) && useLCP != old.options().localContextPropagation()) {
                            Local$.MODULE$.isolate((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.startFull((Task)current$1.elem, (Task.Context)context$1.elem, cba, rcb, (Function1<Object, Task<Object>>)((Function1)bFirstRef$1.elem), (ChunkedArrayStack<Function1<Object, Task<Object>>>)((ChunkedArrayStack)bRestRef$1.elem), currentIndex$1.elem), CanBindLocals$.MODULE$.forUnit());
                            return;
                        }
                        boxedUnit8 = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable5 = throwable;
                        if (!NonFatal$.MODULE$.apply(throwable5) || !catchError) {
                            throw throwable;
                        }
                        current.elem = new Task.Error(throwable5);
                        BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                        boxedUnit8 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit8;
                } else if (task instanceof Task.Trace) {
                    Task.Trace trace = (Task.Trace)task;
                    Task sourceTask = trace.source();
                    TaskEvent frame = trace.trace();
                    ((Task.Context)context.elem).stackTracedContext().pushEvent(frame);
                    current.elem = sourceTask;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)task);
                }
            }
            if (!hasUnboxed) continue;
            Function1<Object, Task<Object>> function1 = this.popNextBind((Function1<Object, Task<Object>>)((Function1)bFirstRef.elem), (ChunkedArrayStack<Function1<Object, Task<Object>>>)((ChunkedArrayStack)bRestRef.elem));
            if (function1 == null) {
                cba.onSuccess(unboxed);
                return;
            }
            try {
                current.elem = (Task)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (NonFatal$.MODULE$.apply(throwable6)) {
                    current.elem = new Task.Error(throwable6);
                    BoxedUnit boxedUnit10 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            currentIndex.elem = em.nextFrameIndex(currentIndex.elem);
            hasUnboxed = false;
            unboxed = null;
            bFirstRef.elem = null;
            BoxedUnit boxedUnit11 = BoxedUnit.UNIT;
        }
        this.restartAsync((Task)current.elem, (Task.Context)context.elem, cba, rcb, (Function1<Object, Task<Object>>)((Function1)bFirstRef.elem), (ChunkedArrayStack<Function1<Object, Task<Object>>>)((ChunkedArrayStack)bRestRef.elem));
    }

    public <A> void restartAsync(Task<A> source, Task.Context context, Callback<Throwable, A> cb, TaskRestartCallback rcb, Function1<Object, Task<Object>> bindCurrent, ChunkedArrayStack<Function1<Object, Task<Object>>> bindRest) {
        Local.Context savedLocals = context.options().localContextPropagation() ? Local$.MODULE$.getContext() : null;
        context.scheduler().execute(() -> {
            if (!context.shouldCancel()) {
                context.frameRef().reset();
                Local.Context prevLocals = null;
                if (savedLocals != null) {
                    prevLocals = Local$.MODULE$.getContext();
                    Local$.MODULE$.setContext(savedLocals);
                }
                try {
                    MODULE$.startFull(source, context, cb, rcb, bindCurrent, bindRest, 1);
                }
                finally {
                    if (prevLocals != null) {
                        Local$.MODULE$.setContext(prevLocals);
                    }
                }
            }
        });
    }

    public <A> Task<BoxedUnit> startLight(Task<A> source, Scheduler scheduler, Task.Options opts, Callback<Throwable, A> cb, boolean isCancelable) {
        Task current = source;
        Task.Map bFirst = null;
        ChunkedArrayStack bRest = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        ExecutionModel em = scheduler.executionModel();
        int frameIndex = this.frameStart(em);
        StackTracedContext tracingCtx = null;
        while (frameIndex != 0) {
            BoxedUnit boxedUnit;
            Task<Object> task = current;
            if (task instanceof Task.FlatMap) {
                Task.FlatMap flatMap = (Task.FlatMap)task;
                Task fa = flatMap.source();
                Task.Map bindNext = flatMap.f();
                if (TracingPlatform.isStackTracing) {
                    Object trace = flatMap.trace();
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    if (trace != null) {
                        tracingCtx.pushEvent((TaskEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Now) {
                Task.Now now = (Task.Now)task;
                Object value = now.value();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Eval) {
                BoxedUnit boxedUnit2;
                Task.Eval eval = (Task.Eval)task;
                Function0 thunk = eval.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    current = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (task instanceof Task.Map) {
                Task.Map map = (Task.Map)task;
                Task fa = map.source();
                if (TracingPlatform.isStackTracing) {
                    Object trace = map.trace();
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    if (trace != null) {
                        tracingCtx.pushEvent((TaskEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push((Object)bFirst);
                }
                bFirst = map;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Suspend) {
                BoxedUnit boxedUnit4;
                Task.Suspend suspend = (Task.Suspend)task;
                Function0 thunk = suspend.thunk();
                try {
                    current = (Task.Error)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (task instanceof Task.Error) {
                StackFrame<Object, Task<Object>> stackFrame;
                Task.Error error = (Task.Error)task;
                Throwable error2 = error.e();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions) {
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    this.augmentException(error2, tracingCtx);
                }
                if ((stackFrame = this.findErrorHandler(bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest)) == null) {
                    cb.onError((Object)error2);
                    return Task$.MODULE$.unit();
                }
                try {
                    current = stackFrame.recover(error2);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current = new Task.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                frameIndex = em.nextFrameIndex(frameIndex);
                bFirst = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Trace) {
                Task.Trace trace = (Task.Trace)task;
                Task sourceTask = trace.source();
                TaskEvent frame = trace.trace();
                if (tracingCtx == null) {
                    tracingCtx = new StackTracedContext();
                }
                tracingCtx.pushEvent(frame);
                current = sourceTask;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (tracingCtx == null) {
                    tracingCtx = new StackTracedContext();
                }
                Task<Object> x$1 = task;
                Scheduler x$2 = scheduler;
                Task.Options x$3 = opts;
                Callback<Throwable, A> x$4 = cb;
                Task.Map x$5 = bFirst;
                ChunkedArrayStack x$6 = bRest;
                int x$7 = frameIndex;
                boolean bl = false;
                boolean x$9 = isCancelable;
                StackTracedContext x$10 = tracingCtx;
                return this.goAsyncForLightCB(x$1, x$2, x$3, x$4, x$5, (ChunkedArrayStack<Function1<Object, Task<Object>>>)x$6, x$7, x$9, false, x$10);
            }
            if (!hasUnboxed) continue;
            Function1<Object, Task<Object>> function1 = this.popNextBind(bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest);
            if (function1 == null) {
                cb.onSuccess(unboxed);
                return Task$.MODULE$.unit();
            }
            try {
                current = (Task)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                if (NonFatal$.MODULE$.apply(throwable5)) {
                    current = new Task.Error(throwable5);
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            frameIndex = em.nextFrameIndex(frameIndex);
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
        }
        if (tracingCtx == null) {
            tracingCtx = new StackTracedContext();
        }
        Task<Object> x$11 = current;
        Scheduler x$12 = scheduler;
        Task.Options x$13 = opts;
        Callback<Throwable, A> x$14 = cb;
        Task.Map x$15 = bFirst;
        ChunkedArrayStack x$16 = bRest;
        int x$17 = frameIndex;
        boolean bl = true;
        boolean bl2 = true;
        StackTracedContext x$20 = tracingCtx;
        return this.goAsyncForLightCB(x$11, x$12, x$13, x$14, x$15, (ChunkedArrayStack<Function1<Object, Task<Object>>>)x$16, x$17, true, true, x$20);
    }

    public <A> boolean startLight$default$5() {
        return true;
    }

    public <A> Either<Task<A>, A> startStep(Task<A> source, Scheduler scheduler, Task.Options opts) {
        Task current = source;
        Task.Map bFirst = null;
        ChunkedArrayStack bRest = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        ExecutionModel em = scheduler.executionModel();
        int frameIndex = this.frameStart(em);
        StackTracedContext tracingCtx = null;
        while (frameIndex != 0) {
            BoxedUnit boxedUnit;
            Task<Object> task = current;
            if (task instanceof Task.FlatMap) {
                Task.FlatMap flatMap = (Task.FlatMap)task;
                Task fa = flatMap.source();
                Task.Map bindNext = flatMap.f();
                if (TracingPlatform.isStackTracing) {
                    Object trace = flatMap.trace();
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    if (trace != null) {
                        tracingCtx.pushEvent((TaskEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Now) {
                Task.Now now = (Task.Now)task;
                Object value = now.value();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Eval) {
                BoxedUnit boxedUnit2;
                Task.Eval eval = (Task.Eval)task;
                Function0 thunk = eval.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    current = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (task instanceof Task.Map) {
                Task.Map map = (Task.Map)task;
                Task fa = map.source();
                if (TracingPlatform.isStackTracing) {
                    Object trace = map.trace();
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    if (trace != null) {
                        tracingCtx.pushEvent((TaskEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push((Object)bFirst);
                }
                bFirst = map;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Suspend) {
                BoxedUnit boxedUnit4;
                Task.Suspend suspend = (Task.Suspend)task;
                Function0 thunk = suspend.thunk();
                try {
                    current = (Task.Error)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (task instanceof Task.Error) {
                StackFrame<Object, Task<Object>> stackFrame;
                Task.Error error = (Task.Error)task;
                Throwable error2 = error.e();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions) {
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    this.augmentException(error2, tracingCtx);
                }
                if ((stackFrame = this.findErrorHandler(bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest)) == null) {
                    throw error2;
                }
                try {
                    current = stackFrame.recover(error2);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current = new Task.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                frameIndex = em.nextFrameIndex(frameIndex);
                bFirst = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Trace) {
                Task.Trace trace = (Task.Trace)task;
                Task sourceTask = trace.source();
                TaskEvent frame = trace.trace();
                if (tracingCtx == null) {
                    tracingCtx = new StackTracedContext();
                }
                tracingCtx.pushEvent(frame);
                current = sourceTask;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (tracingCtx == null) {
                    tracingCtx = new StackTracedContext();
                }
                return this.goAsync4Step(task, scheduler, opts, bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest, frameIndex, false, tracingCtx);
            }
            if (!hasUnboxed) continue;
            Function1<Object, Task<Object>> function1 = this.popNextBind(bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest);
            if (function1 == null) {
                return package$.MODULE$.Right().apply(unboxed);
            }
            try {
                current = (Task)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                if (NonFatal$.MODULE$.apply(throwable5)) {
                    current = new Task.Error(throwable5);
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            frameIndex = em.nextFrameIndex(frameIndex);
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
        }
        if (tracingCtx == null) {
            tracingCtx = new StackTracedContext();
        }
        return this.goAsync4Step(current, scheduler, opts, bFirst, bRest, frameIndex, true, tracingCtx);
    }

    public <A> CancelableFuture<A> startFuture(Task<A> source, Scheduler scheduler, Task.Options opts) {
        Task current = source;
        Task.Map bFirst = null;
        ChunkedArrayStack bRest = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        ExecutionModel em = scheduler.executionModel();
        int frameIndex = this.frameStart(em);
        StackTracedContext tracingCtx = null;
        while (frameIndex != 0) {
            BoxedUnit boxedUnit;
            Task<Object> task = current;
            if (task instanceof Task.FlatMap) {
                Task.FlatMap flatMap = (Task.FlatMap)task;
                Task fa = flatMap.source();
                Task.Map bindNext = flatMap.f();
                if (TracingPlatform.isStackTracing) {
                    Object trace = flatMap.trace();
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    if (trace != null) {
                        tracingCtx.pushEvent((TaskEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Now) {
                Task.Now now = (Task.Now)task;
                Object value = now.value();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Eval) {
                BoxedUnit boxedUnit2;
                Task.Eval eval = (Task.Eval)task;
                Function0 thunk = eval.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    current = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (task instanceof Task.Map) {
                Task.Map map = (Task.Map)task;
                Task fa = map.source();
                if (TracingPlatform.isStackTracing) {
                    Object trace = map.trace();
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    if (trace != null) {
                        tracingCtx.pushEvent((TaskEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push((Object)bFirst);
                }
                bFirst = map;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Suspend) {
                BoxedUnit boxedUnit4;
                Task.Suspend suspend = (Task.Suspend)task;
                Function0 thunk = suspend.thunk();
                try {
                    current = (Task.Error)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (task instanceof Task.Error) {
                StackFrame<Object, Task<Object>> stackFrame;
                Task.Error error = (Task.Error)task;
                Throwable error2 = error.e();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions) {
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    this.augmentException(error2, tracingCtx);
                }
                if ((stackFrame = this.findErrorHandler(bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest)) == null) {
                    return CancelableFuture$.MODULE$.failed(error2);
                }
                try {
                    current = stackFrame.recover(error2);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current = new Task.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                frameIndex = em.nextFrameIndex(frameIndex);
                bFirst = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Trace) {
                Task.Trace trace = (Task.Trace)task;
                Task sourceTask = trace.source();
                TaskEvent frame = trace.trace();
                if (tracingCtx == null) {
                    tracingCtx = new StackTracedContext();
                }
                tracingCtx.pushEvent(frame);
                current = sourceTask;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (tracingCtx == null) {
                    tracingCtx = new StackTracedContext();
                }
                return this.goAsync4Future(task, scheduler, opts, bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest, frameIndex, false, tracingCtx);
            }
            if (!hasUnboxed) continue;
            Function1<Object, Task<Object>> function1 = this.popNextBind(bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest);
            if (function1 == null) {
                return CancelableFuture$.MODULE$.successful(unboxed);
            }
            try {
                current = (Task)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                if (NonFatal$.MODULE$.apply(throwable5)) {
                    current = new Task.Error(throwable5);
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            frameIndex = em.nextFrameIndex(frameIndex);
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
        }
        if (tracingCtx == null) {
            tracingCtx = new StackTracedContext();
        }
        return this.goAsync4Future(current, scheduler, opts, bFirst, bRest, frameIndex, true, tracingCtx);
    }

    public void executeAsyncTask(Task.Async<Object> task, Task.Context context, Callback<Throwable, Object> cb, TaskRestartCallback rcb, Function1<Object, Task<Object>> bFirst, ChunkedArrayStack<Function1<Object, Task<Object>>> bRest, int nextFrame) {
        Object trace;
        if (TracingPlatform.isStackTracing && (trace = task.trace()) != null) {
            context.stackTracedContext().pushEvent((TaskEvent)trace);
        }
        context.frameRef().$colon$eq(nextFrame);
        TaskRestartCallback restartCallback = rcb != null ? rcb : TaskRestartCallback$.MODULE$.apply(context, cb);
        restartCallback.start(task, bFirst, bRest);
    }

    private Task<BoxedUnit> goAsyncForLightCB(Task<Object> source, Scheduler scheduler, Task.Options opts, Callback<Throwable, Object> cb, Function1<Object, Task<Object>> bFirst, ChunkedArrayStack<Function1<Object, Task<Object>>> bRest, int nextFrame, boolean isCancelable, boolean forceFork, StackTracedContext tracingCtx) {
        Task.Context context = Task$Context$.MODULE$.apply(scheduler, opts, isCancelable ? TaskConnection$.MODULE$.apply() : TaskConnection$.MODULE$.uncancelable(), tracingCtx);
        if (!forceFork) {
            Task<Object> task = source;
            if (task instanceof Task.Async) {
                Task.Async async = (Task.Async)task;
                this.executeAsyncTask(async, context, cb, null, bFirst, bRest, 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.startFull(source, context, cb, null, bFirst, bRest, nextFrame);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.restartAsync(source, context, cb, null, bFirst, bRest);
        }
        return context.connection().cancel();
    }

    private <A> CancelableFuture<A> goAsync4Future(Task<Object> source, Scheduler scheduler, Task.Options opts, Function1<Object, Task<Object>> bFirst, ChunkedArrayStack<Function1<Object, Task<Object>>> bRest, int nextFrame, boolean forceFork, StackTracedContext tracingCtx) {
        Promise p = Promise$.MODULE$.apply();
        Callback cb = Callback$.MODULE$.fromPromise(p);
        Task.Context context = Task$Context$.MODULE$.apply(scheduler, opts, TaskConnection$.MODULE$.apply(), tracingCtx);
        if (!forceFork) {
            Task<Object> task = source;
            if (task instanceof Task.Async) {
                Task.Async async = (Task.Async)task;
                this.executeAsyncTask(async, context, (Callback<Throwable, Object>)cb, null, bFirst, bRest, 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.startFull(source, context, cb, null, bFirst, bRest, nextFrame);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.restartAsync(source, context, cb, null, bFirst, bRest);
        }
        return CancelableFuture$.MODULE$.apply(p.future(), context.connection().toCancelable(scheduler));
    }

    private <A> Either<Task<A>, A> goAsync4Step(Task<Object> source, Scheduler scheduler, Task.Options opts, Function1<Object, Task<Object>> bFirst, ChunkedArrayStack<Function1<Object, Task<Object>>> bRest, int nextFrame, boolean forceFork, StackTracedContext tracingCtx) {
        Function2 & Serializable intersect;
        Task.Context ctx2 = Task$Context$.MODULE$.apply(scheduler, opts, TaskConnection$.MODULE$.apply(), tracingCtx);
        if (!forceFork) {
            ctx2.frameRef().$colon$eq(nextFrame);
            intersect = (Function2 & Serializable)(ctx, cb) -> {
                TaskRunLoop$.MODULE$.startFull(source, ctx, cb, null, (Function1<Object, Task<Object>>)bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest, ctx.frameRef().apply());
                return BoxedUnit.UNIT;
            };
        } else {
            intersect = (Function2 & Serializable)(ctx, cb) -> {
                TaskRunLoop$.$anonfun$goAsync4Step$2(source, bFirst, bRest, ctx, cb);
                return BoxedUnit.UNIT;
            };
        }
        Function2 & Serializable start = intersect;
        return package$.MODULE$.Left().apply(new Task.Async(start, false, false, Task$Async$.MODULE$.apply$default$4(), Task$Async$.MODULE$.apply$default$5()));
    }

    public StackFrame<Object, Task<Object>> findErrorHandler(Function1<Object, Task<Object>> bFirst, ChunkedArrayStack<Function1<Object, Task<Object>>> bRest) {
        StackFrame stackFrame;
        Function1<Object, Task<Object>> function1 = bFirst;
        if (function1 instanceof StackFrame) {
            StackFrame stackFrame2;
            stackFrame = stackFrame2 = (StackFrame)function1;
        } else {
            if (bRest != null) {
                Function1 ref;
                do {
                    if ((ref = (Function1)bRest.pop()) != null) continue;
                    return null;
                } while (!(ref instanceof StackFrame));
                return (StackFrame)ref;
            }
            stackFrame = null;
        }
        return stackFrame;
    }

    public Function1<Object, Task<Object>> popNextBind(Function1<Object, Task<Object>> bFirst, ChunkedArrayStack<Function1<Object, Task<Object>>> bRest) {
        Function1 next;
        if (bFirst != null && !(bFirst instanceof StackFrame.ErrorHandler)) {
            return bFirst;
        }
        if (bRest == null) {
            return null;
        }
        do {
            if ((next = (Function1)bRest.pop()) != null) continue;
            return null;
        } while (next instanceof StackFrame.ErrorHandler);
        return next;
    }

    public int frameStart(ExecutionModel em) {
        return em.nextFrameIndex(0);
    }

    public void augmentException(Throwable ex, StackTracedContext ctx) {
        block1: {
            boolean augmented;
            StackTraceElement[] stackTrace = ex.getStackTrace();
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])stackTrace))) break block1;
            boolean bl = augmented = stackTrace[stackTrace.length - 1].getClassName().indexOf(64) != -1;
            if (!augmented) {
                StackTraceElement[] prefix = this.dropRunLoopFrames(stackTrace);
                StackTraceElement[] suffix = (StackTraceElement[])ctx.getStackTraces().flatMap((Function1 & Serializable)t -> TaskTrace$.MODULE$.getOpAndCallSite(t.stackTrace())).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StackTraceElement methodSite = (StackTraceElement)tuple2._1();
                    StackTraceElement callSite = (StackTraceElement)tuple2._2();
                    String op = NameTransformer$.MODULE$.decode(methodSite.getMethodName());
                    StackTraceElement stackTraceElement = new StackTraceElement(new StringBuilder(3).append(op).append(" @ ").append(callSite.getClassName()).toString(), callSite.getMethodName(), callSite.getFileName(), callSite.getLineNumber());
                    return stackTraceElement;
                }).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
                ex.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])prefix), (Object)suffix, ClassTag$.MODULE$.apply(StackTraceElement.class)));
            }
        }
    }

    private StackTraceElement[] dropRunLoopFrames(StackTraceElement[] frames) {
        return (StackTraceElement[])ArrayOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.refArrayOps((Object[])frames), (Function1 & Serializable)ste -> BoxesRunTime.boxToBoolean((boolean)TaskRunLoop$.$anonfun$dropRunLoopFrames$1(ste)));
    }

    public static final /* synthetic */ void $anonfun$goAsync4Step$2(Task source$2, Function1 bFirst$1, ChunkedArrayStack bRest$1, Task.Context ctx, Callback cb) {
        ctx.scheduler().execute(() -> MODULE$.startFull(source$2, ctx, cb, null, (Function1<Object, Task<Object>>)bFirst$1, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest$1, 1));
    }

    public static final /* synthetic */ boolean $anonfun$dropRunLoopFrames$2(StackTraceElement ste$1, String x$1) {
        return ste$1.getClassName().startsWith(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$dropRunLoopFrames$1(StackTraceElement ste) {
        return !runLoopFilter.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TaskRunLoop$.$anonfun$dropRunLoopFrames$2(ste, x$1)));
    }

    private TaskRunLoop$() {
    }
}

