/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import monix.eval.Task;
import monix.eval.internal.TaskCancellation$;
import monix.eval.internal.TaskConnection;
import monix.execution.Callback;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.schedulers.TrampolinedRunnable;

public final class TaskCancellation {
    public static <A> Task<A> raiseError(Task<A> task, Throwable throwable) {
        return TaskCancellation$.MODULE$.raiseError(task, throwable);
    }

    public static <A> Task<A> uncancelable(Task<A> task) {
        return TaskCancellation$.MODULE$.uncancelable(task);
    }

    private static final class RaiseCallback<A>
    extends Callback<Throwable, A>
    implements TrampolinedRunnable {
        private final AtomicBoolean waitsForResult;
        private final TaskConnection conn;
        private final Callback<Throwable, A> cb;
        private final Scheduler s;
        private A value;
        private Throwable error;

        public RaiseCallback(AtomicBoolean waitsForResult, TaskConnection conn, Callback<Throwable, A> cb, Scheduler s) {
            this.waitsForResult = waitsForResult;
            this.conn = conn;
            this.cb = cb;
            this.s = s;
        }

        public void run() {
            Throwable e = this.error;
            if (e != null) {
                this.cb.onError((Object)e);
            } else {
                this.cb.onSuccess(this.value);
            }
        }

        public void onSuccess(A value) {
            if (this.waitsForResult.getAndSet(false)) {
                this.conn.pop();
                this.value = value;
                this.s.execute((Runnable)((Object)this));
            }
        }

        public void onError(Throwable e) {
            if (this.waitsForResult.getAndSet(false)) {
                this.conn.pop();
                this.error = e;
                this.s.execute((Runnable)((Object)this));
            } else {
                this.s.reportFailure(e);
            }
        }
    }
}

