/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import cats.effect.IO;
import java.util.concurrent.RejectedExecutionException;
import monix.eval.Coeval;
import monix.eval.Task;
import monix.eval.internal.TaskConnection;
import monix.eval.internal.TaskConnectionRef;
import monix.eval.internal.TaskConnectionRef$;
import monix.eval.internal.TaskCreate$;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.AtomicInt$;
import monix.execution.exceptions.CallbackCalledMultipleTimesException;
import monix.execution.internal.Platform$;
import monix.execution.schedulers.StartAsyncBatchRunnable$;
import monix.execution.schedulers.TrampolinedRunnable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class TaskCreate {
    public static <A> Task<A> async(Function1<Callback<Throwable, A>, BoxedUnit> function1) {
        return TaskCreate$.MODULE$.async(function1);
    }

    public static <A> Task<A> async0(Function2<Scheduler, Callback<Throwable, A>, Object> function2) {
        return TaskCreate$.MODULE$.async0(function2);
    }

    public static <A> Task<A> asyncF(Function1<Callback<Throwable, A>, Task<BoxedUnit>> function1) {
        return TaskCreate$.MODULE$.asyncF(function1);
    }

    public static <A> Task<A> cancelable0(Function2<Scheduler, Callback<Throwable, A>, Task<BoxedUnit>> function2) {
        return TaskCreate$.MODULE$.cancelable0(function2);
    }

    public static <A> Task<A> cancelableCancelable(Function2<Scheduler, Callback<Throwable, A>, Cancelable> function2) {
        return TaskCreate$.MODULE$.cancelableCancelable(function2);
    }

    public static <A> Task<A> cancelableCoeval(Function2<Scheduler, Callback<Throwable, A>, Coeval<BoxedUnit>> function2) {
        return TaskCreate$.MODULE$.cancelableCoeval(function2);
    }

    public static <A> Task<A> cancelableEffect(Function1<Function1<Either<Throwable, A>, BoxedUnit>, Task<BoxedUnit>> function1) {
        return TaskCreate$.MODULE$.cancelableEffect(function1);
    }

    public static <A> Task<A> cancelableIO(Function2<Scheduler, Callback<Throwable, A>, IO<BoxedUnit>> function2) {
        return TaskCreate$.MODULE$.cancelableIO(function2);
    }

    private static final class CallbackForCreate<A>
    extends Callback<Throwable, A>
    implements TrampolinedRunnable {
        private final Task.Context ctx;
        private final long threadId;
        private final boolean shouldPop;
        private final Callback<Throwable, A> cb;
        private final AtomicInt state;
        private A value;
        private Throwable error;
        private boolean isSameThread;

        public CallbackForCreate(Task.Context ctx, long threadId, boolean shouldPop, Callback<Throwable, A> cb) {
            this.ctx = ctx;
            this.threadId = threadId;
            this.shouldPop = shouldPop;
            this.cb = cb;
            this.state = AtomicInt$.MODULE$.apply(0);
            this.isSameThread = false;
        }

        public CallbackForCreate(Task.Context ctx, boolean shouldPop, Callback<Throwable, A> cb) {
            this(ctx, Platform$.MODULE$.currentThreadId(), shouldPop, cb);
        }

        public void onSuccess(A value) {
            if (!this.tryOnSuccess(value)) {
                throw new CallbackCalledMultipleTimesException("onSuccess");
            }
        }

        public boolean tryOnSuccess(A value) {
            boolean bl;
            if (this.state.compareAndSet(0, 1)) {
                this.value = value;
                this.startExecution();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public void onError(Throwable e) {
            if (!this.tryOnError(e)) {
                throw new CallbackCalledMultipleTimesException("onError", e);
            }
        }

        public boolean tryOnError(Throwable e) {
            boolean bl;
            if (this.state.compareAndSet(0, 2)) {
                this.error = e;
                this.startExecution();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        private void startExecution() {
            if (this.shouldPop) {
                this.ctx.connection().pop();
            }
            this.isSameThread = Platform$.MODULE$.currentThreadId() == this.threadId;
            try {
                this.ctx.scheduler().execute((Runnable)((Object)(this.isSameThread && !this.ctx.options().localContextPropagation() ? this : StartAsyncBatchRunnable$.MODULE$.apply((TrampolinedRunnable)this, this.ctx.scheduler()))));
            }
            catch (RejectedExecutionException e) {
                this.forceErrorReport(e);
            }
        }

        public void run() {
            int n;
            if (!this.isSameThread) {
                this.ctx.frameRef().reset();
            }
            if (1 == (n = this.state.get())) {
                A v = this.value;
                this.value = null;
                this.cb.onSuccess(v);
            } else if (2 == n) {
                Throwable e = this.error;
                this.error = null;
                this.cb.onError((Object)e);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        private void forceErrorReport(RejectedExecutionException e) {
            this.value = null;
            if (this.error != null) {
                Throwable e2 = this.error;
                this.error = null;
                this.ctx.scheduler().reportFailure(e2);
            }
            Callback$.MODULE$.signalErrorTrampolined(this.cb, (Object)e);
        }
    }

    private static abstract class Cancelable0Start<A, Token>
    implements Function2<Task.Context, Callback<Throwable, A>, BoxedUnit> {
        private final Function2<Scheduler, Callback<Throwable, A>, Token> fn;

        public Cancelable0Start(Function2<Scheduler, Callback<Throwable, A>, Token> fn) {
            this.fn = fn;
        }

        public abstract void setConnection(TaskConnectionRef var1, Token var2, Scheduler var3);

        public final void apply(Task.Context ctx, Callback<Throwable, A> cb) {
            Scheduler s = ctx.scheduler();
            TaskConnection conn = ctx.connection();
            TaskConnectionRef cancelable = TaskConnectionRef$.MODULE$.apply();
            conn.push((Task<BoxedUnit>)cancelable.cancel(), s);
            CallbackForCreate<A> cbProtected = new CallbackForCreate<A>(ctx, true, cb);
            try {
                Object ref = this.fn.apply((Object)s, cbProtected);
                if (!(ref instanceof Cancelable.IsDummy)) {
                    this.setConnection(cancelable, ref, s);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    if (!cbProtected.tryOnError(e)) {
                        s.reportFailure(e);
                    }
                }
                throw throwable;
            }
        }
    }

    private static final class ForwardErrorCallback
    extends Callback<Throwable, BoxedUnit> {
        private final Callback<Throwable, ?> cb;
        private final UncaughtExceptionReporter r;

        public ForwardErrorCallback(Callback<Throwable, ?> cb, UncaughtExceptionReporter r) {
            this.cb = cb;
            this.r = r;
        }

        public void onSuccess(BoxedUnit value) {
        }

        public void onError(Throwable e) {
            if (!this.cb.tryOnError((Object)e)) {
                this.r.reportFailure(e);
            }
        }
    }
}

