/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import java.util.concurrent.RejectedExecutionException;
import monix.eval.Task;
import monix.eval.Task$;
import monix.eval.internal.ForkedRegister;
import monix.eval.internal.TaskExecuteOn$;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.Scheduler;
import scala.Function2;
import scala.runtime.BoxedUnit;

public final class TaskExecuteOn {
    public static <A> Task<A> apply(Task<A> task, Scheduler scheduler, boolean bl) {
        return TaskExecuteOn$.MODULE$.apply(task, scheduler, bl);
    }

    private static final class AsyncRegister<A>
    extends ForkedRegister<A> {
        private final Task<A> source;
        private final Scheduler s;

        public AsyncRegister(Task<A> source, Scheduler s) {
            this.source = source;
            this.s = s;
        }

        @Override
        public void apply(Task.Context ctx, Callback<Throwable, A> cb) {
            Scheduler oldS = ctx.scheduler();
            Task.Context ctx2 = ctx.withScheduler(this.s);
            try {
                Task$.MODULE$.unsafeStartAsync(this.source, ctx2, new Runnable(cb, oldS){
                    private final Callback cb$1;
                    private final Scheduler oldS$1;
                    private Object value;
                    private Throwable error;
                    {
                        this.cb$1 = cb$2;
                        this.oldS$1 = oldS$2;
                    }

                    public void onSuccess(Object value) {
                        this.value = value;
                        this.oldS$1.execute((Runnable)this);
                    }

                    public void onError(Throwable ex) {
                        this.error = ex;
                        this.oldS$1.execute((Runnable)this);
                    }

                    public void run() {
                        if (this.error != null) {
                            this.cb$1.onError((Object)this.error);
                        } else {
                            this.cb$1.onSuccess(this.value);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                Callback$.MODULE$.signalErrorTrampolined(cb, (Object)e);
            }
        }
    }

    private static final class TrampolinedStart<A>
    implements Function2<Task.Context, Callback<Throwable, A>, BoxedUnit> {
        private final Task<A> source;
        private final Scheduler s;

        public TrampolinedStart(Task<A> source, Scheduler s) {
            this.source = source;
            this.s = s;
        }

        public void apply(Task.Context ctx, Callback<Throwable, A> cb) {
            Task.Context ctx2 = ctx.withScheduler(this.s);
            try {
                Task$.MODULE$.unsafeStartNow(this.source, ctx2, cb);
            }
            catch (RejectedExecutionException e) {
                Callback$.MODULE$.signalErrorTrampolined(cb, (Object)e);
            }
        }
    }
}

