/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import monix.eval.Task;
import monix.eval.internal.TaskRunSyncUnsafe$;
import monix.execution.Callback;
import monix.execution.Scheduler;
import scala.concurrent.duration.Duration;

public final class TaskRunSyncUnsafe {
    public static <A> A apply(Task<A> task, Duration duration, Scheduler scheduler, Task.Options options) {
        return TaskRunSyncUnsafe$.MODULE$.apply(task, duration, scheduler, options);
    }

    private static final class BlockingCallback<A>
    extends Callback<Throwable, A> {
        private final OneShotLatch latch;
        private A success;
        private Throwable error;

        public BlockingCallback(OneShotLatch latch) {
            this.latch = latch;
        }

        public A value() {
            Throwable throwable = this.error;
            if (throwable != null) {
                Throwable e = throwable;
                throw e;
            }
            return this.success;
        }

        public void onSuccess(A value) {
            this.success = value;
            this.latch.releaseShared(1);
        }

        public void onError(Throwable ex) {
            this.error = ex;
            this.latch.releaseShared(1);
        }
    }

    private static final class OneShotLatch
    extends AbstractQueuedSynchronizer {
        @Override
        public int tryAcquireShared(int ignored) {
            return this.getState() != 0 ? 1 : -1;
        }

        @Override
        public boolean tryReleaseShared(int ignore) {
            this.setState(1);
            return true;
        }
    }
}

