/*
 * Copyright (c) 2014-2021 by The Monix Project Developers.
 * See the project homepage at: https://monix.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package monix.eval.internal

private[monix] object TracingPlatform {
  final val isCachedStackTracing: Boolean = false

  final val isFullStackTracing: Boolean = false

  final val isStackTracing: Boolean = isFullStackTracing || isCachedStackTracing

  final val traceBufferLogSize: Int = 4

  final val enhancedExceptions: Boolean = false
}
