/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import monix.eval.Task;
import monix.eval.Task$Context$;
import monix.eval.internal.StackFrame;
import monix.eval.internal.StackTracedContext;
import monix.eval.internal.TaskConnection$;
import monix.eval.internal.TaskRunLoop$;
import monix.eval.internal.TracingPlatform$;
import monix.eval.tracing.TaskEvent;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.CancelableFuture;
import monix.execution.CancelableFuture$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.internal.collection.ChunkedArrayStack;
import monix.execution.internal.collection.ChunkedArrayStack$;
import monix.execution.misc.Local;
import monix.execution.misc.Local$;
import scala.Function0;
import scala.Function1;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class TaskRunToFutureWithLocal$ {
    public static final TaskRunToFutureWithLocal$ MODULE$ = new TaskRunToFutureWithLocal$();

    public <A> CancelableFuture<A> startFuture(Task<A> source, Scheduler scheduler, Task.Options opts) {
        Task current = source;
        Task.Map bFirst = null;
        ChunkedArrayStack bRest = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        ExecutionModel em = scheduler.executionModel();
        int frameIndex = TaskRunLoop$.MODULE$.frameStart(em);
        StackTracedContext tracingCtx = null;
        Local.Context prev = Local$.MODULE$.getContext();
        Local.Context isolated = prev.isolate();
        while (frameIndex != 0) {
            BoxedUnit boxedUnit;
            Task<Object> task = current;
            if (task instanceof Task.FlatMap) {
                Task.FlatMap flatMap = (Task.FlatMap)task;
                Task fa = flatMap.source();
                Task.Map bindNext = flatMap.f();
                if (TracingPlatform$.MODULE$.isStackTracing()) {
                    Object trace = flatMap.trace();
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    if (trace != null) {
                        tracingCtx.pushEvent((TaskEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Now) {
                Task.Now now = (Task.Now)task;
                Object value = now.value();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Eval) {
                BoxedUnit boxedUnit2;
                Task.Eval eval = (Task.Eval)task;
                Function0 thunk = eval.thunk();
                Local$.MODULE$.setContext(isolated);
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    current = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (task instanceof Task.Map) {
                Task.Map map = (Task.Map)task;
                Task fa = map.source();
                if (TracingPlatform$.MODULE$.isStackTracing()) {
                    Object trace = map.trace();
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    if (trace != null) {
                        tracingCtx.pushEvent((TaskEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push((Object)bFirst);
                }
                bFirst = map;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Suspend) {
                BoxedUnit boxedUnit4;
                Task.Suspend suspend = (Task.Suspend)task;
                Function0 thunk = suspend.thunk();
                Local$.MODULE$.setContext(isolated);
                try {
                    current = (Task.Error)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (task instanceof Task.Error) {
                StackFrame<Object, Task<Object>> stackFrame;
                Task.Error error = (Task.Error)task;
                Throwable error2 = error.e();
                if (TracingPlatform$.MODULE$.isStackTracing() && TracingPlatform$.MODULE$.enhancedExceptions()) {
                    if (tracingCtx == null) {
                        tracingCtx = new StackTracedContext();
                    }
                    TaskRunLoop$.MODULE$.augmentException(error2, tracingCtx);
                }
                if ((stackFrame = TaskRunLoop$.MODULE$.findErrorHandler(bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest)) == null) {
                    return CancelableFuture$.MODULE$.failed(error2);
                }
                try {
                    current = stackFrame.recover(error2);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current = new Task.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                frameIndex = em.nextFrameIndex(frameIndex);
                bFirst = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Trace) {
                Task.Trace trace = (Task.Trace)task;
                Task sourceTask = trace.source();
                TaskEvent frame = trace.trace();
                if (tracingCtx == null) {
                    tracingCtx = new StackTracedContext();
                }
                tracingCtx.pushEvent(frame);
                current = sourceTask;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (tracingCtx == null) {
                    tracingCtx = new StackTracedContext();
                }
                return this.goAsync4Future(task, scheduler, opts, bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest, frameIndex, false, prev, isolated, tracingCtx);
            }
            if (!hasUnboxed) continue;
            Function1<Object, Task<Object>> function1 = TaskRunLoop$.MODULE$.popNextBind(bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest);
            if (function1 == null) {
                Local$.MODULE$.setContext(prev);
                return CancelableFuture$.MODULE$.successfulWithLocal(unboxed, isolated);
            }
            try {
                current = (Task)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                if (NonFatal$.MODULE$.apply(throwable5)) {
                    current = new Task.Error(throwable5);
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            frameIndex = em.nextFrameIndex(frameIndex);
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
        }
        if (tracingCtx == null) {
            tracingCtx = new StackTracedContext();
        }
        return this.goAsync4Future(current, scheduler, opts, bFirst, bRest, frameIndex, true, prev, isolated, tracingCtx);
    }

    private <A> CancelableFuture<A> goAsync4Future(Task<Object> source, Scheduler scheduler, Task.Options opts, Function1<Object, Task<Object>> bFirst, ChunkedArrayStack<Function1<Object, Task<Object>>> bRest, int nextFrame, boolean forceFork, Local.Context previousCtx, Local.Context isolatedCtx, StackTracedContext tracingCtx) {
        Local$.MODULE$.setContext(isolatedCtx);
        Promise p = Promise$.MODULE$.apply();
        Callback cb = Callback$.MODULE$.fromPromise(p);
        Task.Context context = Task$Context$.MODULE$.apply(scheduler, opts, TaskConnection$.MODULE$.apply(), tracingCtx);
        if (!forceFork) {
            Task<Object> task = source;
            if (task instanceof Task.Async) {
                Task.Async async = (Task.Async)task;
                TaskRunLoop$.MODULE$.executeAsyncTask(async, context, (Callback<Throwable, Object>)cb, null, bFirst, bRest, 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                TaskRunLoop$.MODULE$.startFull(source, context, cb, null, bFirst, bRest, nextFrame);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            TaskRunLoop$.MODULE$.restartAsync(source, context, cb, null, bFirst, bRest);
        }
        Local$.MODULE$.setContext(previousCtx);
        return CancelableFuture$.MODULE$.applyWithLocal(p.future(), context.connection().toCancelable(scheduler), isolatedCtx);
    }

    private TaskRunToFutureWithLocal$() {
    }
}

