/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import cats.effect.ExitCase;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.eval.Task$ContextSwitch$;
import monix.eval.internal.ForwardCancelable;
import monix.eval.internal.ForwardCancelable$;
import monix.eval.internal.StackFrame;
import monix.eval.internal.TaskBracket$;
import monix.eval.internal.TaskConnection;
import monix.eval.internal.TaskConnection$;
import monix.eval.internal.TaskFromFuture$;
import monix.execution.Callback;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.internal.Platform$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class TaskBracket {
    public static <A, B> Task<B> either(Task<A> task, Function1<A, Task<B>> function1, Function2<A, Either<Option<Throwable>, B>, Task<BoxedUnit>> function2) {
        return TaskBracket$.MODULE$.either(task, function1, function2);
    }

    public static <A, B> Task<B> exitCase(Task<A> task, Function1<A, Task<B>> function1, Function2<A, ExitCase<Throwable>, Task<BoxedUnit>> function2) {
        return TaskBracket$.MODULE$.exitCase(task, function1, function2);
    }

    public static <A> Task<A> guaranteeCase(Task<A> task, Function1<ExitCase<Throwable>, Task<BoxedUnit>> function1) {
        return TaskBracket$.MODULE$.guaranteeCase(task, function1);
    }

    private static abstract class BaseReleaseFrame<A, B>
    extends StackFrame<B, Task<B>> {
        private final Task.Context ctx;
        private final A a;
        private final AtomicBoolean waitsForResult;
        private final Promise<BoxedUnit> p;

        public BaseReleaseFrame(Task.Context ctx, A a) {
            this.ctx = ctx;
            this.a = a;
            this.waitsForResult = (AtomicBoolean)AtomicBuilder$.MODULE$.AtomicBooleanBuilder().buildInstance((Object)BoxesRunTime.boxToBoolean((boolean)true), (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
            this.p = Promise$.MODULE$.apply();
        }

        public abstract Task<BoxedUnit> releaseOnSuccess(A var1, B var2);

        public abstract Task<BoxedUnit> releaseOnError(A var1, Throwable var2);

        public abstract Task<BoxedUnit> releaseOnCancel(A var1);

        @Override
        public final Task<B> apply(B b) {
            Task<B> task = this.ctx.options().autoCancelableRunLoops() ? Task$.MODULE$.suspend(() -> this.$anonfun$1(b)) : this.unsafeApply(b);
            return this.makeUncancelable(task);
        }

        @Override
        public final Task<B> recover(Throwable e) {
            Task<B> task = this.ctx.options().autoCancelableRunLoops() ? Task$.MODULE$.suspend(() -> this.$anonfun$2(e)) : this.unsafeRecover(e);
            return this.makeUncancelable(task);
        }

        public final Task<BoxedUnit> cancel() {
            return Task$.MODULE$.suspend(this::cancel$$anonfun$1);
        }

        private final Task<B> unsafeApply(B b) {
            return this.waitsForResult.compareAndSet(true, false) ? this.releaseOnSuccess(this.a, b).redeemWith((Function1 & Serializable)ex -> Task$.MODULE$.apply(this::unsafeApply$$anonfun$1$$anonfun$1).flatMap((Function1 & Serializable)_$3 -> Task$.MODULE$.raiseError((Throwable)ex)), (Function1 & Serializable)_$4 -> Task$.MODULE$.apply(() -> this.unsafeApply$$anonfun$2$$anonfun$1(b))) : Task$.MODULE$.never();
        }

        private final Task<B> unsafeRecover(Throwable e) {
            return this.waitsForResult.compareAndSet(true, false) ? this.releaseOnError(this.a, e).redeemWith((Function1 & Serializable)ex -> Task$.MODULE$.apply(this::unsafeRecover$$anonfun$1$$anonfun$1).flatMap((Function1 & Serializable)_$5 -> Task$.MODULE$.raiseError((Throwable)ex)), (Function1 & Serializable)_$6 -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.unsafeRecover$$anonfun$2$$anonfun$1();
                return BoxedUnit.UNIT;
            })).flatMap(new ReleaseRecover(e)) : Task$.MODULE$.never();
        }

        private final Task<B> makeUncancelable(Task<B> task) {
            return Task$ContextSwitch$.MODULE$.apply(task, TaskBracket$.monix$eval$internal$TaskBracket$$$withConnectionUncancelable, TaskBracket$.monix$eval$internal$TaskBracket$$$disableUncancelableAndPop);
        }

        private final Task $anonfun$1(Object b$1) {
            return this.unsafeApply(b$1);
        }

        private final Task $anonfun$2(Throwable e$1) {
            return this.unsafeRecover(e$1);
        }

        private final void cancel$$anonfun$1$$anonfun$1$$anonfun$1() {
            this.p.success((Object)BoxedUnit.UNIT);
        }

        private final void cancel$$anonfun$1$$anonfun$2$$anonfun$1() {
            this.p.success((Object)BoxedUnit.UNIT);
        }

        private final Task cancel$$anonfun$1() {
            return this.waitsForResult.compareAndSet(true, false) ? this.releaseOnCancel(this.a).redeemWith((Function1 & Serializable)ex -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.cancel$$anonfun$1$$anonfun$1$$anonfun$1();
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)_$1 -> Task$.MODULE$.raiseError((Throwable)ex)), (Function1 & Serializable)_$2 -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.cancel$$anonfun$1$$anonfun$2$$anonfun$1();
                return BoxedUnit.UNIT;
            })) : TaskFromFuture$.MODULE$.strict(this.p.future());
        }

        private final Promise unsafeApply$$anonfun$1$$anonfun$1() {
            return this.p.success((Object)BoxedUnit.UNIT);
        }

        private final Object unsafeApply$$anonfun$2$$anonfun$1(Object b$3) {
            this.p.success((Object)BoxedUnit.UNIT);
            return b$3;
        }

        private final Promise unsafeRecover$$anonfun$1$$anonfun$1() {
            return this.p.success((Object)BoxedUnit.UNIT);
        }

        private final void unsafeRecover$$anonfun$2$$anonfun$1() {
            this.p.success((Object)BoxedUnit.UNIT);
        }
    }

    private static abstract class BaseStart<A, B>
    implements Function2<Task.Context, Callback<Throwable, B>, BoxedUnit> {
        private final Task<A> acquire;
        public final Function1<A, Task<B>> monix$eval$internal$TaskBracket$BaseStart$$use;

        public BaseStart(Task<A> acquire, Function1<A, Task<B>> use) {
            this.acquire = acquire;
            this.monix$eval$internal$TaskBracket$BaseStart$$use = use;
        }

        public abstract BaseReleaseFrame<A, B> makeReleaseFrame(Task.Context var1, A var2);

        public final void apply(Task.Context ctx, Callback<Throwable, B> cb) {
            ForwardCancelable deferredRelease = ForwardCancelable$.MODULE$.apply();
            ctx.connection().push(deferredRelease.cancel(), ctx.scheduler());
            Task$.MODULE$.unsafeStartNow(this.acquire, ctx.withConnection(TaskConnection$.MODULE$.uncancelable()), new Callback<Throwable, A>(ctx, cb, deferredRelease, this){
                private final Task.Context ctx$1;
                private final Callback cb$1;
                private final ForwardCancelable deferredRelease$1;
                private final /* synthetic */ BaseStart $outer;
                {
                    this.ctx$1 = ctx$2;
                    this.cb$1 = cb$2;
                    this.deferredRelease$1 = deferredRelease$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void onSuccess(Object value) {
                    Scheduler sc = this.ctx$1.scheduler();
                    TaskConnection conn = this.ctx$1.connection();
                    BaseReleaseFrame<Object, B> releaseFrame = this.$outer.makeReleaseFrame(this.ctx$1, value);
                    this.deferredRelease$1.complete(releaseFrame.cancel(), sc);
                    if (!conn.isCanceled()) {
                        Task fb = this.liftedTree1$1(value);
                        Task<B> onNext = fb.flatMap(releaseFrame);
                        Task$.MODULE$.unsafeStartNow(onNext, this.ctx$1, this.cb$1);
                    }
                }

                public void onError(Throwable ex) {
                    this.deferredRelease$1.complete(Task$.MODULE$.unit(), this.ctx$1.scheduler());
                    this.cb$1.onError((Object)ex);
                }

                private final Task liftedTree1$1(Object value$1) {
                    Task<A> task;
                    try {
                        task = (Task<A>)this.$outer.monix$eval$internal$TaskBracket$BaseStart$$use.apply(value$1);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e = throwable3 = (Throwable)option.get();
                            task = Task$.MODULE$.raiseError(e);
                        }
                        throw throwable;
                    }
                    return task;
                }
            });
        }
    }

    private static final class EnsureReleaseFrame<A>
    extends BaseReleaseFrame<BoxedUnit, A> {
        private final Function1<ExitCase<Throwable>, Task<BoxedUnit>> releaseFn;

        public EnsureReleaseFrame(Task.Context ctx, Function1<ExitCase<Throwable>, Task<BoxedUnit>> releaseFn) {
            this.releaseFn = releaseFn;
            super(ctx, BoxedUnit.UNIT);
        }

        @Override
        public Task<BoxedUnit> releaseOnSuccess(BoxedUnit a, A b) {
            return (Task)this.releaseFn.apply((Object)ExitCase.Completed$.MODULE$);
        }

        @Override
        public Task<BoxedUnit> releaseOnError(BoxedUnit a, Throwable e) {
            return (Task)this.releaseFn.apply((Object)ExitCase.Error$.MODULE$.apply((Object)e));
        }

        @Override
        public Task<BoxedUnit> releaseOnCancel(BoxedUnit a) {
            return (Task)this.releaseFn.apply((Object)ExitCase.Canceled$.MODULE$);
        }
    }

    private static final class ReleaseFrameCase<A, B>
    extends BaseReleaseFrame<A, B> {
        private final Function2<A, ExitCase<Throwable>, Task<BoxedUnit>> release;

        public ReleaseFrameCase(Task.Context ctx, A a, Function2<A, ExitCase<Throwable>, Task<BoxedUnit>> release) {
            this.release = release;
            super(ctx, a);
        }

        @Override
        public Task<BoxedUnit> releaseOnSuccess(A a, B b) {
            return (Task)this.release.apply(a, (Object)ExitCase.Completed$.MODULE$);
        }

        @Override
        public Task<BoxedUnit> releaseOnError(A a, Throwable e) {
            return (Task)this.release.apply(a, (Object)ExitCase.Error$.MODULE$.apply((Object)e));
        }

        @Override
        public Task<BoxedUnit> releaseOnCancel(A a) {
            return (Task)this.release.apply(a, (Object)ExitCase.Canceled$.MODULE$);
        }
    }

    private static final class ReleaseFrameE<A, B>
    extends BaseReleaseFrame<A, B> {
        private final Function2<A, Either<Option<Throwable>, B>, Task<BoxedUnit>> release;

        public ReleaseFrameE(Task.Context ctx, A a, Function2<A, Either<Option<Throwable>, B>, Task<BoxedUnit>> release) {
            this.release = release;
            super(ctx, a);
        }

        @Override
        public Task<BoxedUnit> releaseOnSuccess(A a, B b) {
            return (Task)this.release.apply(a, (Object)package$.MODULE$.Right().apply(b));
        }

        @Override
        public Task<BoxedUnit> releaseOnError(A a, Throwable e) {
            return (Task)this.release.apply(a, (Object)package$.MODULE$.Left().apply((Object)Some$.MODULE$.apply((Object)e)));
        }

        @Override
        public Task<BoxedUnit> releaseOnCancel(A a) {
            return (Task)this.release.apply(a, TaskBracket$.monix$eval$internal$TaskBracket$$$leftNone);
        }
    }

    private static final class ReleaseRecover
    extends StackFrame<BoxedUnit, Task<Nothing$>> {
        private final Throwable e;

        public ReleaseRecover(Throwable e) {
            this.e = e;
        }

        @Override
        public Task<Nothing$> apply(BoxedUnit a) {
            return Task$.MODULE$.raiseError(this.e);
        }

        @Override
        public Task<Nothing$> recover(Throwable e2) {
            return Task$.MODULE$.raiseError(Platform$.MODULE$.composeErrors(this.e, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Throwable[]{e2})));
        }
    }

    private static final class ReleaseStart<A>
    implements Function2<Task.Context, Callback<Throwable, A>, BoxedUnit> {
        private final Task<A> source;
        private final Function1<ExitCase<Throwable>, Task<BoxedUnit>> release;

        public ReleaseStart(Task<A> source, Function1<ExitCase<Throwable>, Task<BoxedUnit>> release) {
            this.source = source;
            this.release = release;
        }

        public void apply(Task.Context ctx, Callback<Throwable, A> cb) {
            Scheduler s = ctx.scheduler();
            TaskConnection conn = ctx.connection();
            EnsureReleaseFrame frame = new EnsureReleaseFrame(ctx, this.release);
            Task onNext = this.source.flatMap(frame);
            conn.push(frame.cancel(), s);
            if (!conn.isCanceled()) {
                Task$.MODULE$.unsafeStartNow(onNext, ctx, cb);
            }
        }
    }

    private static final class StartCase<A, B>
    extends BaseStart<A, B> {
        private final Function2<A, ExitCase<Throwable>, Task<BoxedUnit>> release;

        public StartCase(Task<A> acquire, Function1<A, Task<B>> use, Function2<A, ExitCase<Throwable>, Task<BoxedUnit>> release) {
            this.release = release;
            super(acquire, use);
        }

        @Override
        public BaseReleaseFrame<A, B> makeReleaseFrame(Task.Context ctx, A value) {
            return new ReleaseFrameCase(ctx, value, this.release);
        }
    }

    private static final class StartE<A, B>
    extends BaseStart<A, B> {
        private final Function2<A, Either<Option<Throwable>, B>, Task<BoxedUnit>> release;

        public StartE(Task<A> acquire, Function1<A, Task<B>> use, Function2<A, Either<Option<Throwable>, B>, Task<BoxedUnit>> release) {
            this.release = release;
            super(acquire, use);
        }

        @Override
        public BaseReleaseFrame<A, B> makeReleaseFrame(Task.Context ctx, A value) {
            return new ReleaseFrameE<A, B>(ctx, value, this.release);
        }
    }
}

