/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.tracing;

import java.io.Serializable;
import monix.eval.tracing.TaskEvent;
import monix.eval.tracing.TaskTrace;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class TaskTrace$
implements Mirror.Product,
Serializable {
    private static final Regex anonfunRegex;
    private static final List<String> stackTraceFilter;
    public static final TaskTrace$ MODULE$;

    private TaskTrace$() {
    }

    static {
        MODULE$ = new TaskTrace$();
        anonfunRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\$+anonfun\\$+(.+)\\$+\\d+$"));
        stackTraceFilter = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"monix.", "cats.effect.", "cats.", "sbt.", "java.", "sun.", "scala."}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TaskTrace$.class);
    }

    public TaskTrace apply(List<TaskEvent> events, int captured, int omitted) {
        return new TaskTrace(events, captured, omitted);
    }

    public TaskTrace unapply(TaskTrace x$1) {
        return x$1;
    }

    public String toString() {
        return "TaskTrace";
    }

    public Option<Tuple2<StackTraceElement, StackTraceElement>> getOpAndCallSite(List<StackTraceElement> frames) {
        return frames.sliding(2).collect((PartialFunction)new Serializable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List x) {
                List list = x;
                if (!(list instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list;
                List list2 = colon2.next$access$1();
                StackTraceElement a = (StackTraceElement)colon2.head();
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon3 = (.colon.colon)list2;
                List list3 = colon3.next$access$1();
                StackTraceElement b = (StackTraceElement)colon3.head();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list4 = list3;
                if (nil$ != null) {
                    if (!nil$.equals(list4)) return false;
                    return true;
                }
                if (list4 == null) return true;
                return false;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(List x, Function1 function1) {
                Object object;
                List list = x;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    StackTraceElement a = (StackTraceElement)colon2.head();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        List list3 = colon3.next$access$1();
                        StackTraceElement b = (StackTraceElement)colon3.head();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list4 = list3;
                        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                            object = Tuple2$.MODULE$.apply((Object)a, (Object)b);
                            return object;
                        }
                    }
                }
                object = function1.apply((Object)x);
                return object;
            }
        }).find((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
            } else {
                throw new MatchError((Object)tuple2);
            }
            StackTraceElement callSite = (StackTraceElement)tuple2._2();
            return !stackTraceFilter.exists((Function1 & Serializable)_$1 -> callSite.getClassName().startsWith((String)_$1));
        });
    }

    public String monix$eval$tracing$TaskTrace$$$renderStackTraceElement(StackTraceElement ste) {
        String methodName = this.demangleMethod(ste.getMethodName());
        return new StringBuilder(5).append(ste.getClassName()).append(".").append(methodName).append(" (").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")").toString();
    }

    private String demangleMethod(String methodName) {
        String string;
        Option option = anonfunRegex.findFirstMatchIn((CharSequence)methodName);
        if (option instanceof Some) {
            Regex.Match mat = (Regex.Match)((Some)option).value();
            string = mat.group(1);
        } else if (None$.MODULE$.equals(option)) {
            string = methodName;
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public TaskTrace fromProduct(Product x$0) {
        return new TaskTrace((List<TaskEvent>)((List)x$0.productElement(0)), BoxesRunTime.unboxToInt((Object)x$0.productElement(1)), BoxesRunTime.unboxToInt((Object)x$0.productElement(2)));
    }
}

