/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.tracing;

import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.eval.tracing.PrintingOptions;
import monix.eval.tracing.PrintingOptions$;
import monix.eval.tracing.TaskEvent;
import monix.eval.tracing.TaskTrace$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class TaskTrace
implements Product,
Serializable {
    private final List events;
    private final int captured;
    private final int omitted;

    public static TaskTrace apply(List<TaskEvent> list, int n, int n2) {
        return TaskTrace$.MODULE$.apply(list, n, n2);
    }

    public static TaskTrace fromProduct(Product product) {
        return TaskTrace$.MODULE$.fromProduct(product);
    }

    public static Option<Tuple2<StackTraceElement, StackTraceElement>> getOpAndCallSite(List<StackTraceElement> list) {
        return TaskTrace$.MODULE$.getOpAndCallSite(list);
    }

    public static TaskTrace unapply(TaskTrace taskTrace) {
        return TaskTrace$.MODULE$.unapply(taskTrace);
    }

    public TaskTrace(List<TaskEvent> events, int captured, int omitted) {
        this.events = events;
        this.captured = captured;
        this.omitted = omitted;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.events()));
        n = Statics.mix((int)n, (int)this.captured());
        n = Statics.mix((int)n, (int)this.omitted());
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TaskTrace)) return false;
        TaskTrace taskTrace = (TaskTrace)object;
        if (this.captured() != taskTrace.captured()) return false;
        if (this.omitted() != taskTrace.omitted()) return false;
        List<TaskEvent> list = this.events();
        List<TaskEvent> list2 = taskTrace.events();
        if (list != null) {
            if (!list.equals(list2)) return false;
            return true;
        }
        if (list2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TaskTrace;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "TaskTrace";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this._2());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this._3());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "events";
                break;
            }
            case 1: {
                string = "captured";
                break;
            }
            case 2: {
                string = "omitted";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public List<TaskEvent> events() {
        return this.events;
    }

    public int captured() {
        return this.captured;
    }

    public int omitted() {
        return this.omitted;
    }

    public Task<BoxedUnit> printFiberTrace(PrintingOptions options) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.printFiberTrace$$anonfun$1(options);
            return BoxedUnit.UNIT;
        });
    }

    public PrintingOptions printFiberTrace$default$1() {
        return PrintingOptions$.MODULE$.Default();
    }

    public String showFiberTrace(PrintingOptions options) {
        String string;
        String TurnRight = "\u2570";
        String InverseTurnRight = "\u256d";
        String Junction = "\u251c";
        String Line = "\u2502";
        String acc0 = new StringBuilder(28).append("TaskTrace: ").append(this.captured()).append(" frames captured\n").toString();
        if (options.showFullStackTraces()) {
            List stackTraces = this.events().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(TaskEvent x) {
                    boolean bl;
                    TaskEvent taskEvent = x;
                    if (taskEvent instanceof TaskEvent.StackTrace) {
                        TaskEvent.StackTrace e = (TaskEvent.StackTrace)taskEvent;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(TaskEvent x, Function1 function1) {
                    Object object;
                    TaskEvent taskEvent = x;
                    if (taskEvent instanceof TaskEvent.StackTrace) {
                        TaskEvent.StackTrace e = (TaskEvent.StackTrace)taskEvent;
                        object = e;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            });
            String acc1 = ((List)stackTraces.zipWithIndex()).map((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TaskEvent.StackTrace st = (TaskEvent.StackTrace)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                String tag = (String)TaskTrace$.MODULE$.getOpAndCallSite(st.stackTrace()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StackTraceElement methodSite = (StackTraceElement)tuple2._1();
                    return NameTransformer$.MODULE$.decode(methodSite.getMethodName());
                }).getOrElse(TaskTrace::$anonfun$3);
                String op = index == 0 ? new StringBuilder(2).append(InverseTurnRight).append(" ").append(tag).append("\n").toString() : new StringBuilder(2).append(Junction).append(" ").append(tag).append("\n").toString();
                List relevantLines = st.stackTrace().slice(options.ignoreStackTraceLines(), options.ignoreStackTraceLines() + options.maxStackTraceLines());
                String lines = ((List)relevantLines.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StackTraceElement ste = (StackTraceElement)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    String junc = i == relevantLines.length() - 1 ? TurnRight : Junction;
                    String codeLine = TaskTrace$.MODULE$.monix$eval$tracing$TaskTrace$$$renderStackTraceElement(ste);
                    return new StringBuilder(3).append(Line).append("  ").append(junc).append(" ").append(codeLine).toString();
                }).mkString("", "\n", "\n");
                return new StringBuilder(0).append(op).append(lines).append(Line).toString();
            }).mkString("\n");
            String acc2 = this.omitted() > 0 ? new StringBuilder(1).append("\n").append(TurnRight).append(new StringBuilder(23).append(" ... (").append(this.omitted()).append(" frames omitted)\n").toString()).toString() : new StringBuilder(2).append("\n").append(TurnRight).append("\n").toString();
            string = new StringBuilder(0).append(acc0).append(acc1).append(acc2).toString();
        } else {
            String acc1 = ((List)this.events().zipWithIndex()).map((Function1 & Serializable)x$12 -> {
                TaskEvent.StackTrace ev;
                String junc;
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    TaskEvent event = (TaskEvent)tuple2._1();
                    int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    junc = index == this.events().length() - 1 && this.omitted() == 0 ? TurnRight : Junction;
                    TaskEvent taskEvent = event;
                    if (!(taskEvent instanceof TaskEvent.StackTrace)) {
                        throw new MatchError((Object)taskEvent);
                    }
                    ev = (TaskEvent.StackTrace)taskEvent;
                } else {
                    throw new MatchError((Object)tuple2);
                }
                String message = (String)TaskTrace$.MODULE$.getOpAndCallSite(ev.stackTrace()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StackTraceElement methodSite = (StackTraceElement)tuple2._1();
                    StackTraceElement callSite = (StackTraceElement)tuple2._2();
                    String loc = TaskTrace$.MODULE$.monix$eval$tracing$TaskTrace$$$renderStackTraceElement(callSite);
                    String op = NameTransformer$.MODULE$.decode(methodSite.getMethodName());
                    return new StringBuilder(3).append(op).append(" @ ").append(loc).toString();
                }).getOrElse(TaskTrace::$anonfun$7);
                return new StringBuilder(2).append(" ").append(junc).append(" ").append(message).toString();
            }).mkString(acc0, "\n", "");
            String acc2 = this.omitted() > 0 ? new StringBuilder(2).append(acc1).append("\n ").append(TurnRight).append(new StringBuilder(22).append(" ... (").append(this.omitted()).append(" frames omitted)").toString()).toString() : acc1;
            string = new StringBuilder(1).append(acc2).append("\n").toString();
        }
        return string;
    }

    public PrintingOptions showFiberTrace$default$1() {
        return PrintingOptions$.MODULE$.Default();
    }

    public TaskTrace copy(List<TaskEvent> events, int captured, int omitted) {
        return new TaskTrace(events, captured, omitted);
    }

    public List<TaskEvent> copy$default$1() {
        return this.events();
    }

    public int copy$default$2() {
        return this.captured();
    }

    public int copy$default$3() {
        return this.omitted();
    }

    public List<TaskEvent> _1() {
        return this.events();
    }

    public int _2() {
        return this.captured();
    }

    public int _3() {
        return this.omitted();
    }

    private final void printFiberTrace$$anonfun$1(PrintingOptions options$1) {
        System.err.println(this.showFiberTrace(options$1));
    }

    private static final String $anonfun$3() {
        return "(...)";
    }

    private static final String $anonfun$7() {
        return "(...)";
    }
}

