/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internals.atomic;

import java.lang.reflect.Field;
import monix.execution.internals.atomic.BoxedLong;
import monix.execution.internals.atomic.UnsafeAccess;
import sun.misc.Unsafe;

final class NormalJava7BoxedLong
implements BoxedLong {
    public volatile long value;
    private static final long OFFSET;
    private static final Unsafe UNSAFE;

    NormalJava7BoxedLong(long l) {
        this.value = l;
    }

    @Override
    public long volatileGet() {
        return this.value;
    }

    @Override
    public void volatileSet(long l) {
        this.value = l;
    }

    @Override
    public void lazySet(long l) {
        UNSAFE.putOrderedLong(this, OFFSET, l);
    }

    @Override
    public boolean compareAndSet(long l, long l2) {
        return UNSAFE.compareAndSwapLong(this, OFFSET, l, l2);
    }

    @Override
    public long getAndSet(long l) {
        long l2 = this.value;
        while (!UNSAFE.compareAndSwapLong(this, OFFSET, l2, l)) {
            l2 = this.value;
        }
        return l2;
    }

    @Override
    public long getAndAdd(long l) {
        long l2;
        while (!UNSAFE.compareAndSwapLong(this, OFFSET, l2 = UNSAFE.getLongVolatile(this, OFFSET), l2 + l)) {
        }
        return l2;
    }

    static {
        UNSAFE = (Unsafe)UnsafeAccess.getInstance();
        try {
            Field field = NormalJava7BoxedLong.class.getDeclaredField("value");
            OFFSET = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

