/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.collection.queues;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import monix.execution.BufferCapacity;
import monix.execution.ChannelType;
import monix.execution.ChannelType$MPMC$;
import monix.execution.ChannelType$MPSC$;
import monix.execution.ChannelType$SPMC$;
import monix.execution.ChannelType$SPSC$;
import monix.execution.internal.Platform$;
import monix.execution.internal.atomic.UnsafeAccess;
import monix.execution.internal.collection.LowLevelConcurrentQueue;
import monix.execution.internal.collection.queues.FromCircularQueue;
import monix.execution.internal.collection.queues.FromCircularQueue$;
import monix.execution.internal.collection.queues.FromJavaQueue;
import monix.execution.internal.collection.queues.FromMessagePassingQueue;
import monix.execution.internal.collection.queues.FromMessagePassingQueue$;
import monix.execution.internal.jctools.queues.MpmcArrayQueue;
import monix.execution.internal.jctools.queues.MpscArrayQueue;
import monix.execution.internal.jctools.queues.MpscUnboundedArrayQueue;
import monix.execution.internal.jctools.queues.SpmcArrayQueue;
import monix.execution.internal.jctools.queues.SpscArrayQueue;
import monix.execution.internal.jctools.queues.SpscUnboundedArrayQueue;
import monix.execution.internal.jctools.queues.atomic.MpmcAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.MpscAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.MpscUnboundedAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.SpmcAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.SpscAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.SpscUnboundedAtomicArrayQueue;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005e3\u0001\"\u0002\u0004\u0011\u0002\u0007\u0005!\u0002\u0005\u0005\u0006/\u0001!\t!\u0007\u0005\u0006;\u0001!\tA\b\u0005\u0006\u007f\u0001!I\u0001\u0011\u0005\u0006\u0019\u0002!I!\u0014\u0002 \u0019><H*\u001a<fY\u000e{gnY;se\u0016tG/U;fk\u0016\u0014U/\u001b7eKJ\u001c(BA\u0004\t\u0003\u0019\tX/Z;fg*\u0011\u0011BC\u0001\u000bG>dG.Z2uS>t'BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003%)\u00070Z2vi&|gNC\u0001\u0010\u0003\u0015iwN\\5y'\t\u0001\u0011\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0004\u0001Q\t!\u0004\u0005\u0002\u00137%\u0011Ad\u0005\u0002\u0005+:LG/A\u0003baBd\u00170\u0006\u0002 MQ!\u0001eL\u001b;!\r\t#\u0005J\u0007\u0002\u0011%\u00111\u0005\u0003\u0002\u0018\u0019><H*\u001a<fY\u000e{gnY;se\u0016tG/U;fk\u0016\u0004\"!\n\u0014\r\u0001\u0011)qE\u0001b\u0001Q\t\t\u0011)\u0005\u0002*YA\u0011!CK\u0005\u0003WM\u0011qAT8uQ&tw\r\u0005\u0002\u0013[%\u0011af\u0005\u0002\u0004\u0003:L\b\"\u0002\u0019\u0003\u0001\u0004\t\u0014\u0001C2ba\u0006\u001c\u0017\u000e^=\u0011\u0005I\u001aT\"\u0001\u0007\n\u0005Qb!A\u0004\"vM\u001a,'oQ1qC\u000eLG/\u001f\u0005\u0006m\t\u0001\raN\u0001\fG\"\fgN\\3m)f\u0004X\r\u0005\u00023q%\u0011\u0011\b\u0004\u0002\f\u0007\"\fgN\\3m)f\u0004X\rC\u0003<\u0005\u0001\u0007A(\u0001\u0004gK:\u001cW\r\u001a\t\u0003%uJ!AP\n\u0003\u000f\t{w\u000e\\3b]\u00069!m\\;oI\u0016$WCA!E)\u0011\u0011U)S&\u0011\u0007\u0005\u00123\t\u0005\u0002&\t\u0012)qe\u0001b\u0001Q!)\u0001g\u0001a\u0001\rB\u0011!cR\u0005\u0003\u0011N\u00111!\u00138u\u0011\u0015Q5\u00011\u00018\u0003\t\u0019G\u000fC\u0003<\u0007\u0001\u0007A(A\u0005v]\n|WO\u001c3fIV\u0011a*\u0015\u000b\u0005\u001fJ;\u0006\fE\u0002\"EA\u0003\"!J)\u0005\u000b\u001d\"!\u0019\u0001\u0015\t\u000bM#\u0001\u0019\u0001+\u0002\u0013\rDWO\\6TSj,\u0007c\u0001\nV\r&\u0011ak\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b)#\u0001\u0019A\u001c\t\u000bm\"\u0001\u0019\u0001\u001f")
public interface LowLevelConcurrentQueueBuilders {
    public static /* synthetic */ LowLevelConcurrentQueue apply$(LowLevelConcurrentQueueBuilders $this, BufferCapacity capacity, ChannelType channelType, boolean fenced) {
        return $this.apply(capacity, channelType, fenced);
    }

    default public <A> LowLevelConcurrentQueue<A> apply(BufferCapacity capacity, ChannelType channelType, boolean fenced) {
        LowLevelConcurrentQueue<A> lowLevelConcurrentQueue;
        BufferCapacity bufferCapacity = capacity;
        if (bufferCapacity instanceof BufferCapacity.Bounded) {
            BufferCapacity.Bounded bounded = (BufferCapacity.Bounded)bufferCapacity;
            int c = bounded.capacity();
            lowLevelConcurrentQueue = this.bounded(c, channelType, fenced);
        } else if (bufferCapacity instanceof BufferCapacity.Unbounded) {
            BufferCapacity.Unbounded unbounded = (BufferCapacity.Unbounded)bufferCapacity;
            Option<Object> hint = unbounded.chunkSizeHint();
            lowLevelConcurrentQueue = this.unbounded(hint, channelType, fenced);
        } else {
            throw new MatchError((Object)bufferCapacity);
        }
        return lowLevelConcurrentQueue;
    }

    private <A> LowLevelConcurrentQueue<A> bounded(int capacity, ChannelType ct, boolean fenced) {
        LowLevelConcurrentQueue lowLevelConcurrentQueue;
        if (UnsafeAccess.IS_OPENJDK_COMPATIBLE) {
            if (UnsafeAccess.HAS_JAVA8_INTRINSICS || !fenced) {
                FromCircularQueue fromCircularQueue;
                ChannelType channelType = ct;
                if (ChannelType$MPMC$.MODULE$.equals(channelType)) {
                    fromCircularQueue = FromCircularQueue$.MODULE$.apply(new MpmcArrayQueue(capacity), ct);
                } else if (ChannelType$MPSC$.MODULE$.equals(channelType)) {
                    fromCircularQueue = FromCircularQueue$.MODULE$.apply(new MpscArrayQueue(capacity), ct);
                } else if (ChannelType$SPMC$.MODULE$.equals(channelType)) {
                    fromCircularQueue = FromCircularQueue$.MODULE$.apply(new SpmcArrayQueue(capacity), ct);
                } else if (ChannelType$SPSC$.MODULE$.equals(channelType)) {
                    fromCircularQueue = FromCircularQueue$.MODULE$.apply(new SpscArrayQueue(capacity), ct);
                } else {
                    throw new MatchError((Object)channelType);
                }
                lowLevelConcurrentQueue = fromCircularQueue;
            } else {
                lowLevelConcurrentQueue = FromCircularQueue$.MODULE$.apply(new MpmcArrayQueue(capacity), ct);
            }
        } else if (UnsafeAccess.HAS_JAVA8_INTRINSICS || !fenced) {
            FromMessagePassingQueue fromMessagePassingQueue;
            ChannelType channelType = ct;
            if (ChannelType$MPMC$.MODULE$.equals(channelType)) {
                fromMessagePassingQueue = FromMessagePassingQueue$.MODULE$.apply(new MpmcAtomicArrayQueue(capacity), ct);
            } else if (ChannelType$MPSC$.MODULE$.equals(channelType)) {
                fromMessagePassingQueue = FromMessagePassingQueue$.MODULE$.apply(new MpscAtomicArrayQueue(capacity), ct);
            } else if (ChannelType$SPMC$.MODULE$.equals(channelType)) {
                fromMessagePassingQueue = FromMessagePassingQueue$.MODULE$.apply(new SpmcAtomicArrayQueue(capacity), ct);
            } else if (ChannelType$SPSC$.MODULE$.equals(channelType)) {
                fromMessagePassingQueue = FromMessagePassingQueue$.MODULE$.apply(new SpscAtomicArrayQueue(capacity), ct);
            } else {
                throw new MatchError((Object)channelType);
            }
            lowLevelConcurrentQueue = fromMessagePassingQueue;
        } else {
            lowLevelConcurrentQueue = FromMessagePassingQueue$.MODULE$.apply(new MpmcAtomicArrayQueue(capacity), ct);
        }
        return lowLevelConcurrentQueue;
    }

    private <A> LowLevelConcurrentQueue<A> unbounded(Option<Object> chunkSize, ChannelType ct, boolean fenced) {
        LowLevelConcurrentQueue<Object> lowLevelConcurrentQueue;
        int chunk = BoxesRunTime.unboxToInt((Object)chunkSize.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Platform$.MODULE$.recommendedBufferChunkSize()));
        if (UnsafeAccess.IS_OPENJDK_COMPATIBLE) {
            if (UnsafeAccess.HAS_JAVA8_INTRINSICS || !fenced) {
                ChannelType channelType = ct;
                LowLevelConcurrentQueue<Object> lowLevelConcurrentQueue2 = ChannelType$MPSC$.MODULE$.equals(channelType) ? FromMessagePassingQueue$.MODULE$.apply(new MpscUnboundedArrayQueue(chunk), ct) : (ChannelType$SPSC$.MODULE$.equals(channelType) ? FromMessagePassingQueue$.MODULE$.apply(new SpscUnboundedArrayQueue(chunk), ct) : new FromJavaQueue(new ConcurrentLinkedQueue()));
                lowLevelConcurrentQueue = lowLevelConcurrentQueue2;
            } else {
                lowLevelConcurrentQueue = new FromJavaQueue(new ConcurrentLinkedQueue());
            }
        } else if (UnsafeAccess.HAS_JAVA8_INTRINSICS || !fenced) {
            ChannelType channelType = ct;
            LowLevelConcurrentQueue<Object> lowLevelConcurrentQueue3 = ChannelType$MPSC$.MODULE$.equals(channelType) ? FromMessagePassingQueue$.MODULE$.apply(new MpscUnboundedAtomicArrayQueue(chunk), ct) : (ChannelType$SPSC$.MODULE$.equals(channelType) ? FromMessagePassingQueue$.MODULE$.apply(new SpscUnboundedAtomicArrayQueue(chunk), ct) : new FromJavaQueue(new ConcurrentLinkedQueue()));
            lowLevelConcurrentQueue = lowLevelConcurrentQueue3;
        } else {
            lowLevelConcurrentQueue = new FromJavaQueue(new ConcurrentLinkedQueue());
        }
        return lowLevelConcurrentQueue;
    }

    public static void $init$(LowLevelConcurrentQueueBuilders $this) {
    }
}

