/*
 * Decompiled with CFR 0.152.
 */
package monix.execution;

import java.io.Serializable;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture;
import monix.execution.CancelableFuture$;
import monix.execution.CancelablePromise$;
import monix.execution.CancelablePromise$MapQueue$;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicAny$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.internal.Platform$;
import monix.execution.internal.exceptions$;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.LongMap;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Try;
import scala.util.control.NonFatal$;

public abstract class CancelablePromise<A>
implements Promise<A> {
    public static <A> CancelablePromise<A> apply(PaddingStrategy paddingStrategy) {
        return CancelablePromise$.MODULE$.apply(paddingStrategy);
    }

    public static <A> CancelablePromise<A> failed(Throwable throwable) {
        return CancelablePromise$.MODULE$.failed(throwable);
    }

    public static <A> CancelablePromise<A> fromTry(Try<A> try_) {
        return CancelablePromise$.MODULE$.fromTry(try_);
    }

    public static <A> CancelablePromise<A> successful(A a) {
        return CancelablePromise$.MODULE$.successful(a);
    }

    public static <A> PaddingStrategy apply$default$1() {
        return CancelablePromise$.MODULE$.apply$default$1();
    }

    public CancelablePromise() {
        Promise.$init$((Promise)this);
    }

    public abstract CancelableFuture<A> future();

    public abstract Cancelable subscribe(Function1<Try<A>, BoxedUnit> var1);

    private static final class Async<A>
    extends CancelablePromise<A> {
        public final AtomicAny<Object> monix$execution$CancelablePromise$Async$$state;

        public Async(PaddingStrategy ps) {
            this.monix$execution$CancelablePromise$Async$$state = AtomicAny$.MODULE$.withPadding(CancelablePromise$.monix$execution$CancelablePromise$$$emptyMapQueue, ps);
        }

        @Override
        public Cancelable subscribe(Function1<Try<A>, BoxedUnit> cb) {
            return this.unsafeSubscribe(cb);
        }

        public boolean isCompleted() {
            return this.monix$execution$CancelablePromise$Async$$state.get() instanceof Try;
        }

        @Override
        public CancelableFuture<A> future() {
            CancelableFuture cancelableFuture;
            Object object = this.monix$execution$CancelablePromise$Async$$state.get();
            if (object instanceof Try) {
                Try ref = (Try)object;
                cancelableFuture = CancelableFuture$.MODULE$.fromTry(ref);
            } else if (object instanceof MapQueue) {
                MapQueue queue = (MapQueue)object;
                Promise p = Promise$.MODULE$.apply();
                Tuple2<Object, MapQueue<Promise>> tuple2 = queue.enqueue(p);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long id = BoxesRunTime.unboxToLong((Object)tuple2._1());
                MapQueue update = (MapQueue)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)id), (Object)update);
                long id2 = BoxesRunTime.unboxToLong((Object)tuple22._1());
                MapQueue update2 = (MapQueue)tuple22._2();
                Cancelable cancelable = !this.monix$execution$CancelablePromise$Async$$state.compareAndSet(queue, update2) ? this.unsafeSubscribe(p) : new IdCancelable(this, id2);
                cancelableFuture = CancelableFuture$.MODULE$.apply(p.future(), cancelable);
            } else {
                Object other = object;
                throw exceptions$.MODULE$.matchError(other);
            }
            return cancelableFuture;
        }

        public boolean tryComplete(Try<A> result) {
            boolean bl;
            block10: {
                Object object;
                Async async = this;
                while ((object = async.monix$execution$CancelablePromise$Async$$state.get()) instanceof MapQueue) {
                    MapQueue queue = (MapQueue)object;
                    if (!async.monix$execution$CancelablePromise$Async$$state.compareAndSet(queue, result)) continue;
                    if (queue == CancelablePromise$.monix$execution$CancelablePromise$$$emptyMapQueue) {
                        bl = true;
                    } else {
                        ListBuffer errors = null;
                        Iterator cursor = queue.iterator();
                        while (cursor.hasNext()) {
                            Object cb = cursor.next();
                            try {
                                async.call(cb, result);
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2;
                                Throwable e = throwable2 = throwable;
                                if (NonFatal$.MODULE$.apply(e)) {
                                    if (errors == null) {
                                        errors = ListBuffer$.MODULE$.empty();
                                    }
                                    errors.$plus$eq((Object)e);
                                    continue;
                                }
                                throw throwable;
                            }
                        }
                        if (errors != null) {
                            List list = errors.toList();
                            if (!(list instanceof .colon.colon)) {
                                throw new MatchError((Object)list);
                            }
                            .colon.colon colon2 = (.colon.colon)list;
                            List list2 = colon2.next$access$1();
                            Throwable x = (Throwable)colon2.head();
                            List xs = list2;
                            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x, (Object)xs);
                            Throwable x2 = (Throwable)tuple2._1();
                            List xs2 = (List)tuple2._2();
                            throw Platform$.MODULE$.composeErrors(x2, (Seq<Throwable>)xs2);
                        }
                        bl = true;
                    }
                    break block10;
                }
                bl = false;
            }
            return bl;
        }

        private void call(Object cb, Try<A> result) {
            Object object = cb;
            if (object instanceof Function1) {
                Function1 f = (Function1)object;
                f.apply(result);
            } else if (object instanceof Promise) {
                Promise p = (Promise)object;
                p.complete(result);
            } else {
                Object other = object;
                throw exceptions$.MODULE$.matchError(other);
            }
        }

        public Cancelable unsafeSubscribe(Object cb) {
            Cancelable cancelable;
            block3: {
                Object object;
                block4: {
                    long id;
                    MapQueue update;
                    MapQueue queue;
                    Async async = this;
                    do {
                        if ((object = async.monix$execution$CancelablePromise$Async$$state.get()) instanceof Try) {
                            Try ref = (Try)object;
                            async.call(cb, ref);
                            cancelable = Cancelable$.MODULE$.empty();
                            break block3;
                        }
                        if (!(object instanceof MapQueue)) break block4;
                        queue = (MapQueue)object;
                        Tuple2<Object, MapQueue<Object>> tuple2 = queue.enqueue(cb);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        long id2 = BoxesRunTime.unboxToLong((Object)tuple2._1());
                        MapQueue update2 = (MapQueue)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)id2), (Object)update2);
                        id = BoxesRunTime.unboxToLong((Object)tuple22._1());
                        update = (MapQueue)tuple22._2();
                    } while (!async.monix$execution$CancelablePromise$Async$$state.compareAndSet(queue, update));
                    cancelable = new IdCancelable(async, id);
                    break block3;
                }
                Object other = object;
                throw exceptions$.MODULE$.matchError(other);
            }
            return cancelable;
        }

        private final class IdCancelable
        implements Cancelable {
            private final long id;
            private final /* synthetic */ Async $outer;

            public IdCancelable(Async $outer, long id) {
                this.id = id;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            @Override
            public void cancel() {
                MapQueue queue;
                Object object;
                IdCancelable idCancelable = this;
                while ((object = idCancelable.$outer.monix$execution$CancelablePromise$Async$$state.get()) instanceof MapQueue && !idCancelable.$outer.monix$execution$CancelablePromise$Async$$state.compareAndSet(queue = (MapQueue)object, queue.dequeue(idCancelable.id))) {
                }
            }

            public final /* synthetic */ Async monix$execution$CancelablePromise$Async$IdCancelable$$$outer() {
                return this.$outer;
            }
        }
    }

    private static final class Completed<A>
    extends CancelablePromise<A> {
        private final Try<A> value;

        public Completed(Try<A> value) {
            this.value = value;
        }

        @Override
        public CancelableFuture<A> future() {
            return CancelableFuture$.MODULE$.fromTry(this.value);
        }

        @Override
        public Cancelable subscribe(Function1<Try<A>, BoxedUnit> cb) {
            cb.apply(this.value);
            return Cancelable$.MODULE$.empty();
        }

        public boolean isCompleted() {
            return true;
        }

        public boolean tryComplete(Try<A> result) {
            return false;
        }
    }

    private static final class MapQueue<A>
    implements Iterable<A>,
    Product,
    Serializable {
        private final LongMap map;
        private final long nextId;

        public static <A> MapQueue<A> apply(LongMap<A> longMap, long l) {
            return CancelablePromise$MapQueue$.MODULE$.apply(longMap, l);
        }

        public static MapQueue<?> fromProduct(Product product) {
            return CancelablePromise$MapQueue$.MODULE$.fromProduct(product);
        }

        public static <A> MapQueue<A> unapply(MapQueue<A> mapQueue) {
            return CancelablePromise$MapQueue$.MODULE$.unapply(mapQueue);
        }

        public MapQueue(LongMap<A> map, long nextId) {
            this.map = map;
            this.nextId = nextId;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            IterableOps.$init$((IterableOps)this);
            IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
            Iterable.$init$((Iterable)this);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.map()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.nextId()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MapQueue)) return false;
            MapQueue mapQueue = (MapQueue)object;
            if (this.nextId() != mapQueue.nextId()) return false;
            LongMap<A> longMap = this.map();
            LongMap<A> longMap2 = mapQueue.map();
            if (longMap != null) {
                if (!longMap.equals(longMap2)) return false;
                return true;
            }
            if (longMap2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof MapQueue;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MapQueue";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = BoxesRunTime.boxToLong((long)this._2());
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "map";
            } else if (1 == n2) {
                string = "nextId";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public LongMap<A> map() {
            return this.map;
        }

        public long nextId() {
            return this.nextId;
        }

        public <AA> Tuple2<Object, MapQueue<AA>> enqueue(AA elem) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.nextId()), CancelablePromise$MapQueue$.MODULE$.apply(this.map().updated(this.nextId(), elem), this.nextId() + 1L));
        }

        public MapQueue<A> dequeue(long id) {
            return CancelablePromise$MapQueue$.MODULE$.apply((LongMap)this.map().$minus((Object)BoxesRunTime.boxToLong((long)id)), this.nextId());
        }

        public Iterator<A> iterator() {
            return this.map().valuesIterator();
        }

        public <A> MapQueue<A> copy(LongMap<A> map, long nextId) {
            return new MapQueue<A>(map, nextId);
        }

        public <A> LongMap<A> copy$default$1() {
            return this.map();
        }

        public long copy$default$2() {
            return this.nextId();
        }

        public LongMap<A> _1() {
            return this.map();
        }

        public long _2() {
            return this.nextId();
        }
    }
}

