/*
 * Decompiled with CFR 0.152.
 */
package monix.execution;

import java.io.Serializable;
import monix.execution.ExecutionModel$;
import monix.execution.ExecutionModel$BatchedExecution$;
import monix.execution.ExecutionModel$Extensions$;
import monix.execution.internal.math$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class ExecutionModel
implements Product,
Serializable {
    public static ExecutionModel Default() {
        return ExecutionModel$.MODULE$.Default();
    }

    public static ExecutionModel Extensions(ExecutionModel executionModel) {
        return ExecutionModel$.MODULE$.Extensions(executionModel);
    }

    public static int ordinal(ExecutionModel executionModel) {
        return ExecutionModel$.MODULE$.ordinal(executionModel);
    }

    public abstract int recommendedBatchSize();

    public abstract int batchedExecutionModulus();

    public abstract int nextFrameIndex(int var1);

    public static final class BatchedExecution
    extends ExecutionModel {
        private final int batchSize;
        private final int recommendedBatchSize;
        private final int batchedExecutionModulus;

        public static BatchedExecution apply(int n) {
            return ExecutionModel$BatchedExecution$.MODULE$.apply(n);
        }

        public static BatchedExecution fromProduct(Product product) {
            return ExecutionModel$BatchedExecution$.MODULE$.fromProduct(product);
        }

        public static BatchedExecution unapply(BatchedExecution batchedExecution) {
            return ExecutionModel$BatchedExecution$.MODULE$.unapply(batchedExecution);
        }

        public BatchedExecution(int batchSize) {
            this.batchSize = batchSize;
            this.recommendedBatchSize = math$.MODULE$.nextPowerOf2(batchSize);
            this.batchedExecutionModulus = this.recommendedBatchSize() - 1;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.batchSize());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BatchedExecution)) return false;
            BatchedExecution batchedExecution = (BatchedExecution)object;
            if (this.batchSize() != batchedExecution.batchSize()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BatchedExecution;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "BatchedExecution";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "batchSize";
        }

        private int batchSize() {
            return this.batchSize;
        }

        @Override
        public int recommendedBatchSize() {
            return this.recommendedBatchSize;
        }

        @Override
        public int batchedExecutionModulus() {
            return this.batchedExecutionModulus;
        }

        @Override
        public int nextFrameIndex(int current) {
            return current + 1 & this.batchedExecutionModulus();
        }

        public BatchedExecution copy(int batchSize) {
            return new BatchedExecution(batchSize);
        }

        public int copy$default$1() {
            return this.batchSize();
        }

        public int _1() {
            return this.batchSize();
        }
    }

    public static final class Extensions {
        private final ExecutionModel self;

        public static boolean equals$extension(ExecutionModel executionModel, Object object) {
            return ExecutionModel$Extensions$.MODULE$.equals$extension(executionModel, object);
        }

        public static int hashCode$extension(ExecutionModel executionModel) {
            return ExecutionModel$Extensions$.MODULE$.hashCode$extension(executionModel);
        }

        public static boolean isAlwaysAsync$extension(ExecutionModel executionModel) {
            return ExecutionModel$Extensions$.MODULE$.isAlwaysAsync$extension(executionModel);
        }

        public static boolean isBatched$extension(ExecutionModel executionModel) {
            return ExecutionModel$Extensions$.MODULE$.isBatched$extension(executionModel);
        }

        public static boolean isSynchronous$extension(ExecutionModel executionModel) {
            return ExecutionModel$Extensions$.MODULE$.isSynchronous$extension(executionModel);
        }

        public Extensions(ExecutionModel self) {
            this.self = self;
        }

        public int hashCode() {
            return ExecutionModel$Extensions$.MODULE$.hashCode$extension(this.self());
        }

        public boolean equals(Object x$0) {
            return ExecutionModel$Extensions$.MODULE$.equals$extension(this.self(), x$0);
        }

        public ExecutionModel self() {
            return this.self;
        }

        public boolean isAlwaysAsync() {
            return ExecutionModel$Extensions$.MODULE$.isAlwaysAsync$extension(this.self());
        }

        public boolean isSynchronous() {
            return ExecutionModel$Extensions$.MODULE$.isSynchronous$extension(this.self());
        }

        public boolean isBatched() {
            return ExecutionModel$Extensions$.MODULE$.isBatched$extension(this.self());
        }
    }
}

