/*
 * Decompiled with CFR 0.152.
 */
package monix.execution;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import monix.execution.Cancelable;
import monix.execution.FutureUtils$extensions$;
import monix.execution.Scheduler;
import monix.execution.internal.FutureUtilsForPlatform;
import monix.execution.schedulers.TrampolineExecutionContext$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;

public final class FutureUtils$
extends FutureUtilsForPlatform
implements Serializable {
    public static final FutureUtils$extensions$ extensions;
    public static final FutureUtils$ MODULE$;

    private FutureUtils$() {
    }

    static {
        MODULE$ = new FutureUtils$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FutureUtils$.class);
    }

    public <A> Future<A> timeout(Future<A> source, FiniteDuration atMost, Scheduler s) {
        TimeoutException err = new TimeoutException();
        Promise promise = Promise$.MODULE$.apply();
        Cancelable task = s.scheduleOnce(atMost.length(), atMost.unit(), new Runnable(err, promise){
            private final TimeoutException err$1;
            private final Promise promise$1;
            {
                this.err$1 = err$2;
                this.promise$1 = promise$5;
            }

            public void run() {
                this.promise$1.tryFailure((Throwable)this.err$1);
            }
        });
        source.onComplete((Function1 & Serializable)r -> {
            task.cancel();
            return promise.tryComplete(r);
        }, (ExecutionContext)s);
        return promise.future();
    }

    public <A> Future<A> timeoutTo(Future<A> source, FiniteDuration atMost, Function0<Future<A>> fallback, Scheduler s) {
        Promise promise = Promise$.MODULE$.apply();
        Cancelable task = s.scheduleOnce(atMost.length(), atMost.unit(), new Runnable(promise){
            private final Promise promise$3;
            {
                this.promise$3 = promise$6;
            }

            public void run() {
                this.promise$3.trySuccess((Object)None$.MODULE$);
            }
        });
        source.onComplete((Function1 & Serializable)r -> {
            task.cancel();
            return promise.trySuccess((Object)Some$.MODULE$.apply(r));
        }, (ExecutionContext)s);
        return promise.future().flatMap((Function1 & Serializable)x$1 -> {
            Future future;
            Option option = x$1;
            if (option instanceof Some) {
                Try res = (Try)((Some)option).value();
                future = Future$.MODULE$.fromTry(res);
            } else if (None$.MODULE$.equals(option)) {
                future = (Future)fallback.apply();
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, (ExecutionContext)s);
    }

    public <A> Future<Try<A>> materialize(Future<A> source, ExecutionContext ec) {
        return source.transform((Function1 & Serializable)t -> Success$.MODULE$.apply(t), (ExecutionContext)TrampolineExecutionContext$.MODULE$.immediate());
    }

    public <A, B> Future<B> transform(Future<A> source, Function1<Try<A>, Try<B>> f, ExecutionContext ec) {
        return source.transform(f, ec);
    }

    public <A, B> Future<B> transformWith(Future<A> source, Function1<Try<A>, Future<B>> f, ExecutionContext ec) {
        return source.transformWith(f, ec);
    }

    public <A> Future<A> dematerialize(Future<Try<A>> source, ExecutionContext ec) {
        return source.map((Function1 & Serializable)_$1 -> _$1.get(), (ExecutionContext)TrampolineExecutionContext$.MODULE$.immediate());
    }

    public <A> Future<A> delayedResult(FiniteDuration delay, Function0<A> result, Scheduler s) {
        Promise p = Promise$.MODULE$.apply();
        s.scheduleOnce(delay.length(), delay.unit(), new Runnable(result, p){
            private final Function0 result$1;
            private final Promise p$1;
            {
                this.result$1 = result$2;
                this.p$1 = p$2;
            }

            public void run() {
                this.p$1.complete(Try$.MODULE$.apply(this.result$1));
            }
        });
        return p.future();
    }
}

