/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import monix.execution.CancelableFuture;
import monix.execution.CancelableFuture$;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public abstract class FutureUtilsForPlatform {
    public <A> CompletableFuture<A> toJavaCompletable(Future<A> source, ExecutionContext ec) {
        CompletableFuture<Object> completableFuture;
        Future<A> future = source;
        if (future instanceof CancelableFuture) {
            CancelableFuture ref = (CancelableFuture)future;
            completableFuture = CancelableFuture$.MODULE$.toJavaCompletable(ref, ec);
        } else {
            CompletableFuture cf = new CompletableFuture();
            source.onComplete((Function1 & Serializable)x$1 -> {
                boolean bl;
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    Object a = ((Success)try_).value();
                    bl = cf.complete(a);
                } else if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    bl = cf.completeExceptionally(ex);
                } else {
                    throw new MatchError((Object)try_);
                }
                return bl;
            }, ec);
            completableFuture = cf;
        }
        return completableFuture;
    }

    public <A> Future<A> fromJavaCompletable(CompletableFuture<A> cfa, ExecutionContext ec) {
        return CancelableFuture$.MODULE$.fromJavaCompletable(cfa, ec);
    }

    public final <F extends Future<Object>, A> Java8Extensions<F, A> Java8Extensions(Future<A> source) {
        return new Java8Extensions(this, source);
    }

    public final class Java8Extensions<F extends Future<Object>, A> {
        private final Future source;
        private final /* synthetic */ FutureUtilsForPlatform $outer;

        public Java8Extensions(FutureUtilsForPlatform $outer, Future<A> source) {
            this.source = source;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public F source() {
            return (F)this.source;
        }

        public CompletableFuture<A> asJava(ExecutionContext ec) {
            return this.$outer.toJavaCompletable(this.source(), ec);
        }

        public final /* synthetic */ FutureUtilsForPlatform monix$execution$internal$FutureUtilsForPlatform$Java8Extensions$$$outer() {
            return this.$outer;
        }
    }
}

