/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal;

import java.io.Serializable;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicAny$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.internal.Constants$;
import monix.execution.internal.GenericVar$State$;
import monix.execution.internal.GenericVar$WaitForPut$;
import monix.execution.internal.GenericVar$WaitForTake$;
import monix.execution.internal.collection.LinkedMap;
import monix.execution.internal.collection.LinkedMap$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterator;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Right;

public abstract class GenericVar<A, CancelToken> {
    private final AtomicAny<State<A>> stateRef;
    private final Function1<Id, BoxedUnit> putCancel;
    private final Function1<Id, BoxedUnit> takeCancel;
    private final Function1<Id, BoxedUnit> readCancel;

    public GenericVar(Option<A> initial, PaddingStrategy ps) {
        State<Object> state;
        Option<A> option = initial;
        if (None$.MODULE$.equals(option)) {
            state = GenericVar$State$.MODULE$.empty();
        } else if (option instanceof Some) {
            Object a = ((Some)option).value();
            state = GenericVar$State$.MODULE$.apply(a);
        } else {
            throw new MatchError(option);
        }
        this.stateRef = AtomicAny$.MODULE$.withPadding(state, ps);
        this.putCancel = (JProcedure1 & Serializable)id -> this.loop$1((Id)id);
        this.takeCancel = (JProcedure1 & Serializable)id -> this.loop$2((Id)id);
        this.readCancel = (JProcedure1 & Serializable)id -> this.loop$3((Id)id);
    }

    public abstract CancelToken makeCancelable(Function1<Id, BoxedUnit> var1, Id var2);

    public abstract CancelToken emptyCancelable();

    public final CancelToken unsafePut(A a, Function1<Either<Nothing$, BoxedUnit>, BoxedUnit> await) {
        CancelToken CancelToken;
        block6: {
            State<A> state;
            GenericVar genericVar = this;
            while (true) {
                State<A> update;
                State<A> state2;
                if ((state = genericVar.stateRef.get()) instanceof WaitForTake) {
                    Id id;
                    LinkedMap linkedMap;
                    LinkedMap listeners;
                    LinkedMap newMap;
                    WaitForTake waitForTake = (WaitForTake)state;
                    WaitForTake current = waitForTake;
                    WaitForTake waitForTake2 = GenericVar$WaitForTake$.MODULE$.unapply(waitForTake);
                    Object a2 = waitForTake2._1();
                    Object value = a2;
                    WaitForTake update2 = GenericVar$WaitForTake$.MODULE$.apply(value, newMap = (listeners = (linkedMap = waitForTake2._2())).updated(id = new Id(), Tuple2$.MODULE$.apply(a, await)));
                    if (!genericVar.stateRef.compareAndSet(current, update2)) continue;
                    CancelToken = genericVar.makeCancelable(genericVar.putCancel, id);
                    break block6;
                }
                if (!(state instanceof WaitForPut)) break;
                WaitForPut waitForPut = (WaitForPut)state;
                WaitForPut waitForPut2 = GenericVar$WaitForPut$.MODULE$.unapply(waitForPut);
                LinkedMap linkedMap = waitForPut2._1();
                LinkedMap linkedMap2 = waitForPut2._2();
                LinkedMap reads = linkedMap;
                LinkedMap takes = linkedMap2;
                WaitForPut current = waitForPut;
                Function1 first = null;
                if (takes.isEmpty()) {
                    state2 = GenericVar$State$.MODULE$.apply(a);
                } else {
                    Tuple2 tuple2 = takes.dequeue();
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Function1 x = (Function1)tuple2._1();
                    LinkedMap rest = (LinkedMap)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)x, (Object)rest);
                    Function1 x2 = (Function1)tuple22._1();
                    LinkedMap rest2 = (LinkedMap)tuple22._2();
                    first = x2;
                    state2 = update = rest2.isEmpty() ? GenericVar$State$.MODULE$.empty() : GenericVar$WaitForPut$.MODULE$.apply(LinkedMap$.MODULE$.empty(), rest2);
                }
                if (!genericVar.stateRef.compareAndSet(current, update)) continue;
                Right value = package$.MODULE$.Right().apply(a);
                genericVar.streamAll((Either<Nothing$, A>)value, reads);
                if (first != null) {
                    first.apply((Object)value);
                }
                await.apply(Constants$.MODULE$.eitherOfUnit());
                CancelToken = genericVar.emptyCancelable();
                break block6;
            }
            throw new MatchError(state);
        }
        return CancelToken;
    }

    public final boolean unsafeTryPut(A a) {
        boolean bl;
        block5: {
            State<A> state;
            block6: {
                Function1 first;
                LinkedMap reads;
                State<A> update;
                WaitForPut current;
                GenericVar genericVar = this;
                do {
                    State<A> state2;
                    if ((state = genericVar.stateRef.get()) instanceof WaitForTake) {
                        WaitForTake waitForTake = GenericVar$WaitForTake$.MODULE$.unapply((WaitForTake)state);
                        Object a2 = waitForTake._1();
                        LinkedMap linkedMap = waitForTake._2();
                        bl = false;
                        break block5;
                    }
                    if (!(state instanceof WaitForPut)) break block6;
                    WaitForPut waitForPut = (WaitForPut)state;
                    WaitForPut waitForPut2 = GenericVar$WaitForPut$.MODULE$.unapply(waitForPut);
                    LinkedMap linkedMap = waitForPut2._1();
                    LinkedMap linkedMap2 = waitForPut2._2();
                    reads = linkedMap;
                    LinkedMap takes = linkedMap2;
                    current = waitForPut;
                    first = null;
                    if (takes.isEmpty()) {
                        state2 = GenericVar$State$.MODULE$.apply(a);
                        continue;
                    }
                    Tuple2 tuple2 = takes.dequeue();
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Function1 x = (Function1)tuple2._1();
                    LinkedMap rest = (LinkedMap)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)x, (Object)rest);
                    Function1 x2 = (Function1)tuple22._1();
                    LinkedMap rest2 = (LinkedMap)tuple22._2();
                    first = x2;
                    state2 = update = rest2.isEmpty() ? GenericVar$State$.MODULE$.empty() : GenericVar$WaitForPut$.MODULE$.apply(LinkedMap$.MODULE$.empty(), rest2);
                } while (!genericVar.stateRef.compareAndSet(current, update));
                Right value = package$.MODULE$.Right().apply(a);
                genericVar.streamAll((Either<Nothing$, A>)value, reads);
                if (first != null) {
                    first.apply((Object)value);
                }
                bl = true;
                break block5;
            }
            throw new MatchError(state);
        }
        return bl;
    }

    public final CancelToken unsafeTake(Function1<Either<Nothing$, A>, BoxedUnit> await) {
        CancelToken CancelToken;
        block4: {
            State<A> state;
            GenericVar genericVar = this;
            while (true) {
                Id id;
                LinkedMap linkedMap;
                LinkedMap takes;
                LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> newQueue;
                if ((state = genericVar.stateRef.get()) instanceof WaitForTake) {
                    Tuple2 tuple2;
                    WaitForTake waitForTake = (WaitForTake)state;
                    WaitForTake waitForTake2 = GenericVar$WaitForTake$.MODULE$.unapply(waitForTake);
                    Object a = waitForTake2._1();
                    LinkedMap linkedMap2 = waitForTake2._2();
                    Object a2 = a;
                    LinkedMap queue = linkedMap2;
                    WaitForTake current = waitForTake;
                    Right value = package$.MODULE$.Right().apply(a2);
                    if (queue.isEmpty()) {
                        if (!genericVar.stateRef.compareAndSet(current, GenericVar$State$.MODULE$.empty())) continue;
                        await.apply((Object)value);
                        CancelToken = genericVar.emptyCancelable();
                        break block4;
                    }
                    Tuple2 tuple22 = queue.dequeue();
                    if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                        throw new MatchError(tuple22);
                    }
                    Object ax = tuple2._1();
                    Function1 notify = (Function1)tuple2._2();
                    LinkedMap xs = (LinkedMap)tuple22._2();
                    Tuple3 tuple3 = Tuple3$.MODULE$.apply(ax, (Object)notify, (Object)xs);
                    Object ax2 = tuple3._1();
                    Function1 notify2 = (Function1)tuple3._2();
                    LinkedMap xs2 = (LinkedMap)tuple3._3();
                    if (!genericVar.stateRef.compareAndSet(current, GenericVar$WaitForTake$.MODULE$.apply(ax2, xs2))) continue;
                    await.apply((Object)value);
                    notify2.apply(Constants$.MODULE$.eitherOfUnit());
                    CancelToken = genericVar.emptyCancelable();
                    break block4;
                }
                if (!(state instanceof WaitForPut)) break;
                WaitForPut waitForPut = (WaitForPut)state;
                WaitForPut current = waitForPut;
                WaitForPut waitForPut2 = GenericVar$WaitForPut$.MODULE$.unapply(waitForPut);
                LinkedMap linkedMap3 = waitForPut2._1();
                LinkedMap reads = linkedMap3;
                if (!genericVar.stateRef.compareAndSet(current, GenericVar$WaitForPut$.MODULE$.apply(reads, newQueue = (takes = (linkedMap = waitForPut2._2())).updated(id = new Id(), await)))) continue;
                CancelToken = genericVar.makeCancelable(genericVar.takeCancel, id);
                break block4;
            }
            throw new MatchError(state);
        }
        return CancelToken;
    }

    public final Option<A> unsafeTryTake() {
        None$ none$;
        block5: {
            State<A> current;
            State<A> state;
            GenericVar genericVar = this;
            while ((state = (current = genericVar.stateRef.get())) instanceof WaitForTake) {
                Tuple2 tuple2;
                WaitForTake waitForTake = GenericVar$WaitForTake$.MODULE$.unapply((WaitForTake)state);
                Object a = waitForTake._1();
                LinkedMap linkedMap = waitForTake._2();
                Object value = a;
                LinkedMap queue = linkedMap;
                if (queue.isEmpty()) {
                    if (!genericVar.stateRef.compareAndSet(current, GenericVar$State$.MODULE$.empty())) continue;
                    none$ = Some$.MODULE$.apply(value);
                    break block5;
                }
                Tuple2 tuple22 = queue.dequeue();
                if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                    throw new MatchError(tuple22);
                }
                Object ax = tuple2._1();
                Function1 notify = (Function1)tuple2._2();
                LinkedMap xs = (LinkedMap)tuple22._2();
                Tuple3 tuple3 = Tuple3$.MODULE$.apply(ax, (Object)notify, (Object)xs);
                Object ax2 = tuple3._1();
                Function1 notify2 = (Function1)tuple3._2();
                LinkedMap xs2 = (LinkedMap)tuple3._3();
                WaitForTake<Object> update = GenericVar$WaitForTake$.MODULE$.apply(ax2, xs2);
                if (!genericVar.stateRef.compareAndSet(current, update)) continue;
                notify2.apply(Constants$.MODULE$.eitherOfUnit());
                none$ = Some$.MODULE$.apply(value);
                break block5;
            }
            if (state instanceof WaitForPut) {
                WaitForPut waitForPut = GenericVar$WaitForPut$.MODULE$.unapply((WaitForPut)state);
                LinkedMap linkedMap = waitForPut._1();
                LinkedMap linkedMap2 = waitForPut._2();
                none$ = None$.MODULE$;
            } else {
                throw new MatchError(state);
            }
        }
        return none$;
    }

    public final CancelToken unsafeRead(Function1<Either<Nothing$, A>, BoxedUnit> await) {
        CancelToken CancelToken;
        block3: {
            State<A> state;
            GenericVar genericVar = this;
            while (true) {
                State<A> current;
                if ((state = (current = genericVar.stateRef.get())) instanceof WaitForTake) {
                    WaitForTake waitForTake = GenericVar$WaitForTake$.MODULE$.unapply((WaitForTake)state);
                    Object a = waitForTake._1();
                    LinkedMap linkedMap = waitForTake._2();
                    Object value = a;
                    await.apply((Object)package$.MODULE$.Right().apply(value));
                    CancelToken = genericVar.emptyCancelable();
                } else {
                    if (!(state instanceof WaitForPut)) break;
                    WaitForPut waitForPut = GenericVar$WaitForPut$.MODULE$.unapply((WaitForPut)state);
                    LinkedMap linkedMap = waitForPut._1();
                    LinkedMap linkedMap2 = waitForPut._2();
                    LinkedMap reads = linkedMap;
                    LinkedMap takes = linkedMap2;
                    Id id = new Id();
                    LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> newQueue = reads.updated(id, await);
                    if (!genericVar.stateRef.compareAndSet(current, GenericVar$WaitForPut$.MODULE$.apply(newQueue, takes))) continue;
                    CancelToken = genericVar.makeCancelable(genericVar.readCancel, id);
                }
                break block3;
            }
            throw new MatchError(state);
        }
        return CancelToken;
    }

    public final Option<A> unsafeTryRead() {
        None$ none$;
        State<A> state = this.stateRef.get();
        if (state instanceof WaitForTake) {
            WaitForTake waitForTake = GenericVar$WaitForTake$.MODULE$.unapply((WaitForTake)state);
            Object a = waitForTake._1();
            LinkedMap linkedMap = waitForTake._2();
            Object value = a;
            none$ = Some$.MODULE$.apply(value);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public final boolean unsafeIsEmpty() {
        boolean bl;
        State<A> state = this.stateRef.get();
        if (state instanceof WaitForTake) {
            WaitForTake waitForTake = GenericVar$WaitForTake$.MODULE$.unapply((WaitForTake)state);
            Object a = waitForTake._1();
            LinkedMap linkedMap = waitForTake._2();
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final void streamAll(Either<Nothing$, A> value, LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> listeners) {
        Iterator cursor = listeners.values().iterator();
        while (cursor.hasNext()) {
            ((Function1)cursor.next()).apply(value);
        }
    }

    private final void loop$1(Id id) {
        State<A> state;
        while ((state = this.stateRef.get()) instanceof WaitForTake) {
            LinkedMap linkedMap;
            WaitForTake waitForTake = (WaitForTake)state;
            WaitForTake waitForTake2 = GenericVar$WaitForTake$.MODULE$.unapply(waitForTake);
            Object a = waitForTake2._1();
            LinkedMap queue = linkedMap = waitForTake2._2();
            WaitForTake current = waitForTake;
            LinkedMap linkedMap2 = queue.$minus(id);
            Object a2 = current.copy$default$1();
            WaitForTake update = current.copy(a2, linkedMap2);
            if (!this.stateRef.compareAndSet(current, update)) continue;
        }
    }

    private final void loop$2(Id id) {
        LinkedMap linkedMap;
        LinkedMap takes;
        LinkedMap newMap;
        WaitForPut waitForPut;
        LinkedMap linkedMap2;
        LinkedMap reads;
        WaitForPut update;
        WaitForPut waitForPut2;
        WaitForPut current;
        State<A> state;
        while ((state = this.stateRef.get()) instanceof WaitForPut && !this.stateRef.compareAndSet(current = (waitForPut2 = (WaitForPut)state), update = GenericVar$WaitForPut$.MODULE$.apply(reads = (linkedMap2 = (waitForPut = GenericVar$WaitForPut$.MODULE$.unapply(waitForPut2))._1()), newMap = (takes = (linkedMap = waitForPut._2())).$minus(id)))) {
        }
    }

    private final void loop$3(Id id) {
        State<A> state;
        while ((state = this.stateRef.get()) instanceof WaitForPut) {
            WaitForPut waitForPut = (WaitForPut)state;
            WaitForPut waitForPut2 = GenericVar$WaitForPut$.MODULE$.unapply(waitForPut);
            LinkedMap linkedMap = waitForPut2._1();
            LinkedMap linkedMap2 = waitForPut2._2();
            LinkedMap reads = linkedMap;
            LinkedMap takes = linkedMap2;
            WaitForPut current = waitForPut;
            LinkedMap newMap = reads.$minus(id);
            WaitForPut update = GenericVar$WaitForPut$.MODULE$.apply(newMap, takes);
            if (!this.stateRef.compareAndSet(current, update)) continue;
        }
    }

    public static final class Id
    implements Serializable {
    }

    private static interface State<A> {
        public static <A> State<A> apply(A a) {
            return GenericVar$State$.MODULE$.apply(a);
        }

        public static <A> State<A> empty() {
            return GenericVar$State$.MODULE$.empty();
        }

        public static int ordinal(State<?> state) {
            return GenericVar$State$.MODULE$.ordinal(state);
        }
    }

    private static final class WaitForPut<A>
    implements State<A>,
    Product,
    Serializable {
        private final LinkedMap reads;
        private final LinkedMap takes;

        public static <A> WaitForPut<A> apply(LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> linkedMap, LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> linkedMap2) {
            return GenericVar$WaitForPut$.MODULE$.apply(linkedMap, linkedMap2);
        }

        public static WaitForPut<?> fromProduct(Product product) {
            return GenericVar$WaitForPut$.MODULE$.fromProduct(product);
        }

        public static <A> WaitForPut<A> unapply(WaitForPut<A> waitForPut) {
            return GenericVar$WaitForPut$.MODULE$.unapply(waitForPut);
        }

        public WaitForPut(LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> reads, LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> takes) {
            this.reads = reads;
            this.takes = takes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WaitForPut)) return false;
            WaitForPut waitForPut = (WaitForPut)object;
            LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> linkedMap = this.reads();
            LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> linkedMap2 = waitForPut.reads();
            if (linkedMap == null) {
                if (linkedMap2 != null) {
                    return false;
                }
            } else if (!linkedMap.equals(linkedMap2)) return false;
            LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> linkedMap3 = this.takes();
            LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> linkedMap4 = waitForPut.takes();
            if (linkedMap3 == null) {
                if (linkedMap4 == null) return true;
                return false;
            } else {
                if (!linkedMap3.equals(linkedMap4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WaitForPut;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "WaitForPut";
        }

        public Object productElement(int n) {
            LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> linkedMap;
            int n2 = n;
            if (0 == n2) {
                linkedMap = this._1();
            } else if (1 == n2) {
                linkedMap = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return linkedMap;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "reads";
            } else if (1 == n2) {
                string = "takes";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> reads() {
            return this.reads;
        }

        public LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> takes() {
            return this.takes;
        }

        public <A> WaitForPut<A> copy(LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> reads, LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> takes) {
            return new WaitForPut<A>(reads, takes);
        }

        public <A> LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> copy$default$1() {
            return this.reads();
        }

        public <A> LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> copy$default$2() {
            return this.takes();
        }

        public LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> _1() {
            return this.reads();
        }

        public LinkedMap<Id, Function1<Either<Nothing$, A>, BoxedUnit>> _2() {
            return this.takes();
        }
    }

    private static final class WaitForTake<A>
    implements State<A>,
    Product,
    Serializable {
        private final Object value;
        private final LinkedMap queue;

        public static <A> WaitForTake<A> apply(A a, LinkedMap<Id, Tuple2<A, Function1<Either<Nothing$, BoxedUnit>, BoxedUnit>>> linkedMap) {
            return GenericVar$WaitForTake$.MODULE$.apply(a, linkedMap);
        }

        public static WaitForTake<?> fromProduct(Product product) {
            return GenericVar$WaitForTake$.MODULE$.fromProduct(product);
        }

        public static <A> WaitForTake<A> unapply(WaitForTake<A> waitForTake) {
            return GenericVar$WaitForTake$.MODULE$.unapply(waitForTake);
        }

        public WaitForTake(A value, LinkedMap<Id, Tuple2<A, Function1<Either<Nothing$, BoxedUnit>, BoxedUnit>>> queue) {
            this.value = value;
            this.queue = queue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WaitForTake)) return false;
            WaitForTake waitForTake = (WaitForTake)object;
            if (!BoxesRunTime.equals(this.value(), waitForTake.value())) return false;
            LinkedMap<Id, Tuple2<A, Function1<Either<Nothing$, BoxedUnit>, BoxedUnit>>> linkedMap = this.queue();
            LinkedMap<Id, Tuple2<A, Function1<Either<Nothing$, BoxedUnit>, BoxedUnit>>> linkedMap2 = waitForTake.queue();
            if (linkedMap != null) {
                if (!linkedMap.equals(linkedMap2)) return false;
                return true;
            }
            if (linkedMap2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WaitForTake;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "WaitForTake";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "value";
            } else if (1 == n2) {
                string = "queue";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public A value() {
            return (A)this.value;
        }

        public LinkedMap<Id, Tuple2<A, Function1<Either<Nothing$, BoxedUnit>, BoxedUnit>>> queue() {
            return this.queue;
        }

        public <A> WaitForTake<A> copy(A value, LinkedMap<Id, Tuple2<A, Function1<Either<Nothing$, BoxedUnit>, BoxedUnit>>> queue) {
            return new WaitForTake<A>(value, queue);
        }

        public <A> A copy$default$1() {
            return this.value();
        }

        public <A> LinkedMap<Id, Tuple2<A, Function1<Either<Nothing$, BoxedUnit>, BoxedUnit>>> copy$default$2() {
            return this.queue();
        }

        public A _1() {
            return this.value();
        }

        public LinkedMap<Id, Tuple2<A, Function1<Either<Nothing$, BoxedUnit>, BoxedUnit>>> _2() {
            return this.queue();
        }
    }
}

