/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.atomic;

import java.lang.reflect.Field;
import monix.execution.internal.InternalApi;
import monix.execution.internal.atomic.BoxedInt;
import monix.execution.internal.atomic.UnsafeAccess;
import sun.misc.Unsafe;

@InternalApi
final class NormalJava7BoxedInt
implements BoxedInt {
    public volatile int value;
    private static final long OFFSET;
    private static final Unsafe UNSAFE;

    NormalJava7BoxedInt(int n) {
        this.value = n;
    }

    @Override
    public int volatileGet() {
        return this.value;
    }

    @Override
    public void volatileSet(int n) {
        this.value = n;
    }

    @Override
    public void lazySet(int n) {
        UNSAFE.putOrderedInt(this, OFFSET, n);
    }

    @Override
    public boolean compareAndSet(int n, int n2) {
        return UNSAFE.compareAndSwapInt(this, OFFSET, n, n2);
    }

    @Override
    public int getAndSet(int n) {
        int n2 = this.value;
        while (!UNSAFE.compareAndSwapInt(this, OFFSET, n2, n)) {
            n2 = this.value;
        }
        return n2;
    }

    @Override
    public int getAndAdd(int n) {
        int n2;
        while (!UNSAFE.compareAndSwapInt(this, OFFSET, n2 = UNSAFE.getIntVolatile(this, OFFSET), n2 + n)) {
        }
        return n2;
    }

    static {
        UNSAFE = (Unsafe)UnsafeAccess.getInstance();
        try {
            Field field = NormalJava7BoxedInt.class.getDeclaredField("value");
            OFFSET = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

