/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.schedulers;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Features$;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.internal.InterceptRunnable$;
import monix.execution.internal.Platform$;
import monix.execution.internal.ScheduledExecutors$;
import monix.execution.schedulers.BatchingScheduler;
import monix.execution.schedulers.ExecutorScheduler$;
import monix.execution.schedulers.ReferenceScheduler;
import monix.execution.schedulers.SchedulerService;
import monix.execution.schedulers.TrampolineExecutionContext;
import scala.Function0;
import scala.NotImplementedError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public abstract class ExecutorScheduler
implements ExecutionContext,
Scheduler,
SchedulerService,
ReferenceScheduler,
BatchingScheduler {
    private TrampolineExecutionContext monix$execution$schedulers$BatchingScheduler$$trampoline;
    public final ExecutorService monix$execution$schedulers$ExecutorScheduler$$e;
    private final UncaughtExceptionReporter r;

    public static ExecutorScheduler apply(ExecutorService executorService, UncaughtExceptionReporter uncaughtExceptionReporter, ExecutionModel executionModel) {
        return ExecutorScheduler$.MODULE$.apply(executorService, uncaughtExceptionReporter, executionModel);
    }

    public static ExecutorScheduler apply(ExecutorService executorService, UncaughtExceptionReporter uncaughtExceptionReporter, ExecutionModel executionModel, long l) {
        return ExecutorScheduler$.MODULE$.apply(executorService, uncaughtExceptionReporter, executionModel, l);
    }

    public static ExecutorScheduler forkJoinDynamic(String string, int n, int n2, boolean bl, UncaughtExceptionReporter uncaughtExceptionReporter, ExecutionModel executionModel) {
        return ExecutorScheduler$.MODULE$.forkJoinDynamic(string, n, n2, bl, uncaughtExceptionReporter, executionModel);
    }

    public static ExecutorScheduler forkJoinStatic(String string, int n, boolean bl, UncaughtExceptionReporter uncaughtExceptionReporter, ExecutionModel executionModel) {
        return ExecutorScheduler$.MODULE$.forkJoinStatic(string, n, bl, uncaughtExceptionReporter, executionModel);
    }

    public ExecutorScheduler(ExecutorService e, UncaughtExceptionReporter r) {
        this.monix$execution$schedulers$ExecutorScheduler$$e = e;
        this.r = r;
        ExecutionContext.$init$((ExecutionContext)this);
        BatchingScheduler.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public TrampolineExecutionContext monix$execution$schedulers$BatchingScheduler$$trampoline() {
        return this.monix$execution$schedulers$BatchingScheduler$$trampoline;
    }

    @Override
    public void monix$execution$schedulers$BatchingScheduler$_setter_$monix$execution$schedulers$BatchingScheduler$$trampoline_$eq(TrampolineExecutionContext x$0) {
        this.monix$execution$schedulers$BatchingScheduler$$trampoline = x$0;
    }

    public ExecutorService executor() {
        return this.monix$execution$schedulers$ExecutorScheduler$$e;
    }

    @Override
    public final void executeAsync(Runnable runnable) {
        this.monix$execution$schedulers$ExecutorScheduler$$e.execute(this.r == null ? runnable : InterceptRunnable$.MODULE$.apply(runnable, this.r));
    }

    @Override
    public final void reportFailure(Throwable t) {
        if (this.r != null) {
            this.r.reportFailure(t);
        } else {
            Platform$.MODULE$.reportFailure(t);
        }
    }

    @Override
    public final boolean isShutdown() {
        return this.monix$execution$schedulers$ExecutorScheduler$$e.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.monix$execution$schedulers$ExecutorScheduler$$e.isTerminated();
    }

    @Override
    public final void shutdown() {
        this.monix$execution$schedulers$ExecutorScheduler$$e.shutdown();
    }

    @Override
    public final Future<Object> awaitTermination(long timeout, TimeUnit unit, ExecutionContext awaitOn) {
        Promise p = Promise$.MODULE$.apply();
        awaitOn.execute(new Runnable(timeout, unit, p, this){
            private final long timeout$1;
            private final TimeUnit unit$1;
            private final Promise p$1;
            private final /* synthetic */ ExecutorScheduler $outer;
            {
                this.timeout$1 = timeout$2;
                this.unit$1 = unit$2;
                this.p$1 = p$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                try {
                    package$.MODULE$.blocking((Function0)((JFunction0.mcV.sp & Serializable)this::run$$anonfun$1));
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        this.p$1.failure(ex);
                    }
                    throw throwable;
                }
            }

            private final void run$$anonfun$1() {
                this.p$1.success((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.monix$execution$schedulers$ExecutorScheduler$$e.awaitTermination(this.timeout$1, this.unit$1)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$1()}, serializedLambda);
            }
        });
        return p.future();
    }

    @Override
    public SchedulerService withExecutionModel(ExecutionModel em) {
        throw new NotImplementedError("ExecutorService.withExecutionModel");
    }

    @Override
    public SchedulerService withUncaughtExceptionReporter(UncaughtExceptionReporter r) {
        throw new NotImplementedError("ExecutorService.withUncaughtExceptionReporter");
    }

    private static final class FromScheduledExecutor
    extends ExecutorScheduler {
        private final ScheduledExecutorService s;
        private final UncaughtExceptionReporter r;
        private final ExecutionModel executionModel;
        private final long features;

        public FromScheduledExecutor(ScheduledExecutorService s, UncaughtExceptionReporter r, ExecutionModel executionModel, long features) {
            this.s = s;
            this.r = r;
            this.executionModel = executionModel;
            this.features = features;
            super(s, r);
        }

        @Override
        public ExecutionModel executionModel() {
            return this.executionModel;
        }

        @Override
        public long features() {
            return this.features;
        }

        public FromScheduledExecutor(ScheduledExecutorService scheduler, UncaughtExceptionReporter r, ExecutionModel executionModel) {
            this(scheduler, r, executionModel, Features$.MODULE$.empty());
        }

        @Override
        public ScheduledExecutorService executor() {
            return this.s;
        }

        @Override
        public Cancelable scheduleOnce(long initialDelay, TimeUnit unit, Runnable r) {
            Cancelable cancelable;
            if (initialDelay <= 0L) {
                this.execute(r);
                cancelable = Cancelable$.MODULE$.empty();
            } else {
                ScheduledFuture<?> task = this.s.schedule(r, initialDelay, unit);
                cancelable = Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> task.cancel(true));
            }
            return cancelable;
        }

        @Override
        public Cancelable scheduleWithFixedDelay(long initialDelay, long delay, TimeUnit unit, Runnable r) {
            ScheduledFuture<?> task = this.s.scheduleWithFixedDelay(r, initialDelay, delay, unit);
            return Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> task.cancel(false));
        }

        @Override
        public Cancelable scheduleAtFixedRate(long initialDelay, long period, TimeUnit unit, Runnable r) {
            ScheduledFuture<?> task = this.s.scheduleAtFixedRate(r, initialDelay, period, unit);
            return Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> task.cancel(false));
        }

        @Override
        public SchedulerService withExecutionModel(ExecutionModel em) {
            return new FromScheduledExecutor(this.s, this.r, em, this.features());
        }

        @Override
        public SchedulerService withUncaughtExceptionReporter(UncaughtExceptionReporter r) {
            return new FromScheduledExecutor(this.s, r, this.executionModel(), this.features());
        }
    }

    private static final class FromSimpleExecutor
    extends ExecutorScheduler {
        private final ScheduledExecutorService scheduler;
        private final ExecutorService executor;
        private final UncaughtExceptionReporter r;
        private final ExecutionModel executionModel;
        private final long features;

        public FromSimpleExecutor(ScheduledExecutorService scheduler, ExecutorService executor, UncaughtExceptionReporter r, ExecutionModel executionModel, long features) {
            this.scheduler = scheduler;
            this.executor = executor;
            this.r = r;
            this.executionModel = executionModel;
            this.features = features;
            super(executor, r);
        }

        @Override
        public ExecutionModel executionModel() {
            return this.executionModel;
        }

        @Override
        public long features() {
            return this.features;
        }

        public FromSimpleExecutor(ScheduledExecutorService scheduler, ExecutorService executor, UncaughtExceptionReporter r, ExecutionModel executionModel) {
            this(scheduler, executor, r, executionModel, Features$.MODULE$.empty());
        }

        @Override
        public Cancelable scheduleOnce(long initialDelay, TimeUnit unit, Runnable r) {
            return ScheduledExecutors$.MODULE$.scheduleOnce(this, this.scheduler, initialDelay, unit, r);
        }

        @Override
        public SchedulerService withExecutionModel(ExecutionModel em) {
            return new FromSimpleExecutor(this.scheduler, this.executor, this.r, em, this.features());
        }

        @Override
        public SchedulerService withUncaughtExceptionReporter(UncaughtExceptionReporter r) {
            return new FromSimpleExecutor(this.scheduler, this.executor, r, this.executionModel(), this.features());
        }
    }
}

