/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.jctools.queues;

import monix.execution.internal.jctools.queues.MessagePassingQueue;
import monix.execution.internal.jctools.queues.MpUnboundedXaddArrayQueue;
import monix.execution.internal.jctools.queues.MpUnboundedXaddChunk;
import monix.execution.internal.jctools.queues.MpmcUnboundedXaddChunk;

public class MpmcUnboundedXaddArrayQueue<E>
extends MpUnboundedXaddArrayQueue<MpmcUnboundedXaddChunk<E>, E> {
    public MpmcUnboundedXaddArrayQueue(int chunkSize, int maxPooledChunks) {
        super(chunkSize, maxPooledChunks);
    }

    public MpmcUnboundedXaddArrayQueue(int chunkSize) {
        this(chunkSize, 2);
    }

    @Override
    final MpmcUnboundedXaddChunk<E> newChunk(long index, MpmcUnboundedXaddChunk<E> prev, int chunkSize, boolean pooled) {
        return new MpmcUnboundedXaddChunk<E>(index, prev, chunkSize, pooled);
    }

    @Override
    public boolean offer(E e) {
        boolean isPooled;
        if (null == e) {
            throw new NullPointerException();
        }
        int chunkMask = this.chunkMask;
        int chunkShift = this.chunkShift;
        long pIndex = this.getAndIncrementProducerIndex();
        int piChunkOffset = (int)(pIndex & (long)chunkMask);
        long piChunkIndex = pIndex >> chunkShift;
        MpmcUnboundedXaddChunk pChunk = (MpmcUnboundedXaddChunk)this.lvProducerChunk();
        if (pChunk.lvIndex() != piChunkIndex) {
            pChunk = this.producerChunkForIndex(pChunk, piChunkIndex);
        }
        if (isPooled = pChunk.isPooled()) {
            pChunk.spinForElement(piChunkOffset, true);
        }
        pChunk.soElement(piChunkOffset, e);
        if (isPooled) {
            pChunk.soSequence(piChunkOffset, piChunkIndex);
        }
        return true;
    }

    @Override
    public E poll() {
        long ciChunkIndex;
        int ciChunkOffset;
        MpmcUnboundedXaddChunk cChunk;
        boolean isFirstElementOfNewChunk;
        MpmcUnboundedXaddChunk next;
        E e;
        boolean pooled;
        block14: {
            int chunkMask = this.chunkMask;
            int chunkShift = this.chunkShift;
            pooled = false;
            e = null;
            next = null;
            long pIndex = -1L;
            while (true) {
                isFirstElementOfNewChunk = false;
                long cIndex = this.lvConsumerIndex();
                cChunk = (MpmcUnboundedXaddChunk)this.lvConsumerChunk();
                ciChunkOffset = (int)(cIndex & (long)chunkMask);
                ciChunkIndex = cIndex >> chunkShift;
                long ccChunkIndex = cChunk.lvIndex();
                if (ciChunkOffset == 0 && cIndex != 0L) {
                    if (ciChunkIndex - ccChunkIndex != 1L) continue;
                    isFirstElementOfNewChunk = true;
                    next = (MpmcUnboundedXaddChunk)cChunk.lvNext();
                    if (next == null && cIndex >= pIndex && cIndex == (pIndex = this.lvProducerIndex())) {
                        return null;
                    }
                    if (!this.casConsumerIndex(cIndex, cIndex + 1L)) continue;
                    break block14;
                }
                if (ccChunkIndex > ciChunkIndex) continue;
                assert (!isFirstElementOfNewChunk && ccChunkIndex <= ciChunkIndex);
                pooled = cChunk.isPooled();
                if (ccChunkIndex == ciChunkIndex) {
                    if (pooled) {
                        long sequence = cChunk.lvSequence(ciChunkOffset);
                        if (sequence == ciChunkIndex) {
                            if (!this.casConsumerIndex(cIndex, cIndex + 1L)) continue;
                            break block14;
                        }
                        if (sequence > ciChunkIndex) {
                            continue;
                        }
                    } else {
                        e = cChunk.lvElement(ciChunkOffset);
                        if (e != null) {
                            if (!this.casConsumerIndex(cIndex, cIndex + 1L)) continue;
                            break block14;
                        }
                    }
                }
                if (cIndex >= pIndex && cIndex == (pIndex = this.lvProducerIndex())) break;
            }
            return null;
        }
        if (isFirstElementOfNewChunk) {
            e = this.linkNextConsumerChunkAndPoll(cChunk, next, ciChunkIndex);
        } else {
            if (pooled) {
                e = cChunk.lvElement(ciChunkOffset);
            }
            assert (!cChunk.isPooled() || cChunk.isPooled() && cChunk.lvSequence(ciChunkOffset) == ciChunkIndex);
            cChunk.soElement(ciChunkOffset, null);
        }
        return e;
    }

    private E linkNextConsumerChunkAndPoll(MpmcUnboundedXaddChunk<E> cChunk, MpmcUnboundedXaddChunk<E> next, long expectedChunkIndex) {
        while (next == null) {
            next = (MpmcUnboundedXaddChunk)cChunk.lvNext();
        }
        Object e = next.spinForElement(0, false);
        boolean pooled = next.isPooled();
        if (pooled) {
            next.spinForSequence(0, expectedChunkIndex);
        }
        next.soElement(0, null);
        this.moveToNextConsumerChunk(cChunk, next);
        return e;
    }

    @Override
    public E peek() {
        long cIndex;
        E e;
        int chunkMask = this.chunkMask;
        int chunkShift = this.chunkShift;
        do {
            boolean firstElementOfNewChunk;
            e = null;
            cIndex = this.lvConsumerIndex();
            MpmcUnboundedXaddChunk cChunk = (MpmcUnboundedXaddChunk)this.lvConsumerChunk();
            int ciChunkOffset = (int)(cIndex & (long)chunkMask);
            long ciChunkIndex = cIndex >> chunkShift;
            boolean bl = firstElementOfNewChunk = ciChunkOffset == 0 && cIndex != 0L;
            if (firstElementOfNewChunk) {
                MpmcUnboundedXaddChunk next;
                long expectedChunkIndex = ciChunkIndex - 1L;
                if (expectedChunkIndex != cChunk.lvIndex() || (next = (MpmcUnboundedXaddChunk)cChunk.lvNext()) == null) continue;
                cChunk = next;
            }
            if (cChunk.isPooled() ? cChunk.lvSequence(ciChunkOffset) != ciChunkIndex : cChunk.lvIndex() != ciChunkIndex) continue;
            e = cChunk.lvElement(ciChunkOffset);
        } while (e == null && cIndex != this.lvProducerIndex() || e != null && cIndex != this.lvConsumerIndex());
        return e;
    }

    @Override
    public E relaxedPoll() {
        E e;
        boolean pooled;
        long ciChunkIndex;
        int ciChunkOffset;
        MpmcUnboundedXaddChunk cChunk;
        long cIndex;
        block16: {
            block17: {
                block15: {
                    boolean firstElementOfNewChunk;
                    int chunkMask = this.chunkMask;
                    int chunkShift = this.chunkShift;
                    cIndex = this.lvConsumerIndex();
                    cChunk = (MpmcUnboundedXaddChunk)this.lvConsumerChunk();
                    ciChunkOffset = (int)(cIndex & (long)chunkMask);
                    ciChunkIndex = cIndex >> chunkShift;
                    boolean bl = firstElementOfNewChunk = ciChunkOffset == 0 && cIndex != 0L;
                    if (firstElementOfNewChunk) {
                        MpmcUnboundedXaddChunk next;
                        long expectedChunkIndex = ciChunkIndex - 1L;
                        long ccChunkIndex = cChunk.lvIndex();
                        if (expectedChunkIndex != ccChunkIndex || (next = (MpmcUnboundedXaddChunk)cChunk.lvNext()) == null) {
                            return null;
                        }
                        E e2 = null;
                        boolean pooled2 = next.isPooled();
                        if (pooled2 ? next.lvSequence(0) != ciChunkIndex : (e2 = (E)next.lvElement(0)) == null) {
                            return null;
                        }
                        if (!this.casConsumerIndex(cIndex, cIndex + 1L)) {
                            return null;
                        }
                        if (pooled2) {
                            e2 = next.lvElement(0);
                        }
                        assert (e2 != null);
                        next.soElement(0, null);
                        this.moveToNextConsumerChunk(cChunk, next);
                        return e2;
                    }
                    pooled = cChunk.isPooled();
                    e = null;
                    if (!pooled) break block15;
                    long sequence = cChunk.lvSequence(ciChunkOffset);
                    if (sequence != ciChunkIndex) {
                        return null;
                    }
                    break block16;
                }
                long ccChunkIndex = cChunk.lvIndex();
                if (ccChunkIndex != ciChunkIndex) break block17;
                Object e3 = cChunk.lvElement(ciChunkOffset);
                e = e3;
                if (e3 != null) break block16;
            }
            return null;
        }
        if (!this.casConsumerIndex(cIndex, cIndex + 1L)) {
            return null;
        }
        if (pooled) {
            e = cChunk.lvElement(ciChunkOffset);
            assert (e != null);
        }
        assert (!pooled || pooled && cChunk.lvSequence(ciChunkOffset) == ciChunkIndex);
        cChunk.soElement(ciChunkOffset, null);
        return e;
    }

    @Override
    public E relaxedPeek() {
        boolean firstElementOfNewChunk;
        int chunkMask = this.chunkMask;
        int chunkShift = this.chunkShift;
        long cIndex = this.lvConsumerIndex();
        int ciChunkOffset = (int)(cIndex & (long)chunkMask);
        long ciChunkIndex = cIndex >> chunkShift;
        MpmcUnboundedXaddChunk consumerBuffer = (MpmcUnboundedXaddChunk)this.lvConsumerChunk();
        int chunkSize = chunkMask + 1;
        boolean bl = firstElementOfNewChunk = ciChunkOffset == 0 && cIndex >= (long)chunkSize;
        if (firstElementOfNewChunk) {
            long expectedChunkIndex = ciChunkIndex - 1L;
            if (expectedChunkIndex != consumerBuffer.lvIndex()) {
                return null;
            }
            MpmcUnboundedXaddChunk next = (MpmcUnboundedXaddChunk)consumerBuffer.lvNext();
            if (next == null) {
                return null;
            }
            consumerBuffer = next;
        }
        if (consumerBuffer.isPooled() ? consumerBuffer.lvSequence(ciChunkOffset) != ciChunkIndex : consumerBuffer.lvIndex() != ciChunkIndex) {
            return null;
        }
        Object e = consumerBuffer.lvElement(ciChunkOffset);
        if (cIndex != this.lvConsumerIndex()) {
            return null;
        }
        return e;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        if (null == s) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        int chunkShift = this.chunkShift;
        int chunkMask = this.chunkMask;
        long producerSeq = this.getAndAddProducerIndex(limit);
        MpUnboundedXaddChunk producerBuffer = null;
        for (int i = 0; i < limit; ++i) {
            int pOffset = (int)(producerSeq & (long)chunkMask);
            long chunkIndex = producerSeq >> chunkShift;
            if ((producerBuffer == null || producerBuffer.lvIndex() != chunkIndex) && (producerBuffer = (MpmcUnboundedXaddChunk)this.producerChunkForIndex(producerBuffer, chunkIndex)).isPooled()) {
                chunkIndex = producerBuffer.lvIndex();
            }
            if (producerBuffer.isPooled()) {
                while (producerBuffer.lvElement(pOffset) != null) {
                }
            }
            producerBuffer.soElement(pOffset, s.get());
            if (producerBuffer.isPooled()) {
                ((MpmcUnboundedXaddChunk)producerBuffer).soSequence(pOffset, chunkIndex);
            }
            ++producerSeq;
        }
        return limit;
    }
}

