/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.jctools.counters;

import monix.execution.internal.jctools.counters.FixedSizeStripedLongCounterPrePad;
import monix.execution.internal.jctools.util.PortableJvmInfo;
import monix.execution.internal.jctools.util.Pow2;
import monix.execution.internal.jctools.util.UnsafeAccess;

abstract class FixedSizeStripedLongCounterFields
extends FixedSizeStripedLongCounterPrePad {
    protected static final int CACHE_LINE_IN_LONGS = PortableJvmInfo.CACHE_LINE_SIZE / 8;
    protected static final long COUNTER_ARRAY_BASE = Math.max(UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class), PortableJvmInfo.CACHE_LINE_SIZE - 8);
    protected static final long ELEMENT_SHIFT = Integer.numberOfTrailingZeros(PortableJvmInfo.CACHE_LINE_SIZE);
    protected final long[] cells;
    protected final int mask;

    protected FixedSizeStripedLongCounterFields(int stripesCount) {
        if (stripesCount <= 0) {
            throw new IllegalArgumentException("Expecting a stripesCount that is larger than 0");
        }
        int size = Pow2.roundToPowerOfTwo(stripesCount);
        this.cells = new long[CACHE_LINE_IN_LONGS * size];
        this.mask = size - 1;
    }
}

