/*
 * Decompiled with CFR 0.152.
 */
package monix.nio;

import java.io.Serializable;
import java.nio.ByteBuffer;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.Callback;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.execution.exceptions.APIContractViolationException$;
import monix.nio.AsyncChannel;
import monix.nio.AsyncChannelObservable$;
import monix.nio.internal.Bytes$;
import monix.nio.internal.EmptyBytes$;
import monix.nio.internal.NonEmptyBytes;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005a4aa\u0003\u0007\u0002\u00021\u0001\u0002\"\u0002\u0011\u0001\t\u0003\u0011\u0003\"B\u0013\u0001\r\u00031\u0003\"\u0002\u0016\u0001\r\u0003Y\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0004BB#\u0001A\u0003%a\tC\u0003O\u0001\u0011\u0005s\nC\u0003V\u0001\u0011%a\u000b\u0003\u0004Y\u0001\u0001\u0006I!\u0017\u0005\u0006A\u0002!I!\u0019\u0005\u0007i\u0002!)\u0001D;\u0003-\u0005\u001b\u0018P\\2DQ\u0006tg.\u001a7PEN,'O^1cY\u0016T!!\u0004\b\u0002\u00079LwNC\u0001\u0010\u0003\u0015iwN\\5y'\t\u0001\u0011\u0003E\u0002\u0013+]i\u0011a\u0005\u0006\u0003)9\t\u0001B]3bGRLg/Z\u0005\u0003-M\u0011!b\u00142tKJ4\u0018M\u00197f!\rA2$H\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t)\u0011I\u001d:bsB\u0011\u0001DH\u0005\u0003?e\u0011AAQ=uK\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001$!\t!\u0003!D\u0001\r\u0003)\u0011WO\u001a4feNK'0Z\u000b\u0002OA\u0011\u0001\u0004K\u0005\u0003Se\u00111!\u00138u\u0003\u001d\u0019\u0007.\u00198oK2,\u0012\u0001\f\t\u000415z\u0013B\u0001\u0018\u001a\u0005\u0019y\u0005\u000f^5p]B\u0011A\u0005M\u0005\u0003c1\u0011A\"Q:z]\u000e\u001c\u0005.\u00198oK2\fA!\u001b8jiR\u0011A'\u0010\t\u0004kaRT\"\u0001\u001c\u000b\u0005]J\u0012AC2p]\u000e,(O]3oi&\u0011\u0011H\u000e\u0002\u0007\rV$XO]3\u0011\u0005aY\u0014B\u0001\u001f\u001a\u0005\u0011)f.\u001b;\t\u000by\"\u0001\u0019A \u0002\u0015M,(m]2sS\n,'\u000fE\u0002A\u0007^i\u0011!\u0011\u0006\u0003\u0005N\t\u0011b\u001c2tKJ4XM]:\n\u0005\u0011\u000b%AC*vEN\u001c'/\u001b2fe\u0006iq/Y:Tk\n\u001c8M]5cK\u0012\u0004\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\r\u0005$x.\\5d\u0015\tYe\"A\u0005fq\u0016\u001cW\u000f^5p]&\u0011Q\n\u0013\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002#Ut7/\u00194f'V\u00147o\u0019:jE\u00164e\u000e\u0006\u0002Q)B\u0011\u0011KU\u0007\u0002\u0015&\u00111K\u0013\u0002\u000b\u0007\u0006t7-\u001a7bE2,\u0007\"\u0002 \u0007\u0001\u0004y\u0014\u0001D:uCJ$(+Z1eS:<GC\u0001)X\u0011\u0015qt\u00011\u0001@\u0003\u0019\u0011WO\u001a4feB\u0011!LX\u0007\u00027*\u0011Q\u0002\u0018\u0006\u0002;\u0006!!.\u0019<b\u0013\ty6L\u0001\u0006CsR,')\u001e4gKJ\fA\u0001\\8paR\u0019!M\\8\u0015\u0005\rL\u0007c\u00013h/5\tQM\u0003\u0002g\u001d\u0005!QM^1m\u0013\tAWM\u0001\u0003UCN\\\u0007\"\u00026\n\u0001\bY\u0017!C:dQ\u0016$W\u000f\\3s!\t\tF.\u0003\u0002n\u0015\nI1k\u00195fIVdWM\u001d\u0005\u0006}%\u0001\ra\u0010\u0005\u0006a&\u0001\r!]\u0001\ta>\u001c\u0018\u000e^5p]B\u0011\u0001D]\u0005\u0003gf\u0011A\u0001T8oO\u0006a1\r\\8tK\u000eC\u0017M\u001c8fYR\ta\u000f\u0006\u0002;o\")!N\u0003a\u0002W\u0002")
public abstract class AsyncChannelObservable
extends Observable<byte[]> {
    private final AtomicBoolean wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    private final ByteBuffer buffer = ByteBuffer.allocate(this.bufferSize());

    public abstract int bufferSize();

    public abstract Option<AsyncChannel> channel();

    public Future<BoxedUnit> init(Subscriber<byte[]> subscriber) {
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public Cancelable unsafeSubscribeFn(Subscriber<byte[]> subscriber) {
        Cancelable cancelable;
        if (this.wasSubscribed.getAndSet(true)) {
            subscriber.onError((Throwable)APIContractViolationException$.MODULE$.apply(this.getClass().getName()));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            try {
                cancelable = this.startReading(subscriber);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                subscriber.onError(e);
                this.closeChannel(subscriber.scheduler());
                Cancelable cancelable2 = Cancelable$.MODULE$.empty();
                cancelable = cancelable2;
            }
        }
        return cancelable;
    }

    private Cancelable startReading(Subscriber<byte[]> subscriber) {
        Callback<Throwable, byte[]> taskCallback = new Callback<Throwable, byte[]>(this, subscriber){
            private final /* synthetic */ AsyncChannelObservable $outer;
            public final Subscriber subscriber$1;

            public void onSuccess(byte[] value) {
                this.$outer.channel().collect((PartialFunction)new Serializable(this){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final <A1 extends AsyncChannel, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1.closeOnComplete()) {
                            this.$outer.monix$nio$AsyncChannelObservable$$anon$$$outer().closeChannel(this.$outer.subscriber$1.scheduler());
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(AsyncChannel x1) {
                        AsyncChannel asyncChannel = x1;
                        boolean bl = asyncChannel.closeOnComplete();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public void onError(Throwable ex) {
                this.$outer.closeChannel(this.subscriber$1.scheduler());
                this.subscriber$1.onError(ex);
            }

            public /* synthetic */ AsyncChannelObservable monix$nio$AsyncChannelObservable$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriber$1 = subscriber$1;
            }
        };
        Cancelable cancelable = Task$.MODULE$.fromFuture(this.init(subscriber)).flatMap((Function1 & Serializable)x$1 -> this.loop(subscriber, 0L, subscriber.scheduler())).executeWithOptions((Function1 & Serializable)x$2 -> x$2.enableAutoCancelableRunLoops()).runAsync((Function1)taskCallback, subscriber.scheduler());
        Cancelable extraCancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            cancelable.cancel();
            this.closeChannel(subscriber.scheduler());
        });
        return SingleAssignCancelable$.MODULE$.plusOne(extraCancelable);
    }

    private Task<byte[]> loop(Subscriber<byte[]> subscriber, long position, Scheduler scheduler) {
        this.buffer.clear();
        return (Task)this.channel().map((Function1 & Serializable)ch -> ch.read($this.buffer, position).doOnCancel(Task$.MODULE$.defer((Function0 & Serializable)() -> ch.close())).flatMap((Function1 & Serializable)result -> AsyncChannelObservable.$anonfun$loop$3(this, subscriber, position, scheduler, BoxesRunTime.unboxToInt((Object)result)))).getOrElse((Function0 & Serializable)() -> Task$.MODULE$.now((Object)Bytes$.MODULE$.emptyBytes()));
    }

    public final void closeChannel(Scheduler scheduler) {
        this.channel().foreach((Function1 & Serializable)x$3 -> x$3.close().runToFuture(scheduler));
    }

    public static final /* synthetic */ Task $anonfun$loop$3(AsyncChannelObservable $this, Subscriber subscriber$2, long position$1, Scheduler scheduler$1, int result) {
        Task task;
        Product bytes = Bytes$.MODULE$.apply($this.buffer, result);
        Product product = bytes;
        if (EmptyBytes$.MODULE$.equals(product)) {
            subscriber$2.onComplete();
            task = Task$.MODULE$.now((Object)Bytes$.MODULE$.emptyBytes());
        } else if (product instanceof NonEmptyBytes) {
            NonEmptyBytes nonEmptyBytes = (NonEmptyBytes)product;
            byte[] arr = nonEmptyBytes.arr();
            task = Task$.MODULE$.fromFuture(subscriber$2.onNext((Object)arr)).flatMap((Function1 & Serializable)x0$1 -> {
                Task task;
                Ack ack = x0$1;
                if (Ack.Continue$.MODULE$.equals(ack)) {
                    task = $this.loop((Subscriber<byte[]>)subscriber$2, position$1 + (long)result, scheduler$1);
                } else if (Ack.Stop$.MODULE$.equals(ack)) {
                    task = Task$.MODULE$.now((Object)Bytes$.MODULE$.emptyBytes());
                } else {
                    throw new MatchError((Object)ack);
                }
                return task;
            });
        } else {
            throw new MatchError((Object)product);
        }
        return task;
    }
}

