/*
 * Decompiled with CFR 0.152.
 */
package monix.nio.file;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.nio.file.AsyncFileChannel$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f!B\u000e\u001d\u0003\u0003\u0019\u0003\"B\u0018\u0001\t\u0003\u0001\u0004\"B\u001a\u0001\r\u0003!\u0004\"B\u001e\u0001\r\u0003a\u0004\"B\u001e\u0001\t\u00039\u0006\"\u00020\u0001\r\u0003y\u0006\"\u00020\u0001\t\u0003q\u0007\"\u0002:\u0001\r\u0003\u0019\b\"\u0002:\u0001\t\u0003A\b\"B>\u0001\r\u0003a\bBB>\u0001\t\u0003\t\u0019aB\u0004\u0002\nqA\t!a\u0003\u0007\rma\u0002\u0012AA\u0007\u0011\u0019yC\u0002\"\u0001\u0002\u0016!9\u0011q\u0003\u0007\u0005\u0002\u0005eaABA#\u0019\u0019\t9\u0005\u0003\u0006\u0002J=\u0011\t\u0011)A\u0005\u0003\u0017B!\"a\u0016\u0010\u0005\u0003\u0005\u000b1BA\u0011\u0011\u0019ys\u0002\"\u0001\u0002Z!)1g\u0004C!i!A\u0011QM\b!\u0002\u0013\t9\u0007C\u0004\u0002n=!\t%a\u001c\t\rmzA\u0011IA9\u0011\u0019qv\u0002\"\u0011\u0002v!1!o\u0004C!\u0003{Baa_\b\u0005B\u0005\u0015\u0005\u0002CAG\u001f\u0001\u0006I!a$\u0003!\u0005\u001b\u0018P\\2GS2,7\t[1o]\u0016d'BA\u000f\u001f\u0003\u00111\u0017\u000e\\3\u000b\u0005}\u0001\u0013a\u00018j_*\t\u0011%A\u0003n_:L\u0007p\u0001\u0001\u0014\u0007\u0001!C\u0006\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!A.\u00198h\u0015\u0005I\u0013\u0001\u00026bm\u0006L!a\u000b\u0014\u0003\r=\u0013'.Z2u!\t)S&\u0003\u0002/M\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016\fa\u0001P5oSRtD#A\u0019\u0011\u0005I\u0002Q\"\u0001\u000f\u0002\r%\u001cx\n]3o+\u0005)\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$a\u0002\"p_2,\u0017M\\\u0001\u0005g&TX\r\u0006\u0002>\u0001B\u0011aGP\u0005\u0003\u007f]\u0012A!\u00168ji\")\u0011i\u0001a\u0001\u0005\u0006\u00111M\u0019\t\u0005\u0007\u001aCE+D\u0001E\u0015\t)\u0005%A\u0005fq\u0016\u001cW\u000f^5p]&\u0011q\t\u0012\u0002\t\u0007\u0006dGNY1dWB\u0011\u0011*\u0015\b\u0003\u0015>s!a\u0013(\u000e\u00031S!!\u0014\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014B\u0001)8\u0003\u001d\u0001\u0018mY6bO\u0016L!AU*\u0003\u0013QC'o\\<bE2,'B\u0001)8!\t1T+\u0003\u0002Wo\t!Aj\u001c8h+\u0005A\u0006cA-])6\t!L\u0003\u0002\\o\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005uS&A\u0002$viV\u0014X-\u0001\u0003sK\u0006$G\u0003B\u001faO&DQ!Y\u0003A\u0002\t\f1\u0001Z:u!\t\u0019W-D\u0001e\u0015\ty\u0002&\u0003\u0002gI\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b!,\u0001\u0019\u0001+\u0002\u0011A|7/\u001b;j_:DQ!Q\u0003A\u0002)\u0004Ba\u0011$IWB\u0011a\u0007\\\u0005\u0003[^\u00121!\u00138u)\ry\u0007/\u001d\t\u00043r[\u0007\"B1\u0007\u0001\u0004\u0011\u0007\"\u00025\u0007\u0001\u0004!\u0016!B<sSR,G\u0003B\u001fum^DQ!^\u0004A\u0002\t\f1a\u001d:d\u0011\u0015Aw\u00011\u0001U\u0011\u0015\tu\u00011\u0001k)\ry\u0017P\u001f\u0005\u0006k\"\u0001\rA\u0019\u0005\u0006Q\"\u0001\r\u0001V\u0001\u0006M2,8\u000f\u001b\u000b\u0004{u|\b\"\u0002@\n\u0001\u0004)\u0014!D<sSR,W*\u001a;b\t\u0006$\u0018\r\u0003\u0004B\u0013\u0001\u0007\u0011\u0011\u0001\t\u0005\u0007\u001aCU\b\u0006\u0003\u0002\u0006\u0005\u001d\u0001cA-]{!)aP\u0003a\u0001k\u0005\u0001\u0012i]=oG\u001aKG.Z\"iC:tW\r\u001c\t\u0003e1\u00192\u0001DA\b!\r1\u0014\u0011C\u0005\u0004\u0003'9$AB!osJ+g\r\u0006\u0002\u0002\f\u0005)\u0011\r\u001d9msR1\u00111DA\u0014\u0003k!2!MA\u000f\u0011\u001d\tyB\u0004a\u0002\u0003C\t\u0011a\u001d\t\u0004\u0007\u0006\r\u0012bAA\u0013\t\nI1k\u00195fIVdWM\u001d\u0005\b\u0003Sq\u0001\u0019AA\u0016\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u00055\u0012\u0011G\u0007\u0003\u0003_Q!!\b3\n\t\u0005M\u0012q\u0006\u0002\u0005!\u0006$\b\u000eC\u0004\u000289\u0001\r!!\u000f\u0002\u000f=\u0004H/[8ogB)a'a\u000f\u0002@%\u0019\u0011QH\u001c\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u0002.\u0005\u0005\u0013\u0002BA\"\u0003_\u0011!c\u0015;b]\u0012\f'\u000fZ(qK:|\u0005\u000f^5p]\n\u0019b*Z<J\u001f&k\u0007\u000f\\3nK:$\u0018\r^5p]N\u0011q\"M\u0001\u000bk:$WM\u001d7zS:<\u0007\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005EC-\u0001\u0005dQ\u0006tg.\u001a7t\u0013\u0011\t)&a\u0014\u0003/\u0005\u001b\u0018P\\2ie>tw.^:GS2,7\t[1o]\u0016d\u0017!C:dQ\u0016$W\u000f\\3s)\u0011\tY&a\u0019\u0015\t\u0005u\u0013\u0011\r\t\u0004\u0003?zQ\"\u0001\u0007\t\u000f\u0005]#\u0003q\u0001\u0002\"!9\u0011\u0011\n\nA\u0002\u0005-\u0013AC2b]\u000e,G.\u00192mKB\u00191)!\u001b\n\u0007\u0005-DI\u0001\u0006DC:\u001cW\r\\1cY\u0016\fQa\u00197pg\u0016$\u0012!\u0010\u000b\u0004{\u0005M\u0004\"B!\u0017\u0001\u0004\u0011EcB\u001f\u0002x\u0005e\u00141\u0010\u0005\u0006C^\u0001\rA\u0019\u0005\u0006Q^\u0001\r\u0001\u0016\u0005\u0006\u0003^\u0001\rA\u001b\u000b\b{\u0005}\u0014\u0011QAB\u0011\u0015)\b\u00041\u0001c\u0011\u0015A\u0007\u00041\u0001U\u0011\u0015\t\u0005\u00041\u0001k)\u0015i\u0014qQAF\u0011\u0019\tI)\u0007a\u0001k\u0005AQ.\u001a;b\t\u0006$\u0018\r\u0003\u0004B3\u0001\u0007\u0011\u0011A\u0001\u0012G>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014(#BAII\u0005UeABAJ5\u0001\tyI\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0004\u0002N\u0005]\u00151\u00146\n\t\u0005e\u0015q\n\u0002\u0012\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\bcA\u0013\u0002\u001e&\u0019\u0011q\u0014\u0014\u0003\u000f%sG/Z4fe\u0002")
public abstract class AsyncFileChannel
implements AutoCloseable {
    public static AsyncFileChannel apply(Path path, Seq<StandardOpenOption> seq, Scheduler scheduler) {
        return AsyncFileChannel$.MODULE$.apply(path, seq, scheduler);
    }

    public abstract boolean isOpen();

    public abstract void size(Callback<Throwable, Object> var1);

    public Future<Object> size() {
        Promise p = Promise$.MODULE$.apply();
        this.size((Callback<Throwable, Object>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract void read(ByteBuffer var1, long var2, Callback<Throwable, Object> var4);

    public Future<Object> read(ByteBuffer dst, long position) {
        Promise p = Promise$.MODULE$.apply();
        this.read(dst, position, (Callback<Throwable, Object>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract void write(ByteBuffer var1, long var2, Callback<Throwable, Object> var4);

    public Future<Object> write(ByteBuffer src, long position) {
        Promise p = Promise$.MODULE$.apply();
        this.write(src, position, (Callback<Throwable, Object>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract void flush(boolean var1, Callback<Throwable, BoxedUnit> var2);

    public Future<BoxedUnit> flush(boolean writeMetaData) {
        Promise p = Promise$.MODULE$.apply();
        this.flush(writeMetaData, (Callback<Throwable, BoxedUnit>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public static final class NewIOImplementation
    extends AsyncFileChannel {
        private final AsynchronousFileChannel underlying;
        private final Scheduler scheduler;
        private final Cancelable cancelable;
        private final CompletionHandler<Integer, Callback<Throwable, Object>> completionHandler;

        @Override
        public boolean isOpen() {
            return this.underlying.isOpen();
        }

        @Override
        public void close() {
            this.cancelable.cancel();
        }

        @Override
        public void size(Callback<Throwable, Object> cb) {
            new Scheduler.Extensions(Scheduler$.MODULE$.Extensions(this.scheduler)).executeAsync(() -> {
                boolean streamErrors = true;
                try {
                    long size = $this.underlying.size();
                    streamErrors = false;
                    cb.onSuccess((Object)BoxesRunTime.boxToLong((long)size));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable ex = (Throwable)option.get();
                        if (streamErrors) {
                            cb.onError((Object)ex);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            $this.scheduler.reportFailure(ex);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    }
                    throw throwable;
                }
            });
        }

        @Override
        public void read(ByteBuffer dst, long position, Callback<Throwable, Object> cb) {
            Predef$.MODULE$.require(position >= 0L, (Function0 & Serializable)() -> "position >= 0");
            Predef$.MODULE$.require(!dst.isReadOnly(), (Function0 & Serializable)() -> "!dst.isReadOnly");
            try {
                this.underlying.read(dst, position, cb, this.completionHandler);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    cb.onError((Object)ex);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        @Override
        public void write(ByteBuffer src, long position, Callback<Throwable, Object> cb) {
            Predef$.MODULE$.require(position >= 0L, (Function0 & Serializable)() -> "position >= 0");
            try {
                this.underlying.write(src, position, cb, this.completionHandler);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    cb.onError((Object)ex);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        @Override
        public void flush(boolean metaData, Callback<Throwable, BoxedUnit> cb) {
            new Scheduler.Extensions(Scheduler$.MODULE$.Extensions(this.scheduler)).executeAsync(() -> {
                try {
                    package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        $this.underlying.force(true);
                        cb.onSuccess((Object)BoxedUnit.UNIT);
                    });
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        cb.onError((Object)ex);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            });
        }

        public NewIOImplementation(AsynchronousFileChannel underlying, Scheduler scheduler) {
            this.underlying = underlying;
            this.scheduler = scheduler;
            this.cancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    $this.underlying.close();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        $this.scheduler.reportFailure(ex);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            });
            this.completionHandler = new CompletionHandler<Integer, Callback<Throwable, Object>>(null){

                public void completed(Integer result, Callback<Throwable, Object> cb) {
                    cb.onSuccess((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(result)));
                }

                public void failed(Throwable exc, Callback<Throwable, Object> cb) {
                    cb.onError((Object)exc);
                }
            };
        }
    }
}

