/*
 * Decompiled with CFR 0.152.
 */
package monix.nio.file;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.concurrent.TimeUnit;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.nio.file.WatchService$;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005%f!B\f\u0019\u0003\u0003y\u0002\"B\u0016\u0001\t\u0003a\u0003\"B\u0018\u0001\r\u0003\u0001\u0004\"B\u0018\u0001\t\u0003I\u0007\"B\u0018\u0001\r\u0003\u0001\b\"B\u0018\u0001\t\u0003\u0011\b\"B:\u0001\r\u0003!\b\"B:\u0001\t\u00039x!B=\u0019\u0011\u0003Qh!B\f\u0019\u0011\u0003Y\b\"B\u0016\n\t\u0003y\b\"CA\u0001\u0013\t\u0007I\u0011AA\u0002\u0011!\tI$\u0003Q\u0001\n\u0005\u0015\u0001bBA%\u0013\u0011\u0005\u00111\n\u0004\u0007\u0003oJa!!\u001f\t\u0015\u0005mdB!A!\u0002\u0013\ti\b\u0003\u0006\u0002R9\u0011\t\u0011)A\u0006\u0003'Baa\u000b\b\u0005\u0002\u0005\u0005\u0005BB\u0018\u000f\t\u0003\ni\t\u0003\u00040\u001d\u0011\u0005\u0013Q\u0013\u0005\u0007g:!\t%!'\t\u000f\u0005ue\u0002\"\u0011\u0002 \"A\u0011\u0011\u0015\b!\u0002\u0013\t\u0019K\u0001\u0007XCR\u001c\u0007nU3sm&\u001cWM\u0003\u0002\u001a5\u0005!a-\u001b7f\u0015\tYB$A\u0002oS>T\u0011!H\u0001\u0006[>t\u0017\u000e_\u0002\u0001'\r\u0001\u0001\u0005\u000b\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019y%M[3diB\u0011\u0011%K\u0005\u0003U\t\u0012Q\"Q;u_\u000ecwn]3bE2,\u0017A\u0002\u001fj]&$h\bF\u0001.!\tq\u0003!D\u0001\u0019\u0003\u0011\u0001x\u000e\u001c7\u0015\tE:DH\u0015\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0005+:LG\u000fC\u00039\u0005\u0001\u0007\u0011(A\u0004uS6,w.\u001e;\u0011\u0005IR\u0014BA\u001e4\u0005\u0011auN\\4\t\u000bu\u0012\u0001\u0019\u0001 \u0002\u0011QLW.Z+oSR\u0004\"aP(\u000f\u0005\u0001ceBA!J\u001d\t\u0011uI\u0004\u0002D\r6\tAI\u0003\u0002F=\u00051AH]8pizJ\u0011\u0001N\u0005\u0003\u0011N\n!bY8oGV\u0014(/\u001a8u\u0013\tQ5*\u0001\u0005ekJ\fG/[8o\u0015\tA5'\u0003\u0002N\u001d\u00069\u0001/Y2lC\u001e,'B\u0001&L\u0013\t\u0001\u0016K\u0001\u0005US6,WK\\5u\u0015\tie\nC\u0003T\u0005\u0001\u0007A+\u0001\u0002dEB!Q\u000b\u0017.a\u001b\u00051&BA,\u001d\u0003%)\u00070Z2vi&|g.\u0003\u0002Z-\nA1)\u00197mE\u0006\u001c7\u000e\u0005\u0002\\;:\u0011!\tX\u0005\u0003\u001bNJ!AX0\u0003\u0013QC'o\\<bE2,'BA'4!\r\u0011\u0014mY\u0005\u0003EN\u0012aa\u00149uS>t\u0007C\u00013h\u001b\u0005)'BA\rg\u0015\tYB%\u0003\u0002iK\nAq+\u0019;dQ.+\u0017\u0010F\u0002k]>\u00042a\u001b7a\u001b\u0005Y\u0015BA7L\u0005\u00191U\u000f^;sK\")\u0001h\u0001a\u0001s!)Qh\u0001a\u0001}Q\u0011\u0011'\u001d\u0005\u0006'\u0012\u0001\r\u0001\u0016\u000b\u0002U\u0006!A/Y6f)\t\tT\u000fC\u0003T\r\u0001\u0007a\u000f\u0005\u0003V1j\u001bG#\u0001=\u0011\u0007-d7-\u0001\u0007XCR\u001c\u0007nU3sm&\u001cW\r\u0005\u0002/\u0013M\u0011\u0011\u0002 \t\u0003euL!A`\u001a\u0003\r\u0005s\u0017PU3g)\u0005Q\u0018aD*vaB|'\u000f^3e\u000bZ,g\u000e^:\u0016\u0005\u0005\u0015\u0001CBA\u0004\u0003\u001f\t)B\u0004\u0003\u0002\n\u0005-\u0001CA\"4\u0013\r\tiaM\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00111\u0003\u0002\u0004'\u0016$(bAA\u0007gA\"\u0011qCA\u001b!\u0019\tI\"a\u000b\u000229!\u00111DA\u0014\u001d\u0011\ti\"!\n\u000f\t\u0005}\u00111\u0005\b\u0004\u0007\u0006\u0005\u0012\"A\u0013\n\u0005m!\u0013BA\rg\u0013\r\tI#Z\u0001\u000b/\u0006$8\r[#wK:$\u0018\u0002BA\u0017\u0003_\u0011AaS5oI*\u0019\u0011\u0011F3\u0011\t\u0005M\u0012Q\u0007\u0007\u0001\t-\t9\u0004DA\u0001\u0002\u0003\u0015\t!a\u000f\u0003\u0007}#\u0013'\u0001\tTkB\u0004xN\u001d;fI\u00163XM\u001c;tAE!\u0011QHA\"!\r\u0011\u0014qH\u0005\u0004\u0003\u0003\u001a$a\u0002(pi\"Lgn\u001a\t\u0004e\u0005\u0015\u0013bAA$g\t\u0019\u0011I\\=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u00055\u0013\u0011LA2)\ri\u0013q\n\u0005\b\u0003#j\u00019AA*\u0003%\u00198\r[3ek2,'\u000fE\u0002V\u0003+J1!a\u0016W\u0005%\u00196\r[3ek2,'\u000fC\u0004\u0002\\5\u0001\r!!\u0018\u0002\tA\fG\u000f\u001b\t\u0004I\u0006}\u0013bAA1K\n!\u0001+\u0019;i\u0011\u001d\t)'\u0004a\u0001\u0003O\na!\u001a<f]R\u001c\b#\u0002\u001a\u0002j\u00055\u0014bAA6g\tQAH]3qK\u0006$X\r\u001a 1\t\u0005=\u00141\u000f\t\u0007\u00033\tY#!\u001d\u0011\t\u0005M\u00121\u000f\u0003\r\u0003k\n\u0019'!A\u0001\u0002\u000b\u0005\u00111\b\u0002\u0004?\u0012\u0012$a\b(J\u001f^\u000bGo\u00195feN+'O^5dK&k\u0007\u000f\\3nK:$\u0018\r^5p]N\u0011a\"L\u0001\bo\u0006$8\r[3s!\r!\u0017qP\u0005\u0003/\u0015$B!a!\u0002\fR!\u0011QQAE!\r\t9ID\u0007\u0002\u0013!9\u0011\u0011K\tA\u0004\u0005M\u0003bBA>#\u0001\u0007\u0011Q\u0010\u000b\bc\u0005=\u0015\u0011SAJ\u0011\u0015A$\u00031\u0001:\u0011\u0015i$\u00031\u0001?\u0011\u0015\u0019&\u00031\u0001U)\r\t\u0014q\u0013\u0005\u0006'N\u0001\r\u0001\u0016\u000b\u0004c\u0005m\u0005\"B*\u0015\u0001\u00041\u0018!B2m_N,G#A\u0019\u0002\u0015\r\fgnY3mC\ndW\rE\u0002V\u0003KK1!a*W\u0005)\u0019\u0015M\\2fY\u0006\u0014G.\u001a")
public abstract class WatchService
implements AutoCloseable {
    public static WatchService apply(Path path, Seq<WatchEvent.Kind<?>> seq, Scheduler scheduler) {
        return WatchService$.MODULE$.apply(path, seq, scheduler);
    }

    public static Set<WatchEvent.Kind<?>> SupportedEvents() {
        return WatchService$.MODULE$.SupportedEvents();
    }

    public abstract void poll(long var1, TimeUnit var3, Callback<Throwable, Option<WatchKey>> var4);

    public Future<Option<WatchKey>> poll(long timeout, TimeUnit timeUnit) {
        Promise p = Promise$.MODULE$.apply();
        this.poll(timeout, timeUnit, (Callback<Throwable, Option<WatchKey>>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract void poll(Callback<Throwable, Option<WatchKey>> var1);

    public Future<Option<WatchKey>> poll() {
        Promise p = Promise$.MODULE$.apply();
        this.poll((Callback<Throwable, Option<WatchKey>>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract void take(Callback<Throwable, WatchKey> var1);

    public Future<WatchKey> take() {
        Promise p = Promise$.MODULE$.apply();
        this.take((Callback<Throwable, WatchKey>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public static final class NIOWatcherServiceImplementation
    extends WatchService {
        private final java.nio.file.WatchService watcher;
        private final Scheduler scheduler;
        private final Cancelable cancelable;

        @Override
        public void poll(long timeout, TimeUnit timeUnit, Callback<Throwable, Option<WatchKey>> cb) {
            try {
                Option key = Option$.MODULE$.apply((Object)this.watcher.poll(timeout, timeUnit));
                cb.onSuccess((Object)key);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    cb.onError((Object)ex);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        @Override
        public void poll(Callback<Throwable, Option<WatchKey>> cb) {
            try {
                Option key = Option$.MODULE$.apply((Object)this.watcher.poll());
                cb.onSuccess((Object)key);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    cb.onError((Object)ex);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        @Override
        public void take(Callback<Throwable, WatchKey> cb) {
            try {
                WatchKey key = this.watcher.take();
                cb.onSuccess((Object)key);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    cb.onError((Object)ex);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        @Override
        public void close() {
            this.cancelable.cancel();
        }

        public NIOWatcherServiceImplementation(java.nio.file.WatchService watcher, Scheduler scheduler) {
            this.watcher = watcher;
            this.scheduler = scheduler;
            this.cancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    $this.watcher.close();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        $this.scheduler.reportFailure(ex);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            });
        }
    }
}

