/*
 * Decompiled with CFR 0.152.
 */
package monix.nio;

import java.io.Serializable;
import java.nio.ByteBuffer;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.Callback;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.execution.exceptions.APIContractViolationException$;
import monix.nio.AsyncChannel;
import monix.nio.AsyncChannelObservable$;
import monix.nio.internal.Bytes;
import monix.nio.internal.Bytes$;
import monix.nio.internal.EmptyBytes$;
import monix.nio.internal.NonEmptyBytes;
import monix.nio.internal.NonEmptyBytes$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public abstract class AsyncChannelObservable
extends Observable<byte[]> {
    private final AtomicBoolean wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    private final ByteBuffer buffer = ByteBuffer.allocate(this.bufferSize());

    public abstract int bufferSize();

    public abstract Option<AsyncChannel> channel();

    public Future<BoxedUnit> init(Subscriber<byte[]> subscriber) {
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public Cancelable unsafeSubscribeFn(Subscriber<byte[]> subscriber) {
        Cancelable cancelable;
        if (this.wasSubscribed.getAndSet(true)) {
            subscriber.onError((Throwable)APIContractViolationException$.MODULE$.apply(this.getClass().getName()));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            try {
                cancelable = this.startReading(subscriber);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    subscriber.onError(e);
                    this.closeChannel(subscriber.scheduler());
                    cancelable = Cancelable$.MODULE$.empty();
                }
                throw throwable;
            }
        }
        return cancelable;
    }

    private Cancelable startReading(Subscriber<byte[]> subscriber) {
        Callback<Throwable, byte[]> taskCallback = new Callback<Throwable, byte[]>(subscriber, this){
            public final Subscriber monix$nio$AsyncChannelObservable$$anon$1$$subscriber$1;
            private final AsyncChannelObservable $outer;
            {
                this.monix$nio$AsyncChannelObservable$$anon$1$$subscriber$1 = subscriber$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onSuccess(byte[] value) {
                this.$outer.channel().collect((PartialFunction)new Serializable(this){
                    private final $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(AsyncChannel x) {
                        AsyncChannel asyncChannel = x;
                        AsyncChannel sc = asyncChannel;
                        return sc.closeOnComplete();
                    }

                    public final Object applyOrElse(AsyncChannel x, Function1 function1) {
                        Object object;
                        AsyncChannel asyncChannel = x;
                        AsyncChannel sc = asyncChannel;
                        if (sc.closeOnComplete()) {
                            this.$outer.monix$nio$AsyncChannelObservable$_$_$$anon$$$outer().closeChannel(this.$outer.monix$nio$AsyncChannelObservable$$anon$1$$subscriber$1.scheduler());
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply((Object)x);
                        }
                        return object;
                    }
                });
            }

            public void onError(Throwable ex) {
                this.$outer.closeChannel(this.monix$nio$AsyncChannelObservable$$anon$1$$subscriber$1.scheduler());
                this.monix$nio$AsyncChannelObservable$$anon$1$$subscriber$1.onError(ex);
            }

            public final AsyncChannelObservable monix$nio$AsyncChannelObservable$_$_$$anon$$$outer() {
                return this.$outer;
            }
        };
        Cancelable cancelable = Task$.MODULE$.fromFuture(this.init(subscriber)).flatMap((Function1 & Serializable)_$1 -> this.loop(subscriber, 0L, subscriber.scheduler())).executeWithOptions((Function1 & Serializable)_$2 -> _$2.enableAutoCancelableRunLoops()).runAsync((Function1)taskCallback, subscriber.scheduler());
        Cancelable extraCancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            cancelable.cancel();
            this.closeChannel(subscriber.scheduler());
        });
        return SingleAssignCancelable$.MODULE$.plusOne(extraCancelable);
    }

    private Task<byte[]> loop(Subscriber<byte[]> subscriber, long position, Scheduler scheduler) {
        this.buffer.clear();
        return (Task)this.channel().map((Function1 & Serializable)ch -> ch.read(this.buffer, position).doOnCancel(Task$.MODULE$.defer(() -> AsyncChannelObservable.loop$$anonfun$3$$anonfun$1(ch))).flatMap((Function1 & Serializable)result -> this.loop$$anonfun$5$$anonfun$3(subscriber, position, scheduler, BoxesRunTime.unboxToInt((Object)result)))).getOrElse(AsyncChannelObservable::loop$$anonfun$2);
    }

    public final void closeChannel(Scheduler scheduler) {
        this.channel().foreach((Function1 & Serializable)_$3 -> _$3.close().runToFuture(scheduler));
    }

    private static final Task loop$$anonfun$3$$anonfun$1(AsyncChannel ch$1) {
        return ch$1.close();
    }

    private final /* synthetic */ Task loop$$anonfun$5$$anonfun$3(Subscriber subscriber$5, long position$2, Scheduler scheduler$2, int result) {
        Task task;
        Bytes bytes = Bytes$.MODULE$.apply(this.buffer, result);
        Bytes bytes2 = bytes;
        if (EmptyBytes$.MODULE$.equals(bytes2)) {
            subscriber$5.onComplete();
            task = Task$.MODULE$.now((Object)Bytes$.MODULE$.emptyBytes());
        } else if (bytes2 instanceof NonEmptyBytes) {
            byte[] byArray;
            NonEmptyBytes nonEmptyBytes = NonEmptyBytes$.MODULE$.unapply((NonEmptyBytes)bytes2);
            byte[] arr = byArray = nonEmptyBytes._1();
            task = Task$.MODULE$.fromFuture(subscriber$5.onNext((Object)arr)).flatMap((Function1 & Serializable)x$1 -> {
                Task task;
                Ack ack = x$1;
                if (Ack.Continue$.MODULE$.equals(ack)) {
                    task = this.loop((Subscriber<byte[]>)subscriber$5, position$2 + (long)result, scheduler$2);
                } else if (Ack.Stop$.MODULE$.equals(ack)) {
                    task = Task$.MODULE$.now((Object)Bytes$.MODULE$.emptyBytes());
                } else {
                    throw new MatchError((Object)ack);
                }
                return task;
            });
        } else {
            throw new MatchError((Object)bytes2);
        }
        return task;
    }

    private static final Task loop$$anonfun$2() {
        return Task$.MODULE$.now((Object)Bytes$.MODULE$.emptyBytes());
    }
}

