/*
 * Decompiled with CFR 0.152.
 */
package monix.nio;

import java.io.Serializable;
import java.nio.file.WatchEvent;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.Callback;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.execution.exceptions.APIContractViolationException$;
import monix.nio.WatchService;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public abstract class WatchServiceObservable
extends Observable<WatchEvent<?>[]> {
    private final AtomicBoolean wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    private final Task<WatchEvent<?>[]> emptyTask;

    public WatchServiceObservable() {
        boolean bl = Task$.MODULE$.create();
        this.emptyTask = Task.AsyncBuilder$.CreatePartiallyApplied$.MODULE$.apply$extension(bl, (Function2 & Serializable)(_$3, _$4) -> Cancelable$.MODULE$.empty(), Task.AsyncBuilder$.MODULE$.forCancelable());
    }

    public abstract Option<WatchService> watchService();

    public Cancelable unsafeSubscribeFn(Subscriber<WatchEvent<?>[]> subscriber) {
        Cancelable cancelable;
        if (this.wasSubscribed.getAndSet(true)) {
            subscriber.onError((Throwable)APIContractViolationException$.MODULE$.apply(this.getClass().getName()));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            try {
                cancelable = this.startPolling(subscriber);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    subscriber.onError(e);
                    cancelable = Cancelable$.MODULE$.empty();
                }
                throw throwable;
            }
        }
        return cancelable;
    }

    public Future<BoxedUnit> init(Subscriber<WatchEvent<?>[]> subscriber) {
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    private Cancelable startPolling(Subscriber<WatchEvent<?>[]> subscriber) {
        Callback<Throwable, WatchEvent<?>[]> taskCallback = new Callback<Throwable, WatchEvent<?>[]>(subscriber){
            private final Subscriber subscriber$1;
            {
                this.subscriber$1 = subscriber$6;
            }

            public void onSuccess(WatchEvent[] value) {
            }

            public void onError(Throwable ex) {
                this.subscriber$1.onError(ex);
            }
        };
        Cancelable cancelable = Task$.MODULE$.fromFuture(this.init(subscriber)).flatMap((Function1 & Serializable)_$1 -> this.loop(subscriber, subscriber.scheduler())).executeWithOptions((Function1 & Serializable)_$2 -> _$2.enableAutoCancelableRunLoops()).runAsync((Function1)taskCallback, subscriber.scheduler());
        Cancelable extraCancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> cancelable.cancel());
        return SingleAssignCancelable$.MODULE$.plusOne(extraCancelable);
    }

    private Task<WatchEvent<?>[]> loop(Subscriber<WatchEvent<?>[]> subscriber, Scheduler scheduler) {
        return (Task)this.watchService().map((Function1 & Serializable)ws -> ws.take().doOnCancel(Task$.MODULE$.defer(() -> WatchServiceObservable.loop$$anonfun$3$$anonfun$1(ws))).flatMap((Function1 & Serializable)key -> {
            WatchEvent[] events = (WatchEvent[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(key.pollEvents()).asScala()).toArray(ClassTag$.MODULE$.apply(WatchEvent.class));
            key.reset();
            return Task$.MODULE$.fromFuture(subscriber.onNext((Object)events)).flatMap((Function1 & Serializable)x$1 -> {
                Task<WatchEvent<?>[]> task;
                Ack ack = x$1;
                if (Ack.Continue$.MODULE$.equals(ack)) {
                    task = this.loop(subscriber, scheduler);
                } else if (Ack.Stop$.MODULE$.equals(ack)) {
                    task = this.emptyTask;
                } else {
                    throw new MatchError((Object)ack);
                }
                return task;
            });
        })).getOrElse(this::loop$$anonfun$2);
    }

    private static final Task loop$$anonfun$3$$anonfun$1(WatchService ws$1) {
        return ws$1.close();
    }

    private final Task loop$$anonfun$2() {
        return this.emptyTask;
    }
}

