/*
 * Decompiled with CFR 0.152.
 */
package monix.nio.file;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.nio.file.AsyncFileChannel$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public abstract class AsyncFileChannel
implements AutoCloseable {
    public static AsyncFileChannel apply(Path path, Seq<StandardOpenOption> seq, Scheduler scheduler) {
        return AsyncFileChannel$.MODULE$.apply(path, seq, scheduler);
    }

    public abstract boolean isOpen();

    public abstract void size(Callback<Throwable, Object> var1);

    public Future<Object> size() {
        Promise p = Promise$.MODULE$.apply();
        this.size((Callback<Throwable, Object>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract void read(ByteBuffer var1, long var2, Callback<Throwable, Object> var4);

    public Future<Object> read(ByteBuffer dst, long position) {
        Promise p = Promise$.MODULE$.apply();
        this.read(dst, position, (Callback<Throwable, Object>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract void write(ByteBuffer var1, long var2, Callback<Throwable, Object> var4);

    public Future<Object> write(ByteBuffer src, long position) {
        Promise p = Promise$.MODULE$.apply();
        this.write(src, position, (Callback<Throwable, Object>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract void flush(boolean var1, Callback<Throwable, BoxedUnit> var2);

    public Future<BoxedUnit> flush(boolean writeMetaData) {
        Promise p = Promise$.MODULE$.apply();
        this.flush(writeMetaData, (Callback<Throwable, BoxedUnit>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    private static final class NewIOImplementation
    extends AsyncFileChannel {
        private final AsynchronousFileChannel underlying;
        private final Scheduler scheduler;
        private final Cancelable cancelable;
        private final CompletionHandler<Integer, Callback<Throwable, Object>> completionHandler;

        public NewIOImplementation(AsynchronousFileChannel underlying, Scheduler scheduler) {
            this.underlying = underlying;
            this.scheduler = scheduler;
            this.cancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.liftedTree1$1(underlying, scheduler));
            this.completionHandler = new CompletionHandler<Integer, Callback<Throwable, Object>>(){

                public void completed(Integer result, Callback cb) {
                    cb.onSuccess((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(result)));
                }

                public void failed(Throwable exc, Callback cb) {
                    cb.onError((Object)exc);
                }
            };
        }

        @Override
        public boolean isOpen() {
            return this.underlying.isOpen();
        }

        @Override
        public void close() {
            this.cancelable.cancel();
        }

        @Override
        public void size(Callback<Throwable, Object> cb) {
            this.scheduler.execute(() -> {
                BooleanRef streamErrors = BooleanRef.create((boolean)true);
                this.liftedTree2$1(cb, streamErrors);
            });
        }

        @Override
        public void read(ByteBuffer dst, long position, Callback<Throwable, Object> cb) {
            Predef$.MODULE$.require(position >= 0L, this::read$$anonfun$1);
            Predef$.MODULE$.require(!dst.isReadOnly(), this::read$$anonfun$2);
            try {
                this.underlying.read(dst, position, cb, this.completionHandler);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    cb.onError((Object)ex);
                }
                throw throwable;
            }
        }

        @Override
        public void write(ByteBuffer src, long position, Callback<Throwable, Object> cb) {
            Predef$.MODULE$.require(position >= 0L, this::write$$anonfun$1);
            try {
                this.underlying.write(src, position, cb, this.completionHandler);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    cb.onError((Object)ex);
                }
                throw throwable;
            }
        }

        @Override
        public void flush(boolean metaData, Callback<Throwable, BoxedUnit> cb) {
            this.scheduler.execute(() -> this.liftedTree3$2(cb));
        }

        private final void liftedTree1$1(AsynchronousFileChannel underlying$2, Scheduler scheduler$2) {
            try {
                underlying$2.close();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    scheduler$2.reportFailure(ex);
                }
                throw throwable;
            }
        }

        private final void liftedTree2$1(Callback cb$1, BooleanRef streamErrors$1) {
            try {
                boolean bl;
                long size = this.underlying.size();
                streamErrors$1.elem = bl = false;
                cb$1.onSuccess((Object)BoxesRunTime.boxToLong((long)size));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    if (streamErrors$1.elem) {
                        cb$1.onError((Object)ex);
                    } else {
                        this.scheduler.reportFailure(ex);
                    }
                }
                throw throwable;
            }
        }

        private final String read$$anonfun$1() {
            return "position >= 0";
        }

        private final String read$$anonfun$2() {
            return "!dst.isReadOnly";
        }

        private final String write$$anonfun$1() {
            return "position >= 0";
        }

        private final void liftedTree3$1$$anonfun$1(Callback cb$5) {
            this.underlying.force(true);
            cb$5.onSuccess((Object)BoxedUnit.UNIT);
        }

        private final void liftedTree3$2(Callback cb$4) {
            try {
                package$.MODULE$.blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.liftedTree3$1$$anonfun$1(cb$4)));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    cb$4.onError((Object)ex);
                }
                throw throwable;
            }
        }
    }
}

