/*
 * Decompiled with CFR 0.152.
 */
package monix.nio.file;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.concurrent.TimeUnit;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.nio.file.WatchService$;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public abstract class WatchService
implements AutoCloseable {
    public static Set<WatchEvent.Kind<?>> SupportedEvents() {
        return WatchService$.MODULE$.SupportedEvents();
    }

    public static WatchService apply(Path path, Seq<WatchEvent.Kind<?>> seq, Scheduler scheduler) {
        return WatchService$.MODULE$.apply(path, seq, scheduler);
    }

    public abstract void poll(long var1, TimeUnit var3, Callback<Throwable, Option<WatchKey>> var4);

    public Future<Option<WatchKey>> poll(long timeout, TimeUnit timeUnit) {
        Promise p = Promise$.MODULE$.apply();
        this.poll(timeout, timeUnit, (Callback<Throwable, Option<WatchKey>>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract void poll(Callback<Throwable, Option<WatchKey>> var1);

    public Future<Option<WatchKey>> poll() {
        Promise p = Promise$.MODULE$.apply();
        this.poll((Callback<Throwable, Option<WatchKey>>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract void take(Callback<Throwable, WatchKey> var1);

    public Future<WatchKey> take() {
        Promise p = Promise$.MODULE$.apply();
        this.take((Callback<Throwable, WatchKey>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    private static final class NIOWatcherServiceImplementation
    extends WatchService {
        private final java.nio.file.WatchService watcher;
        private final Scheduler scheduler;
        private final Cancelable cancelable;

        public NIOWatcherServiceImplementation(java.nio.file.WatchService watcher, Scheduler scheduler) {
            this.watcher = watcher;
            this.scheduler = scheduler;
            this.cancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.liftedTree1$1(watcher, scheduler));
        }

        @Override
        public void poll(long timeout, TimeUnit timeUnit, Callback<Throwable, Option<WatchKey>> cb) {
            try {
                Option key = Option$.MODULE$.apply((Object)this.watcher.poll(timeout, timeUnit));
                cb.onSuccess((Object)key);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    cb.onError((Object)ex);
                }
                throw throwable;
            }
        }

        @Override
        public void poll(Callback<Throwable, Option<WatchKey>> cb) {
            try {
                Option key = Option$.MODULE$.apply((Object)this.watcher.poll());
                cb.onSuccess((Object)key);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    cb.onError((Object)ex);
                }
                throw throwable;
            }
        }

        @Override
        public void take(Callback<Throwable, WatchKey> cb) {
            try {
                WatchKey key = this.watcher.take();
                cb.onSuccess((Object)key);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    cb.onError((Object)ex);
                }
                throw throwable;
            }
        }

        @Override
        public void close() {
            this.cancelable.cancel();
        }

        private final void liftedTree1$1(java.nio.file.WatchService watcher$2, Scheduler scheduler$2) {
            try {
                watcher$2.close();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = (Throwable)option.get();
                    scheduler$2.reportFailure(ex);
                }
                throw throwable;
            }
        }
    }
}

