/*
 * Decompiled with CFR 0.152.
 */
package monix.nio.tcp;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.TimeUnit;
import monix.execution.Callback;
import monix.execution.Callback$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.nio.tcp.AsyncSocketChannel$;
import monix.nio.tcp.AsyncSocketChannel$NewIOImplementation$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

public abstract class AsyncSocketChannel
implements AutoCloseable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(AsyncSocketChannel$.class, "0bitmap$1");

    public static AsyncSocketChannel apply(boolean bl, Option<Object> option, Option<Object> option2, boolean bl2, boolean bl3, Scheduler scheduler) {
        return AsyncSocketChannel$.MODULE$.apply(bl, option, option2, bl2, bl3, scheduler);
    }

    public static boolean apply$default$1() {
        return AsyncSocketChannel$.MODULE$.apply$default$1();
    }

    public static Option<Object> apply$default$2() {
        return AsyncSocketChannel$.MODULE$.apply$default$2();
    }

    public static Option<Object> apply$default$3() {
        return AsyncSocketChannel$.MODULE$.apply$default$3();
    }

    public static boolean apply$default$4() {
        return AsyncSocketChannel$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$5() {
        return AsyncSocketChannel$.MODULE$.apply$default$5();
    }

    public abstract void connect(InetSocketAddress var1, Callback<Throwable, BoxedUnit> var2);

    public Future<BoxedUnit> connect(InetSocketAddress remote) {
        Promise p = Promise$.MODULE$.apply();
        this.connect(remote, (Callback<Throwable, BoxedUnit>)Callback$.MODULE$.fromPromise(p));
        return p.future();
    }

    public abstract Option<InetSocketAddress> localAddress();

    public abstract Option<InetSocketAddress> remoteAddress();

    public abstract void read(ByteBuffer var1, Callback<Throwable, Object> var2, Option<Duration> var3);

    public Option<Duration> read$default$3() {
        return None$.MODULE$;
    }

    public Future<Object> read(ByteBuffer dst, Option<Duration> timeout) {
        Promise p = Promise$.MODULE$.apply();
        this.read(dst, (Callback<Throwable, Object>)Callback$.MODULE$.fromPromise(p), timeout);
        return p.future();
    }

    public abstract void write(ByteBuffer var1, Callback<Throwable, Object> var2, Option<Duration> var3);

    public Option<Duration> write$default$3() {
        return None$.MODULE$;
    }

    public Future<Object> write(ByteBuffer src, Option<Duration> timeout) {
        Promise p = Promise$.MODULE$.apply();
        this.write(src, (Callback<Throwable, Object>)Callback$.MODULE$.fromPromise(p), timeout);
        return p.future();
    }

    public abstract void stopReading();

    public abstract void stopWriting();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class NewIOImplementation
    extends AsyncSocketChannel
    implements Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(NewIOImplementation.class, "0bitmap$2");
        public long 0bitmap$2;
        private final boolean reuseAddress;
        private final Option sendBufferSize;
        private final Option receiveBufferSize;
        private final boolean keepAlive;
        private final boolean noDelay;
        private final Scheduler scheduler;
        private Option<AsynchronousSocketChannel> existingAsyncSocketChannelO;
        private Either asyncSocketChannel$lzy1;
        private final Cancelable cancelable;

        public static NewIOImplementation apply(boolean bl, Option<Object> option, Option<Object> option2, boolean bl2, boolean bl3, Scheduler scheduler) {
            return AsyncSocketChannel$NewIOImplementation$.MODULE$.apply(bl, option, option2, bl2, bl3, scheduler);
        }

        public static NewIOImplementation unapply(NewIOImplementation newIOImplementation) {
            return AsyncSocketChannel$NewIOImplementation$.MODULE$.unapply(newIOImplementation);
        }

        public static boolean $lessinit$greater$default$1() {
            return AsyncSocketChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$1();
        }

        public static Option<Object> $lessinit$greater$default$2() {
            return AsyncSocketChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Object> $lessinit$greater$default$3() {
            return AsyncSocketChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$3();
        }

        public static boolean $lessinit$greater$default$4() {
            return AsyncSocketChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$4();
        }

        public static boolean $lessinit$greater$default$5() {
            return AsyncSocketChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$5();
        }

        public NewIOImplementation(boolean reuseAddress, Option<Object> sendBufferSize, Option<Object> receiveBufferSize, boolean keepAlive, boolean noDelay, Scheduler scheduler) {
            this.reuseAddress = reuseAddress;
            this.sendBufferSize = sendBufferSize;
            this.receiveBufferSize = receiveBufferSize;
            this.keepAlive = keepAlive;
            this.noDelay = noDelay;
            this.scheduler = scheduler;
            this.existingAsyncSocketChannelO = None$.MODULE$;
            this.cancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.asyncSocketChannel().fold((Function1)(JProcedure1 & Serializable)_$14 -> {}, (Function1)(JProcedure1 & Serializable)c -> this.liftedTree9$1(scheduler, (AsynchronousSocketChannel)c)));
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.reuseAddress() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.sendBufferSize()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.receiveBufferSize()));
            n = Statics.mix((int)n, (int)(this.keepAlive() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.noDelay() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NewIOImplementation)) return false;
            NewIOImplementation newIOImplementation = (NewIOImplementation)object;
            if (this.reuseAddress() != newIOImplementation.reuseAddress()) return false;
            if (this.keepAlive() != newIOImplementation.keepAlive()) return false;
            if (this.noDelay() != newIOImplementation.noDelay()) return false;
            Option<Object> option = this.sendBufferSize();
            Option<Object> option2 = newIOImplementation.sendBufferSize();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.receiveBufferSize();
            Option<Object> option4 = newIOImplementation.receiveBufferSize();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NewIOImplementation;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "NewIOImplementation";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._4());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._5());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "reuseAddress";
                    break;
                }
                case 1: {
                    string = "sendBufferSize";
                    break;
                }
                case 2: {
                    string = "receiveBufferSize";
                    break;
                }
                case 3: {
                    string = "keepAlive";
                    break;
                }
                case 4: {
                    string = "noDelay";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public boolean reuseAddress() {
            return this.reuseAddress;
        }

        public Option<Object> sendBufferSize() {
            return this.sendBufferSize;
        }

        public Option<Object> receiveBufferSize() {
            return this.receiveBufferSize;
        }

        public boolean keepAlive() {
            return this.keepAlive;
        }

        public boolean noDelay() {
            return this.noDelay;
        }

        public NewIOImplementation(AsynchronousSocketChannel asyncSocketChannel, Scheduler scheduler) {
            this(AsyncSocketChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$1(), AsyncSocketChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$2(), AsyncSocketChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$3(), AsyncSocketChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$4(), AsyncSocketChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$5(), scheduler);
            this.existingAsyncSocketChannelO = Option$.MODULE$.apply((Object)asyncSocketChannel);
        }

        private Either<Throwable, AsynchronousSocketChannel> asyncSocketChannel() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                    try {
                        Either either;
                        Either either2;
                        Option<AsynchronousSocketChannel> option = this.existingAsyncSocketChannelO;
                        if (option instanceof Some) {
                            AsynchronousSocketChannel asc = (AsynchronousSocketChannel)((Some)option).value();
                            either2 = package$.MODULE$.Right().apply((Object)asc);
                        } else if (None$.MODULE$.equals(option)) {
                            either2 = this.liftedTree1$1();
                        } else {
                            throw new MatchError(option);
                        }
                        this.asyncSocketChannel$lzy1 = either = either2;
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                        return either;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
            }
            return this.asyncSocketChannel$lzy1;
        }

        @Override
        public void connect(InetSocketAddress remote, Callback<Throwable, BoxedUnit> cb) {
            this.asyncSocketChannel().fold((Function1)(JProcedure1 & Serializable)_$1 -> {}, (Function1)(JProcedure1 & Serializable)c -> this.liftedTree2$1(remote, (Callback)cb, (AsynchronousSocketChannel)c));
        }

        @Override
        public Option<InetSocketAddress> localAddress() {
            return (Option)this.asyncSocketChannel().fold((Function1 & Serializable)_$2 -> None$.MODULE$, (Function1 & Serializable)c -> this.liftedTree3$2((AsynchronousSocketChannel)c));
        }

        @Override
        public Option<InetSocketAddress> remoteAddress() {
            return (Option)this.asyncSocketChannel().fold((Function1 & Serializable)_$4 -> None$.MODULE$, (Function1 & Serializable)c -> this.liftedTree4$2((AsynchronousSocketChannel)c));
        }

        @Override
        public void read(ByteBuffer dst, Callback<Throwable, Object> cb, Option<Duration> timeout) {
            this.asyncSocketChannel().fold((Function1)(JProcedure1 & Serializable)_$6 -> {}, (Function1)(JProcedure1 & Serializable)c -> this.liftedTree5$5(dst, (Callback)cb, (Option)timeout, (AsynchronousSocketChannel)c));
        }

        @Override
        public void write(ByteBuffer src, Callback<Throwable, Object> cb, Option<Duration> timeout) {
            this.asyncSocketChannel().fold((Function1)(JProcedure1 & Serializable)_$9 -> {}, (Function1)(JProcedure1 & Serializable)c -> this.liftedTree6$5(src, (Callback)cb, (Option)timeout, (AsynchronousSocketChannel)c));
        }

        @Override
        public void stopReading() {
            this.asyncSocketChannel().fold((Function1 & Serializable)_$12 -> BoxedUnit.UNIT, (Function1 & Serializable)c -> this.liftedTree7$1((AsynchronousSocketChannel)c));
        }

        @Override
        public void stopWriting() {
            this.asyncSocketChannel().fold((Function1 & Serializable)_$13 -> BoxedUnit.UNIT, (Function1 & Serializable)c -> this.liftedTree8$1((AsynchronousSocketChannel)c));
        }

        @Override
        public void close() {
            this.cancelable.cancel();
        }

        public NewIOImplementation copy(boolean reuseAddress, Option<Object> sendBufferSize, Option<Object> receiveBufferSize, boolean keepAlive, boolean noDelay, Scheduler scheduler) {
            return new NewIOImplementation(reuseAddress, sendBufferSize, receiveBufferSize, keepAlive, noDelay, scheduler);
        }

        public boolean copy$default$1() {
            return this.reuseAddress();
        }

        public Option<Object> copy$default$2() {
            return this.sendBufferSize();
        }

        public Option<Object> copy$default$3() {
            return this.receiveBufferSize();
        }

        public boolean copy$default$4() {
            return this.keepAlive();
        }

        public boolean copy$default$5() {
            return this.noDelay();
        }

        public boolean _1() {
            return this.reuseAddress();
        }

        public Option<Object> _2() {
            return this.sendBufferSize();
        }

        public Option<Object> _3() {
            return this.receiveBufferSize();
        }

        public boolean _4() {
            return this.keepAlive();
        }

        public boolean _5() {
            return this.noDelay();
        }

        private final void liftedTree9$1(Scheduler scheduler$1, AsynchronousSocketChannel c$1) {
            try {
                c$1.close();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option.get();
                    scheduler$1.reportFailure(exc);
                }
                throw throwable;
            }
        }

        private final /* synthetic */ AsynchronousSocketChannel liftedTree1$2$$anonfun$1(AsynchronousSocketChannel ch$1, int sz) {
            return ch$1.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, Predef$.MODULE$.int2Integer(sz));
        }

        private final /* synthetic */ AsynchronousSocketChannel liftedTree1$4$$anonfun$2(AsynchronousSocketChannel ch$2, int sz) {
            return ch$2.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, Predef$.MODULE$.int2Integer(sz));
        }

        private final Either liftedTree1$1() {
            Left left;
            try {
                AsynchronousSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousSocketChannel(AsyncSocketChannel$.MODULE$.monix$nio$tcp$AsyncSocketChannel$$$acg());
                ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Predef$.MODULE$.boolean2Boolean(this.reuseAddress()));
                this.sendBufferSize().foreach((Function1 & Serializable)sz -> this.liftedTree1$2$$anonfun$1(ch, BoxesRunTime.unboxToInt((Object)sz)));
                this.receiveBufferSize().foreach((Function1 & Serializable)sz -> this.liftedTree1$4$$anonfun$2(ch, BoxesRunTime.unboxToInt((Object)sz)));
                ch.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, Predef$.MODULE$.boolean2Boolean(this.keepAlive()));
                ch.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, Predef$.MODULE$.boolean2Boolean(this.noDelay()));
                left = package$.MODULE$.Right().apply((Object)ch);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option.get();
                    this.scheduler.reportFailure(exc);
                    left = package$.MODULE$.Left().apply((Object)exc);
                }
                throw throwable;
            }
            return left;
        }

        private final void liftedTree2$1(InetSocketAddress remote$1, Callback cb$1, AsynchronousSocketChannel c$2) {
            try {
                c$2.connect(remote$1, cb$1, AsyncSocketChannel$.monix$nio$tcp$AsyncSocketChannel$$$connectHandler);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option.get();
                    cb$1.onError((Object)exc);
                }
                throw throwable;
            }
        }

        private final Option liftedTree3$2(AsynchronousSocketChannel c$3) {
            Option option;
            try {
                option = Option$.MODULE$.apply((Object)c$3.getLocalAddress()).map((Function1 & Serializable)_$3 -> (InetSocketAddress)_$3);
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option2.get();
                    this.scheduler.reportFailure(exc);
                    option = None$.MODULE$;
                }
                throw throwable;
            }
            return option;
        }

        private final Option liftedTree4$2(AsynchronousSocketChannel c$4) {
            Option option;
            try {
                option = Option$.MODULE$.apply((Object)c$4.getRemoteAddress()).map((Function1 & Serializable)_$5 -> (InetSocketAddress)_$5);
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option2.get();
                    this.scheduler.reportFailure(exc);
                    option = None$.MODULE$;
                }
                throw throwable;
            }
            return option;
        }

        private final long liftedTree5$2$$anonfun$2() {
            return 0L;
        }

        private final TimeUnit liftedTree5$4$$anonfun$4() {
            return TimeUnit.MILLISECONDS;
        }

        private final void liftedTree5$5(ByteBuffer dst$1, Callback cb$3, Option timeout$1, AsynchronousSocketChannel c$5) {
            try {
                c$5.read(dst$1, BoxesRunTime.unboxToLong((Object)timeout$1.map((Function1 & Serializable)_$7 -> _$7.length()).getOrElse(this::liftedTree5$2$$anonfun$2)), (TimeUnit)((Object)timeout$1.map((Function1 & Serializable)_$8 -> _$8.unit()).getOrElse(this::liftedTree5$4$$anonfun$4)), cb$3, AsyncSocketChannel$.monix$nio$tcp$AsyncSocketChannel$$$rwHandler);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option.get();
                    cb$3.onError((Object)exc);
                }
                throw throwable;
            }
        }

        private final long liftedTree6$2$$anonfun$2() {
            return 0L;
        }

        private final TimeUnit liftedTree6$4$$anonfun$4() {
            return TimeUnit.MILLISECONDS;
        }

        private final void liftedTree6$5(ByteBuffer src$1, Callback cb$5, Option timeout$3, AsynchronousSocketChannel c$6) {
            try {
                c$6.write(src$1, BoxesRunTime.unboxToLong((Object)timeout$3.map((Function1 & Serializable)_$10 -> _$10.length()).getOrElse(this::liftedTree6$2$$anonfun$2)), (TimeUnit)((Object)timeout$3.map((Function1 & Serializable)_$11 -> _$11.unit()).getOrElse(this::liftedTree6$4$$anonfun$4)), cb$5, AsyncSocketChannel$.monix$nio$tcp$AsyncSocketChannel$$$rwHandler);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option.get();
                    cb$5.onError((Object)exc);
                }
                throw throwable;
            }
        }

        private final Object liftedTree7$1(AsynchronousSocketChannel c$7) {
            AsynchronousSocketChannel asynchronousSocketChannel;
            try {
                asynchronousSocketChannel = c$7.shutdownInput();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Option option;
                Throwable throwable3 = throwable;
                if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                    throw throwable;
                }
                Throwable exc = throwable2 = (Throwable)option.get();
                this.scheduler.reportFailure(exc);
                asynchronousSocketChannel = BoxedUnit.UNIT;
            }
            return asynchronousSocketChannel;
        }

        private final Object liftedTree8$1(AsynchronousSocketChannel c$8) {
            AsynchronousSocketChannel asynchronousSocketChannel;
            try {
                asynchronousSocketChannel = c$8.shutdownOutput();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Option option;
                Throwable throwable3 = throwable;
                if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                    throw throwable;
                }
                Throwable exc = throwable2 = (Throwable)option.get();
                this.scheduler.reportFailure(exc);
                asynchronousSocketChannel = BoxedUnit.UNIT;
            }
            return asynchronousSocketChannel;
        }
    }
}

