/*
 * Decompiled with CFR 0.152.
 */
package monix.nio.text;

import java.io.Serializable;
import java.nio.ByteBuffer;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.exceptions.APIContractViolationException$;
import monix.nio.text.UTF8Codec$;
import monix.reactive.Observer;
import monix.reactive.observers.Subscriber;
import monix.reactive.subjects.Subject;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class UTF8Codec {

    public static class UTF8DecodingSubject
    extends Subject<byte[], String> {
        private final AtomicAny<Option<Subscriber<String>>> subscriber;
        private final AtomicBoolean stopOnNext;
        private final ByteBuffer remaining;

        public UTF8DecodingSubject() {
            Option initialValue$proxy1 = Option$.MODULE$.empty();
            AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
            this.subscriber = (AtomicAny)builder$proxy1.buildInstance((Object)initialValue$proxy1, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
            this.stopOnNext = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
            this.remaining = ByteBuffer.allocate(4);
        }

        public ByteBuffer remaining() {
            return this.remaining;
        }

        public int size() {
            return ((Option)this.subscriber.get()).nonEmpty() ? 1 : 0;
        }

        public Cancelable unsafeSubscribeFn(Subscriber<String> subscriber) {
            Cancelable cancelable;
            if (!this.subscriber.compareAndSet((Object)None$.MODULE$, (Object)Some$.MODULE$.apply(subscriber))) {
                subscriber.onError((Throwable)APIContractViolationException$.MODULE$.apply(this.getClass().getName()));
                cancelable = Cancelable$.MODULE$.empty();
            } else {
                this.remaining().put(0, (byte)0);
                cancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.stopOnNext.set(true));
            }
            return cancelable;
        }

        public void onError(Throwable ex) {
            ((Option)this.subscriber.get()).foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.onError(ex));
        }

        public void onComplete() {
            ((Option)this.subscriber.get()).foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.onComplete());
        }

        public Future<Ack> onNext(byte[] elem) {
            Ack.Stop$ stop$;
            if (this.stopOnNext.get() || ((Option)this.subscriber.get()).isEmpty()) {
                stop$ = Ack.Stop$.MODULE$;
            } else {
                byte[] byArray;
                byte[] remainingArray = this.remaining().array();
                if (remainingArray[0] == 0) {
                    byArray = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE));
                } else {
                    Object object = Predef$.MODULE$.byteArrayOps(remainingArray);
                    byArray = (byte[])ArrayOps$.MODULE$.slice$extension(object, 1, 1 + remainingArray[0]);
                }
                byte[] oldRemaining = byArray;
                Tuple2<Option<String>, byte[]> tuple2 = this.getString(elem, oldRemaining);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Option current = (Option)tuple2._1();
                byte[] newRemaining = (byte[])tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)current, (Object)newRemaining);
                Option current2 = (Option)tuple22._1();
                byte[] newRemaining2 = (byte[])tuple22._2();
                this.remaining().clear();
                this.remaining().put((byte)newRemaining2.length);
                this.remaining().put(newRemaining2);
                Option option = current2;
                if (option instanceof Some) {
                    String str = (String)((Some)option).value();
                    stop$ = ((Observer)((Option)this.subscriber.get()).get()).onNext((Object)str);
                } else {
                    stop$ = Ack.Continue$.MODULE$;
                }
            }
            return stop$;
        }

        /*
         * Enabled aggressive block sorting
         */
        private Tuple2<Option<String>, byte[]> getString(byte[] elem, byte[] oldBytes) {
            Tuple2 tuple2;
            Object object = Predef$.MODULE$.byteArrayOps(oldBytes);
            byte[] bytes = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)elem, ClassTag$.MODULE$.apply(Byte.TYPE));
            Option<Object> splitAt = this.getSplitAt(bytes);
            Option<Object> option = splitAt;
            if (option instanceof Some) {
                int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                int split = n;
                if (split == 0) {
                    byte[] newRemaining = bytes;
                    tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)newRemaining);
                    return tuple2;
                }
                int split2 = n;
                if (split2 > 0) {
                    Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
                    String str = new String((byte[])ArrayOps$.MODULE$.take$extension(object2, split2), UTF8Codec$.monix$nio$text$UTF8Codec$$$utf8Charset);
                    Object object3 = Predef$.MODULE$.byteArrayOps(bytes);
                    byte[] newRemaining = (byte[])ArrayOps$.MODULE$.drop$extension(object3, split2);
                    tuple2 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)str), (Object)newRemaining);
                    return tuple2;
                }
            }
            String str = new String(bytes, UTF8Codec$.monix$nio$text$UTF8Codec$$$utf8Charset);
            tuple2 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)str), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE)));
            return tuple2;
        }

        private int indexIncrement(byte b) {
            return (b & 0x80) == 0 ? 0 : ((b & 0xE0) == 192 ? 2 : ((b & 0xF0) == 224 ? 3 : ((b & 0xF8) == 240 ? 4 : 0)));
        }

        private Option<Object> getSplitAt(byte[] bytes) {
            Object object = Predef$.MODULE$.byteArrayOps(bytes);
            byte[] lastThree = (byte[])ArrayOps$.MODULE$.drop$extension(object, RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), bytes.length - 3));
            Object object2 = Predef$.MODULE$.byteArrayOps(lastThree);
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object2));
            Option addBytesFromLast3 = (Option)ArrayOps$.MODULE$.foldLeft$extension(object3, (Object)Option$.MODULE$.empty(), (Function2 & Serializable)(acc, elem) -> {
                int increment = this.indexIncrement(BoxesRunTime.unboxToByte((Object)elem._1()));
                int index = BoxesRunTime.unboxToInt((Object)elem._2());
                return index + increment > lastThree.length ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)index)) : acc;
            });
            return addBytesFromLast3.map((Function1)(JFunction1.mcII.sp & Serializable)_$3 -> bytes.length + _$3 - lastThree.length);
        }
    }

    public static class UTF8EncodingSubject
    extends Subject<String, byte[]> {
        private final AtomicAny<Option<Subscriber<byte[]>>> subscriber;
        private final AtomicBoolean stopOnNext;

        public UTF8EncodingSubject() {
            Option initialValue$proxy2 = Option$.MODULE$.empty();
            AtomicBuilder builder$proxy2 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
            this.subscriber = (AtomicAny)builder$proxy2.buildInstance((Object)initialValue$proxy2, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
            this.stopOnNext = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
        }

        public int size() {
            return ((Option)this.subscriber.get()).nonEmpty() ? 1 : 0;
        }

        public Cancelable unsafeSubscribeFn(Subscriber<byte[]> subscriber) {
            Cancelable cancelable;
            if (!this.subscriber.compareAndSet((Object)None$.MODULE$, (Object)Some$.MODULE$.apply(subscriber))) {
                subscriber.onError((Throwable)APIContractViolationException$.MODULE$.apply(this.getClass().getName()));
                cancelable = Cancelable$.MODULE$.empty();
            } else {
                cancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.stopOnNext.set(true));
            }
            return cancelable;
        }

        public void onError(Throwable ex) {
            ((Option)this.subscriber.get()).foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.onError(ex));
        }

        public void onComplete() {
            ((Option)this.subscriber.get()).foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.onComplete());
        }

        public Future<Ack> onNext(String elem) {
            return this.stopOnNext.get() || ((Option)this.subscriber.get()).isEmpty() ? Ack.Stop$.MODULE$ : ((Observer)((Option)this.subscriber.get()).get()).onNext((Object)elem.getBytes(UTF8Codec$.monix$nio$text$UTF8Codec$$$utf8Charset));
        }
    }
}

