/*
 * Decompiled with CFR 0.152.
 */
package monix.nio.udp;

import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.nio.udp.AsyncDatagramChannel$;
import monix.nio.udp.AsyncDatagramChannel$NewIOImplementation$;
import monix.nio.udp.Packet;
import monix.nio.udp.Packet$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

public abstract class AsyncDatagramChannel
implements AutoCloseable {
    public static AsyncDatagramChannel apply(boolean bl, Option<Object> option, Option<Object> option2, boolean bl2, Option<ProtocolFamily> option3, Option<NetworkInterface> option4, Option<Object> option5, boolean bl3, Scheduler scheduler) {
        return AsyncDatagramChannel$.MODULE$.apply(bl, option, option2, bl2, option3, option4, option5, bl3, scheduler);
    }

    public static boolean apply$default$1() {
        return AsyncDatagramChannel$.MODULE$.apply$default$1();
    }

    public static Option<Object> apply$default$2() {
        return AsyncDatagramChannel$.MODULE$.apply$default$2();
    }

    public static Option<Object> apply$default$3() {
        return AsyncDatagramChannel$.MODULE$.apply$default$3();
    }

    public static boolean apply$default$4() {
        return AsyncDatagramChannel$.MODULE$.apply$default$4();
    }

    public static Option<ProtocolFamily> apply$default$5() {
        return AsyncDatagramChannel$.MODULE$.apply$default$5();
    }

    public static Option<NetworkInterface> apply$default$6() {
        return AsyncDatagramChannel$.MODULE$.apply$default$6();
    }

    public static Option<Object> apply$default$7() {
        return AsyncDatagramChannel$.MODULE$.apply$default$7();
    }

    public static boolean apply$default$8() {
        return AsyncDatagramChannel$.MODULE$.apply$default$8();
    }

    public abstract void bind(InetSocketAddress var1);

    public abstract Option<InetSocketAddress> localAddress();

    public abstract Option<Packet> receive(int var1, FiniteDuration var2);

    public abstract int send(Packet var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class NewIOImplementation
    extends AsyncDatagramChannel
    implements Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(NewIOImplementation.class, "0bitmap$1");
        public long 0bitmap$1;
        private final boolean reuseAddress;
        private final Option sendBufferSize;
        private final Option receiveBufferSize;
        private final boolean allowBroadcast;
        private final Option protocolFamily;
        private final Option multicastInterface;
        private final Option multicastTTL;
        private final boolean multicastLoopback;
        private final Scheduler scheduler;
        private Either asyncDatagramChannel$lzy1;
        private final Cancelable cancelable;

        public static NewIOImplementation apply(boolean bl, Option<Object> option, Option<Object> option2, boolean bl2, Option<ProtocolFamily> option3, Option<NetworkInterface> option4, Option<Object> option5, boolean bl3, Scheduler scheduler) {
            return AsyncDatagramChannel$NewIOImplementation$.MODULE$.apply(bl, option, option2, bl2, option3, option4, option5, bl3, scheduler);
        }

        public static NewIOImplementation unapply(NewIOImplementation newIOImplementation) {
            return AsyncDatagramChannel$NewIOImplementation$.MODULE$.unapply(newIOImplementation);
        }

        public static boolean $lessinit$greater$default$1() {
            return AsyncDatagramChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$1();
        }

        public static Option<Object> $lessinit$greater$default$2() {
            return AsyncDatagramChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Object> $lessinit$greater$default$3() {
            return AsyncDatagramChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$3();
        }

        public static boolean $lessinit$greater$default$4() {
            return AsyncDatagramChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$4();
        }

        public static Option<ProtocolFamily> $lessinit$greater$default$5() {
            return AsyncDatagramChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$5();
        }

        public static Option<NetworkInterface> $lessinit$greater$default$6() {
            return AsyncDatagramChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$6();
        }

        public static Option<Object> $lessinit$greater$default$7() {
            return AsyncDatagramChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$7();
        }

        public static boolean $lessinit$greater$default$8() {
            return AsyncDatagramChannel$NewIOImplementation$.MODULE$.$lessinit$greater$default$8();
        }

        public NewIOImplementation(boolean reuseAddress, Option<Object> sendBufferSize, Option<Object> receiveBufferSize, boolean allowBroadcast, Option<ProtocolFamily> protocolFamily, Option<NetworkInterface> multicastInterface, Option<Object> multicastTTL, boolean multicastLoopback, Scheduler scheduler) {
            this.reuseAddress = reuseAddress;
            this.sendBufferSize = sendBufferSize;
            this.receiveBufferSize = receiveBufferSize;
            this.allowBroadcast = allowBroadcast;
            this.protocolFamily = protocolFamily;
            this.multicastInterface = multicastInterface;
            this.multicastTTL = multicastTTL;
            this.multicastLoopback = multicastLoopback;
            this.scheduler = scheduler;
            this.cancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.asyncDatagramChannel().fold((Function1)(JProcedure1 & Serializable)_$6 -> {}, (Function1)(JProcedure1 & Serializable)c -> this.liftedTree6$1(scheduler, (DatagramChannel)c)));
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.reuseAddress() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.sendBufferSize()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.receiveBufferSize()));
            n = Statics.mix((int)n, (int)(this.allowBroadcast() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.protocolFamily()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.multicastInterface()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.multicastTTL()));
            n = Statics.mix((int)n, (int)(this.multicastLoopback() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NewIOImplementation)) return false;
            NewIOImplementation newIOImplementation = (NewIOImplementation)object;
            if (this.reuseAddress() != newIOImplementation.reuseAddress()) return false;
            if (this.allowBroadcast() != newIOImplementation.allowBroadcast()) return false;
            if (this.multicastLoopback() != newIOImplementation.multicastLoopback()) return false;
            Option<Object> option = this.sendBufferSize();
            Option<Object> option2 = newIOImplementation.sendBufferSize();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.receiveBufferSize();
            Option<Object> option4 = newIOImplementation.receiveBufferSize();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<ProtocolFamily> option5 = this.protocolFamily();
            Option<ProtocolFamily> option6 = newIOImplementation.protocolFamily();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<NetworkInterface> option7 = this.multicastInterface();
            Option<NetworkInterface> option8 = newIOImplementation.multicastInterface();
            if (option7 == null) {
                if (option8 != null) {
                    return false;
                }
            } else if (!option7.equals(option8)) return false;
            Option<Object> option9 = this.multicastTTL();
            Option<Object> option10 = newIOImplementation.multicastTTL();
            if (option9 == null) {
                if (option10 == null) return true;
                return false;
            } else {
                if (!option9.equals(option10)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NewIOImplementation;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "NewIOImplementation";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._4());
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                case 5: {
                    object = this._6();
                    break;
                }
                case 6: {
                    object = this._7();
                    break;
                }
                case 7: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._8());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "reuseAddress";
                    break;
                }
                case 1: {
                    string = "sendBufferSize";
                    break;
                }
                case 2: {
                    string = "receiveBufferSize";
                    break;
                }
                case 3: {
                    string = "allowBroadcast";
                    break;
                }
                case 4: {
                    string = "protocolFamily";
                    break;
                }
                case 5: {
                    string = "multicastInterface";
                    break;
                }
                case 6: {
                    string = "multicastTTL";
                    break;
                }
                case 7: {
                    string = "multicastLoopback";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public boolean reuseAddress() {
            return this.reuseAddress;
        }

        public Option<Object> sendBufferSize() {
            return this.sendBufferSize;
        }

        public Option<Object> receiveBufferSize() {
            return this.receiveBufferSize;
        }

        public boolean allowBroadcast() {
            return this.allowBroadcast;
        }

        public Option<ProtocolFamily> protocolFamily() {
            return this.protocolFamily;
        }

        public Option<NetworkInterface> multicastInterface() {
            return this.multicastInterface;
        }

        public Option<Object> multicastTTL() {
            return this.multicastTTL;
        }

        public boolean multicastLoopback() {
            return this.multicastLoopback;
        }

        private Either<Throwable, DatagramChannel> asyncDatagramChannel() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                    try {
                        Either either;
                        this.asyncDatagramChannel$lzy1 = either = this.liftedTree1$1();
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                        return either;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
            }
            return this.asyncDatagramChannel$lzy1;
        }

        @Override
        public void bind(InetSocketAddress local) {
            this.asyncDatagramChannel().fold((Function1 & Serializable)_$1 -> BoxedUnit.UNIT, (Function1 & Serializable)c -> this.liftedTree2$1(local, (DatagramChannel)c));
        }

        @Override
        public Option<InetSocketAddress> localAddress() {
            return (Option)this.asyncDatagramChannel().fold((Function1 & Serializable)_$2 -> None$.MODULE$, (Function1 & Serializable)c -> this.liftedTree3$2((DatagramChannel)c));
        }

        @Override
        public Option<Packet> receive(int maxSize, FiniteDuration timeout) {
            return (Option)this.asyncDatagramChannel().fold((Function1 & Serializable)_$4 -> None$.MODULE$, (Function1 & Serializable)c -> this.liftedTree4$2(maxSize, timeout, (DatagramChannel)c));
        }

        @Override
        public int send(Packet packet) {
            return BoxesRunTime.unboxToInt((Object)this.asyncDatagramChannel().fold((Function1 & Serializable)_$5 -> 0, (Function1 & Serializable)c -> this.liftedTree5$1(packet, (DatagramChannel)c)));
        }

        @Override
        public void close() {
            this.cancelable.cancel();
        }

        public NewIOImplementation copy(boolean reuseAddress, Option<Object> sendBufferSize, Option<Object> receiveBufferSize, boolean allowBroadcast, Option<ProtocolFamily> protocolFamily, Option<NetworkInterface> multicastInterface, Option<Object> multicastTTL, boolean multicastLoopback, Scheduler scheduler) {
            return new NewIOImplementation(reuseAddress, sendBufferSize, receiveBufferSize, allowBroadcast, protocolFamily, multicastInterface, multicastTTL, multicastLoopback, scheduler);
        }

        public boolean copy$default$1() {
            return this.reuseAddress();
        }

        public Option<Object> copy$default$2() {
            return this.sendBufferSize();
        }

        public Option<Object> copy$default$3() {
            return this.receiveBufferSize();
        }

        public boolean copy$default$4() {
            return this.allowBroadcast();
        }

        public Option<ProtocolFamily> copy$default$5() {
            return this.protocolFamily();
        }

        public Option<NetworkInterface> copy$default$6() {
            return this.multicastInterface();
        }

        public Option<Object> copy$default$7() {
            return this.multicastTTL();
        }

        public boolean copy$default$8() {
            return this.multicastLoopback();
        }

        public boolean _1() {
            return this.reuseAddress();
        }

        public Option<Object> _2() {
            return this.sendBufferSize();
        }

        public Option<Object> _3() {
            return this.receiveBufferSize();
        }

        public boolean _4() {
            return this.allowBroadcast();
        }

        public Option<ProtocolFamily> _5() {
            return this.protocolFamily();
        }

        public Option<NetworkInterface> _6() {
            return this.multicastInterface();
        }

        public Option<Object> _7() {
            return this.multicastTTL();
        }

        public boolean _8() {
            return this.multicastLoopback();
        }

        private final void liftedTree6$1(Scheduler scheduler$1, DatagramChannel c$1) {
            try {
                c$1.close();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option.get();
                    scheduler$1.reportFailure(exc);
                }
                throw throwable;
            }
        }

        private final DatagramChannel $anonfun$2() {
            return DatagramChannel.open();
        }

        private final /* synthetic */ DatagramChannel liftedTree1$2$$anonfun$1(DatagramChannel ch$1, int sz) {
            return ch$1.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, Predef$.MODULE$.int2Integer(sz));
        }

        private final /* synthetic */ DatagramChannel liftedTree1$4$$anonfun$2(DatagramChannel ch$2, int sz) {
            return ch$2.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, Predef$.MODULE$.int2Integer(sz));
        }

        private final /* synthetic */ DatagramChannel liftedTree1$7$$anonfun$4(DatagramChannel ch$4, int ttl) {
            return ch$4.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, Predef$.MODULE$.int2Integer(ttl));
        }

        private final Either liftedTree1$1() {
            Left left;
            try {
                DatagramChannel ch = (DatagramChannel)this.protocolFamily().map((Function1 & Serializable)x$0 -> DatagramChannel.open(x$0)).getOrElse(this::$anonfun$2);
                ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Predef$.MODULE$.boolean2Boolean(this.reuseAddress()));
                this.sendBufferSize().foreach((Function1 & Serializable)sz -> this.liftedTree1$2$$anonfun$1(ch, BoxesRunTime.unboxToInt((Object)sz)));
                this.receiveBufferSize().foreach((Function1 & Serializable)sz -> this.liftedTree1$4$$anonfun$2(ch, BoxesRunTime.unboxToInt((Object)sz)));
                ch.setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, Predef$.MODULE$.boolean2Boolean(this.allowBroadcast()));
                this.multicastInterface().foreach((Function1 & Serializable)n_if -> ch.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, n_if));
                this.multicastTTL().foreach((Function1 & Serializable)ttl -> this.liftedTree1$7$$anonfun$4(ch, BoxesRunTime.unboxToInt((Object)ttl)));
                ch.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, Predef$.MODULE$.boolean2Boolean(this.multicastLoopback()));
                left = package$.MODULE$.Right().apply((Object)ch);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option.get();
                    this.scheduler.reportFailure(exc);
                    left = package$.MODULE$.Left().apply((Object)exc);
                }
                throw throwable;
            }
            return left;
        }

        private final Object liftedTree2$1(InetSocketAddress local$1, DatagramChannel c$2) {
            DatagramChannel datagramChannel;
            try {
                datagramChannel = c$2.bind(local$1);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Option option;
                Throwable throwable3 = throwable;
                if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                    throw throwable;
                }
                Throwable exc = throwable2 = (Throwable)option.get();
                this.scheduler.reportFailure(exc);
                datagramChannel = BoxedUnit.UNIT;
            }
            return datagramChannel;
        }

        private final Option liftedTree3$2(DatagramChannel c$3) {
            Option option;
            try {
                option = Option$.MODULE$.apply((Object)c$3.getLocalAddress()).map((Function1 & Serializable)_$3 -> (InetSocketAddress)_$3);
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option2.get();
                    this.scheduler.reportFailure(exc);
                    option = None$.MODULE$;
                }
                throw throwable;
            }
            return option;
        }

        private final Option liftedTree4$2(int maxSize$2, FiniteDuration timeout$2, DatagramChannel c$4) {
            None$ none$;
            try {
                DatagramPacket dp = new DatagramPacket(new byte[maxSize$2], maxSize$2);
                c$4.socket().setSoTimeout((int)timeout$2.toMillis());
                c$4.socket().receive(dp);
                none$ = Option$.MODULE$.apply((Object)dp.getSocketAddress()).map((Function1 & Serializable)o -> {
                    Object object = Predef$.MODULE$.byteArrayOps(dp.getData());
                    return Packet$.MODULE$.apply((byte[])ArrayOps$.MODULE$.take$extension(object, dp.getLength()), (InetSocketAddress)o);
                });
            }
            catch (SocketTimeoutException socketTimeoutException) {
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option.get();
                    this.scheduler.reportFailure(exc);
                    none$ = None$.MODULE$;
                }
                throw throwable;
            }
            return none$;
        }

        private final int liftedTree5$1(Packet packet$1, DatagramChannel c$5) {
            int n;
            try {
                n = c$5.send(ByteBuffer.wrap(packet$1.data()), packet$1.to());
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable exc = throwable3 = (Throwable)option.get();
                    this.scheduler.reportFailure(exc);
                    n = 0;
                }
                throw throwable;
            }
            return n;
        }
    }
}

