/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import monix.eval.Coeval;
import monix.eval.Task;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.reactive.MulticastStrategy;
import monix.reactive.Observable;
import monix.reactive.Observer;
import monix.reactive.OverflowStrategy;
import monix.reactive.OverflowStrategy$;
import monix.reactive.internal.builders.AsyncStateActionObservable;
import monix.reactive.internal.builders.CharsReaderObservable;
import monix.reactive.internal.builders.CombineLatest2Observable;
import monix.reactive.internal.builders.CombineLatest3Observable;
import monix.reactive.internal.builders.CombineLatest4Observable;
import monix.reactive.internal.builders.CombineLatest5Observable;
import monix.reactive.internal.builders.CombineLatest6Observable;
import monix.reactive.internal.builders.ConsObservable;
import monix.reactive.internal.builders.CreateObservable;
import monix.reactive.internal.builders.DeferObservable;
import monix.reactive.internal.builders.EmptyObservable$;
import monix.reactive.internal.builders.ErrorObservable;
import monix.reactive.internal.builders.EvalAlwaysObservable;
import monix.reactive.internal.builders.EvalOnceObservable;
import monix.reactive.internal.builders.FirstStartedObservable;
import monix.reactive.internal.builders.ForkObservable;
import monix.reactive.internal.builders.FutureAsObservable;
import monix.reactive.internal.builders.InputStreamObservable;
import monix.reactive.internal.builders.Interleave2Observable;
import monix.reactive.internal.builders.IntervalFixedDelayObservable;
import monix.reactive.internal.builders.IntervalFixedRateObservable;
import monix.reactive.internal.builders.IterableAsObservable;
import monix.reactive.internal.builders.IteratorAsObservable;
import monix.reactive.internal.builders.LinesReaderObservable;
import monix.reactive.internal.builders.NeverObservable$;
import monix.reactive.internal.builders.NowObservable;
import monix.reactive.internal.builders.RangeObservable;
import monix.reactive.internal.builders.ReactiveObservable;
import monix.reactive.internal.builders.RepeatEvalObservable;
import monix.reactive.internal.builders.RepeatObservable;
import monix.reactive.internal.builders.RepeatedValueObservable;
import monix.reactive.internal.builders.StateActionObservable;
import monix.reactive.internal.builders.TaskAsObservable;
import monix.reactive.internal.builders.UnsafeCreateObservable;
import monix.reactive.internal.builders.Zip2Observable;
import monix.reactive.internal.builders.Zip3Observable;
import monix.reactive.internal.builders.Zip4Observable;
import monix.reactive.internal.builders.Zip5Observable;
import monix.reactive.internal.builders.Zip6Observable;
import monix.reactive.observables.ObservableLike;
import monix.reactive.observers.Subscriber;
import monix.reactive.subjects.ConcurrentSubject;
import monix.reactive.subjects.ConcurrentSubject$;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Observable$
implements Serializable {
    public static final Observable$ MODULE$;
    private final Observable.TypeClassInstances typeClassInstances;

    static {
        new Observable$();
    }

    public <A> Observable<A> apply(Seq<A> elems) {
        return this.fromIterable((Iterable<A>)elems);
    }

    public <A> Observable<A> empty() {
        return EmptyObservable$.MODULE$;
    }

    public <A> Observable<A> now(A elem) {
        return new NowObservable<A>(elem);
    }

    public <A> Observable<A> pure(A elem) {
        return new NowObservable<A>(elem);
    }

    public <A> Observable<A> eval(Function0<A> a) {
        return new EvalAlwaysObservable<A>(a);
    }

    public <A> Observable<A> delay(Function0<A> a) {
        return this.eval(a);
    }

    public <A> Observable<A> evalAlways(Function0<A> a) {
        return this.eval(a);
    }

    public <A> Observable<A> evalOnce(Function0<A> f) {
        return new EvalOnceObservable<A>(f);
    }

    public <A> Observable<A> coeval(Coeval<A> value) {
        Observable<Object> observable;
        Coeval<A> coeval2 = value;
        if (coeval2 instanceof Coeval.Now) {
            Coeval.Now now = (Coeval.Now)coeval2;
            Object v = now.value();
            observable = this.now(v);
        } else if (coeval2 instanceof Coeval.Error) {
            Coeval.Error error = (Coeval.Error)coeval2;
            Throwable ex = error.ex();
            observable = this.raiseError(ex);
        } else {
            observable = this.eval((Function0<A>)new Serializable(coeval2){
                public static final long serialVersionUID = 0L;
                private final Coeval x1$1;

                public final A apply() {
                    return (A)this.x1$1.value();
                }
                {
                    this.x1$1 = x1$1;
                }
            });
        }
        return observable;
    }

    public <A> Observable<A> evalDelayed(FiniteDuration delay, Function0<A> a) {
        return (Observable)this.eval(a).delaySubscription(delay);
    }

    public Observable<Nothing$> raiseError(Throwable ex) {
        return new ErrorObservable(ex);
    }

    public Observable<Nothing$> never() {
        return NeverObservable$.MODULE$;
    }

    public <A> Observable<A> fork(Observable<A> fa) {
        return new ForkObservable<A>(fa);
    }

    public <A> Observable<A> unsafeCreate(Function1<Subscriber<A>, Cancelable> f) {
        return new UnsafeCreateObservable<A>(f);
    }

    public <A> Observable<A> create(OverflowStrategy.Synchronous<A> overflowStrategy, Function1<Subscriber.Sync<A>, Cancelable> f) {
        return new CreateObservable<A>(overflowStrategy, f);
    }

    public <A> Tuple2<Observer.Sync<A>, Observable<A>> multicast(MulticastStrategy<A> multicast, Scheduler s) {
        ConcurrentSubject<A, A> ref = ConcurrentSubject$.MODULE$.apply(multicast, s);
        return new Tuple2(ref, ref);
    }

    public <A> Tuple2<Observer.Sync<A>, Observable<A>> multicast(MulticastStrategy<A> multicast, OverflowStrategy.Synchronous<A> overflow, Scheduler s) {
        ConcurrentSubject<A, A> ref = ConcurrentSubject$.MODULE$.apply(multicast, overflow, s);
        return new Tuple2(ref, ref);
    }

    public <A> Observable<A> fromIterator(Iterator<A> iterator) {
        return new IteratorAsObservable<A>(iterator, Cancelable$.MODULE$.empty());
    }

    public <A> Observable<A> fromIterator(Iterator<A> iterator, Function0<BoxedUnit> onFinish) {
        return new IteratorAsObservable<A>(iterator, Cancelable$.MODULE$.apply(onFinish));
    }

    public <A> Observable<A> fromIterable(Iterable<A> iterable) {
        return new IterableAsObservable<A>(iterable);
    }

    public Observable<byte[]> fromInputStream(InputStream in) {
        return this.fromInputStream(in, 4096);
    }

    public Observable<byte[]> fromInputStream(InputStream in, int chunkSize) {
        return new InputStreamObservable(in, chunkSize);
    }

    public Observable<char[]> fromCharsReader(Reader in) {
        return this.fromCharsReader(in, 4096);
    }

    public Observable<char[]> fromCharsReader(Reader in, int chunkSize) {
        return new CharsReaderObservable(in, chunkSize);
    }

    public Observable<String> fromLinesReader(BufferedReader in) {
        return new LinesReaderObservable(in);
    }

    public <A> Observable<A> fromReactivePublisher(Publisher<A> publisher) {
        return new ReactiveObservable<A>(publisher);
    }

    public <A> Observable<A> fromFuture(Function0<Future<A>> factory) {
        return new FutureAsObservable<A>(factory);
    }

    public <A> Observable<A> fromTask(Task<A> task) {
        return new TaskAsObservable<A>(task);
    }

    public <A> Observable<A> defer(Function0<Observable<A>> fa) {
        return new DeferObservable<A>(fa);
    }

    public <A> Observable<A> suspend(Function0<Observable<A>> fa) {
        return this.defer(fa);
    }

    public <A> Observable<A> cons(A head, Observable<A> tail) {
        return new ConsObservable<A>(head, tail);
    }

    public <A> Observable<A> interleave2(Observable<A> oa1, Observable<A> oa2) {
        return new Interleave2Observable<A>(oa1, oa2);
    }

    public Observable<Object> intervalWithFixedDelay(FiniteDuration delay) {
        return new IntervalFixedDelayObservable(Duration$.MODULE$.Zero(), delay);
    }

    public Observable<Object> intervalWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay) {
        return new IntervalFixedDelayObservable(initialDelay, delay);
    }

    public Observable<Object> interval(FiniteDuration delay) {
        return this.intervalWithFixedDelay(delay);
    }

    public Observable<Object> intervalAtFixedRate(FiniteDuration period) {
        return new IntervalFixedRateObservable(Duration$.MODULE$.Zero(), period);
    }

    public Observable<Object> intervalAtFixedRate(FiniteDuration initialDelay, FiniteDuration period) {
        return new IntervalFixedRateObservable(initialDelay, period);
    }

    public <A> Observable<A> repeat(Seq<A> elems) {
        return new RepeatObservable<A>(elems);
    }

    public <A> Observable<A> repeatEval(Function0<A> task) {
        return new RepeatEvalObservable<A>(task);
    }

    public Observable<Object> range(long from, long until, long step) {
        return new RangeObservable(from, until, step);
    }

    public long range$default$3() {
        return 1L;
    }

    public <S, A> Observable<A> fromStateAction(Function1<S, Tuple2<A, S>> f, Function0<S> initialState) {
        return new StateActionObservable<S, A>(initialState, f);
    }

    public <S, A> Observable<A> fromAsyncStateAction(Function1<S, Task<Tuple2<A, S>>> f, Function0<S> initialState) {
        return new AsyncStateActionObservable<S, A>(initialState, f);
    }

    public <A> Publisher<A> toReactive(Observable<A> source, Scheduler s) {
        return source.toReactivePublisher(s);
    }

    public <A> Observable<A> timerRepeated(FiniteDuration initialDelay, FiniteDuration period, A unit) {
        return new RepeatedValueObservable<A>(initialDelay, period, unit);
    }

    public <A> Observable<A> flatten(Seq<Observable<A>> sources) {
        return (Observable)this.fromIterable((Iterable<A>)sources).concat(Predef$.MODULE$.$conforms());
    }

    public <A> Observable<A> flattenDelayError(Seq<Observable<A>> sources) {
        return (Observable)this.fromIterable((Iterable<A>)sources).concatDelayError(Predef$.MODULE$.$conforms());
    }

    public <A> Observable<A> merge(Seq<Observable<A>> sources, OverflowStrategy<A> os) {
        return (Observable)this.fromIterable((Iterable<A>)sources).mergeMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Observable<A> apply(Observable<A> x) {
                return (Observable)Predef$.MODULE$.identity(x);
            }
        }, os);
    }

    public <A> OverflowStrategy<Nothing$> merge$default$2(Seq<Observable<A>> sources) {
        return OverflowStrategy$.MODULE$.Default();
    }

    public <A> Observable<A> mergeDelayError(Seq<Observable<A>> sources, OverflowStrategy<A> os) {
        return (Observable)this.fromIterable((Iterable<A>)sources).mergeMapDelayErrors(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Observable<A> apply(Observable<A> x) {
                return (Observable)Predef$.MODULE$.identity(x);
            }
        }, os);
    }

    public <A> OverflowStrategy<Nothing$> mergeDelayError$default$2(Seq<Observable<A>> sources) {
        return OverflowStrategy$.MODULE$.Default();
    }

    public <A> Observable<A> concat(Seq<Observable<A>> sources) {
        return (Observable)this.fromIterable((Iterable<A>)sources).concatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Observable<A> apply(Observable<A> x) {
                return (Observable)Predef$.MODULE$.identity(x);
            }
        });
    }

    public <A> Observable<A> concatDelayError(Seq<Observable<A>> sources) {
        return (Observable)this.fromIterable((Iterable<A>)sources).concatMapDelayError(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Observable<A> apply(Observable<A> x) {
                return (Observable)Predef$.MODULE$.identity(x);
            }
        });
    }

    public <A> Observable<A> switch(Seq<Observable<A>> sources) {
        return (Observable)this.fromIterable((Iterable<A>)sources).switch(Predef$.MODULE$.$conforms());
    }

    public <A1, A2> Observable<Tuple2<A1, A2>> zip2(Observable<A1> oa1, Observable<A2> oa2) {
        return new Zip2Observable(oa1, oa2, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<A1, A2> apply(A1 a1, A2 a2) {
                return new Tuple2(a1, a2);
            }
        });
    }

    public <A1, A2, R> Observable<R> zipMap2(Observable<A1> oa1, Observable<A2> oa2, Function2<A1, A2, R> f) {
        return new Zip2Observable<A1, A2, R>(oa1, oa2, f);
    }

    public <A1, A2, A3> Observable<Tuple3<A1, A2, A3>> zip3(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3) {
        return new Zip3Observable(oa1, oa2, oa3, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<A1, A2, A3> apply(A1 a1, A2 a2, A3 a3) {
                return new Tuple3(a1, a2, a3);
            }
        });
    }

    public <A1, A2, A3, R> Observable<R> zipMap3(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Function3<A1, A2, A3, R> f) {
        return new Zip3Observable<A1, A2, A3, R>(oa1, oa2, oa3, f);
    }

    public <A1, A2, A3, A4> Observable<Tuple4<A1, A2, A3, A4>> zip4(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4) {
        return new Zip4Observable(oa1, oa2, oa3, oa4, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<A1, A2, A3, A4> apply(A1 a1, A2 a2, A3 a3, A4 a4) {
                return new Tuple4(a1, a2, a3, a4);
            }
        });
    }

    public <A1, A2, A3, A4, R> Observable<R> zipMap4(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Function4<A1, A2, A3, A4, R> f) {
        return new Zip4Observable<A1, A2, A3, A4, R>(oa1, oa2, oa3, oa4, f);
    }

    public <A1, A2, A3, A4, A5> Observable<Tuple5<A1, A2, A3, A4, A5>> zip5(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5) {
        return new Zip5Observable(oa1, oa2, oa3, oa4, oa5, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple5<A1, A2, A3, A4, A5> apply(A1 a1, A2 a2, A3 a3, A4 a4, A5 a5) {
                return new Tuple5(a1, a2, a3, a4, a5);
            }
        });
    }

    public <A1, A2, A3, A4, A5, R> Observable<R> zipMap5(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5, Function5<A1, A2, A3, A4, A5, R> f) {
        return new Zip5Observable<A1, A2, A3, A4, A5, R>(oa1, oa2, oa3, oa4, oa5, f);
    }

    public <A1, A2, A3, A4, A5, A6> Observable<Tuple6<A1, A2, A3, A4, A5, A6>> zip6(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5, Observable<A6> oa6) {
        return new Zip6Observable(oa1, oa2, oa3, oa4, oa5, oa6, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple6<A1, A2, A3, A4, A5, A6> apply(A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6) {
                return new Tuple6(a1, a2, a3, a4, a5, a6);
            }
        });
    }

    public <A1, A2, A3, A4, A5, A6, R> Observable<R> zipMap6(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5, Observable<A6> oa6, Function6<A1, A2, A3, A4, A5, A6, R> f) {
        return new Zip6Observable<A1, A2, A3, A4, A5, A6, R>(oa1, oa2, oa3, oa4, oa5, oa6, f);
    }

    public <A> Observable<Seq<A>> zipList(Seq<Observable<A>> sources) {
        Observable observable;
        if (sources.isEmpty()) {
            observable = this.empty();
        } else {
            Observable seed = (Observable)((ObservableLike)sources.head()).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Vector<A> apply(A t) {
                    return (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
                }
            });
            observable = (Observable)((TraversableOnce)sources.tail()).foldLeft((Object)seed, (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Observable<Vector<A>> apply(Observable<Vector<A>> acc, Observable<A> obs) {
                    return (Observable)acc.zipMap(obs, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Vector<A> apply(Vector<A> seq, A elem) {
                            return (Vector)seq.$colon$plus(elem, Vector$.MODULE$.canBuildFrom());
                        }
                    });
                }
            });
        }
        return observable;
    }

    public <A1, A2, R> Observable<R> zipWith2(Observable<A1> fa1, Observable<A2> fa2, Function2<A1, A2, R> f) {
        return this.zipMap2(fa1, fa2, f);
    }

    public <A1, A2, A3, R> Observable<R> zipWith3(Observable<A1> fa1, Observable<A2> fa2, Observable<A3> fa3, Function3<A1, A2, A3, R> f) {
        return this.zipMap3(fa1, fa2, fa3, f);
    }

    public <A1, A2, A3, A4, R> Observable<R> zipWith4(Observable<A1> fa1, Observable<A2> fa2, Observable<A3> fa3, Observable<A4> fa4, Function4<A1, A2, A3, A4, R> f) {
        return this.zipMap4(fa1, fa2, fa3, fa4, f);
    }

    public <A1, A2, A3, A4, A5, R> Observable<R> zipWith5(Observable<A1> fa1, Observable<A2> fa2, Observable<A3> fa3, Observable<A4> fa4, Observable<A5> fa5, Function5<A1, A2, A3, A4, A5, R> f) {
        return this.zipMap5(fa1, fa2, fa3, fa4, fa5, f);
    }

    public <A1, A2, A3, A4, A5, A6, R> Observable<R> zipWith6(Observable<A1> fa1, Observable<A2> fa2, Observable<A3> fa3, Observable<A4> fa4, Observable<A5> fa5, Observable<A6> fa6, Function6<A1, A2, A3, A4, A5, A6, R> f) {
        return this.zipMap6(fa1, fa2, fa3, fa4, fa5, fa6, f);
    }

    public <A1, A2> Observable<Tuple2<A1, A2>> combineLatest2(Observable<A1> oa1, Observable<A2> oa2) {
        return new CombineLatest2Observable(oa1, oa2, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<A1, A2> apply(A1 a1, A2 a2) {
                return new Tuple2(a1, a2);
            }
        });
    }

    public <A1, A2, R> Observable<R> combineLatestMap2(Observable<A1> oa1, Observable<A2> oa2, Function2<A1, A2, R> f) {
        return new CombineLatest2Observable<A1, A2, R>(oa1, oa2, f);
    }

    public <A1, A2, A3> Observable<Tuple3<A1, A2, A3>> combineLatest3(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3) {
        return new CombineLatest3Observable(oa1, oa2, oa3, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<A1, A2, A3> apply(A1 a1, A2 a2, A3 a3) {
                return new Tuple3(a1, a2, a3);
            }
        });
    }

    public <A1, A2, A3, R> Observable<R> combineLatestMap3(Observable<A1> a1, Observable<A2> a2, Observable<A3> a3, Function3<A1, A2, A3, R> f) {
        return new CombineLatest3Observable<A1, A2, A3, R>(a1, a2, a3, f);
    }

    public <A1, A2, A3, A4> Observable<Tuple4<A1, A2, A3, A4>> combineLatest4(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4) {
        return new CombineLatest4Observable(oa1, oa2, oa3, oa4, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<A1, A2, A3, A4> apply(A1 a1, A2 a2, A3 a3, A4 a4) {
                return new Tuple4(a1, a2, a3, a4);
            }
        });
    }

    public <A1, A2, A3, A4, R> Observable<R> combineLatestMap4(Observable<A1> a1, Observable<A2> a2, Observable<A3> a3, Observable<A4> a4, Function4<A1, A2, A3, A4, R> f) {
        return new CombineLatest4Observable<A1, A2, A3, A4, R>(a1, a2, a3, a4, f);
    }

    public <A1, A2, A3, A4, A5> Observable<Tuple5<A1, A2, A3, A4, A5>> combineLatest5(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5) {
        return new CombineLatest5Observable(oa1, oa2, oa3, oa4, oa5, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple5<A1, A2, A3, A4, A5> apply(A1 a1, A2 a2, A3 a3, A4 a4, A5 a5) {
                return new Tuple5(a1, a2, a3, a4, a5);
            }
        });
    }

    public <A1, A2, A3, A4, A5, R> Observable<R> combineLatestMap5(Observable<A1> a1, Observable<A2> a2, Observable<A3> a3, Observable<A4> a4, Observable<A5> a5, Function5<A1, A2, A3, A4, A5, R> f) {
        return new CombineLatest5Observable<A1, A2, A3, A4, A5, R>(a1, a2, a3, a4, a5, f);
    }

    public <A1, A2, A3, A4, A5, A6> Observable<Tuple6<A1, A2, A3, A4, A5, A6>> combineLatest6(Observable<A1> oa1, Observable<A2> oa2, Observable<A3> oa3, Observable<A4> oa4, Observable<A5> oa5, Observable<A6> oa6) {
        return new CombineLatest6Observable(oa1, oa2, oa3, oa4, oa5, oa6, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple6<A1, A2, A3, A4, A5, A6> apply(A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6) {
                return new Tuple6(a1, a2, a3, a4, a5, a6);
            }
        });
    }

    public <A1, A2, A3, A4, A5, A6, R> Observable<R> combineLatestMap6(Observable<A1> a1, Observable<A2> a2, Observable<A3> a3, Observable<A4> a4, Observable<A5> a5, Observable<A6> a6, Function6<A1, A2, A3, A4, A5, A6, R> f) {
        return new CombineLatest6Observable<A1, A2, A3, A4, A5, A6, R>(a1, a2, a3, a4, a5, a6, f);
    }

    public <A> Observable<Seq<A>> combineLatestList(Seq<Observable<A>> sources) {
        Observable observable;
        if (sources.isEmpty()) {
            observable = this.empty();
        } else {
            Observable seed = (Observable)((ObservableLike)sources.head()).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Vector<A> apply(A t) {
                    return (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
                }
            });
            observable = (Observable)((TraversableOnce)sources.tail()).foldLeft((Object)seed, (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Observable<Vector<A>> apply(Observable<Vector<A>> acc, Observable<A> obs) {
                    return (Observable)acc.combineLatestMap(obs, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Vector<A> apply(Vector<A> seq, A elem) {
                            return (Vector)seq.$colon$plus(elem, Vector$.MODULE$.canBuildFrom());
                        }
                    });
                }
            });
        }
        return observable;
    }

    public <A1, A2, R> Observable<R> combineLatestWith2(Observable<A1> fa1, Observable<A2> fa2, Function2<A1, A2, R> f) {
        return this.combineLatestMap2(fa1, fa2, f);
    }

    public <A1, A2, A3, R> Observable<R> combineLatestWith3(Observable<A1> fa1, Observable<A2> fa2, Observable<A3> fa3, Function3<A1, A2, A3, R> f) {
        return this.combineLatestMap3(fa1, fa2, fa3, f);
    }

    public <A1, A2, A3, A4, R> Observable<R> combineLatestWith4(Observable<A1> fa1, Observable<A2> fa2, Observable<A3> fa3, Observable<A4> fa4, Function4<A1, A2, A3, A4, R> f) {
        return this.combineLatestMap4(fa1, fa2, fa3, fa4, f);
    }

    public <A1, A2, A3, A4, A5, R> Observable<R> combineLatestWith5(Observable<A1> fa1, Observable<A2> fa2, Observable<A3> fa3, Observable<A4> fa4, Observable<A5> fa5, Function5<A1, A2, A3, A4, A5, R> f) {
        return this.combineLatestMap5(fa1, fa2, fa3, fa4, fa5, f);
    }

    public <A1, A2, A3, A4, A5, A6, R> Observable<R> combineLatestWith6(Observable<A1> fa1, Observable<A2> fa2, Observable<A3> fa3, Observable<A4> fa4, Observable<A5> fa5, Observable<A6> fa6, Function6<A1, A2, A3, A4, A5, A6, R> f) {
        return this.combineLatestMap6(fa1, fa2, fa3, fa4, fa5, fa6, f);
    }

    public <A> Observable<A> firstStartedOf(Seq<Observable<A>> source) {
        return new FirstStartedObservable<A>(source);
    }

    public Observable.TypeClassInstances typeClassInstances() {
        return this.typeClassInstances;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Observable$() {
        MODULE$ = this;
        this.typeClassInstances = new Observable.TypeClassInstances();
    }
}

