/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive;

import cats.effect.Effect;
import monix.eval.Callback;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.reactive.Consumer;
import monix.reactive.Notification;
import monix.reactive.Observer;
import monix.reactive.internal.consumers.CancelledConsumer$;
import monix.reactive.internal.consumers.CompleteConsumer$;
import monix.reactive.internal.consumers.CreateConsumer;
import monix.reactive.internal.consumers.FirstNotificationConsumer;
import monix.reactive.internal.consumers.FoldLeftConsumer;
import monix.reactive.internal.consumers.FoldLeftTaskConsumer;
import monix.reactive.internal.consumers.ForeachAsyncConsumer;
import monix.reactive.internal.consumers.ForeachConsumer;
import monix.reactive.internal.consumers.FromObserverConsumer;
import monix.reactive.internal.consumers.HeadConsumer;
import monix.reactive.internal.consumers.HeadOptionConsumer;
import monix.reactive.internal.consumers.LoadBalanceConsumer;
import monix.reactive.internal.consumers.RaiseErrorConsumer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class Consumer$
implements Serializable {
    public static final Consumer$ MODULE$;

    static {
        new Consumer$();
    }

    public <In, Out> Consumer<In, Out> create(Function3<Scheduler, Cancelable, Callback<Out>, Observer<In>> f) {
        return new CreateConsumer<In, Out>(f);
    }

    public <In> Consumer<In, BoxedUnit> fromObserver(Function1<Scheduler, Observer<In>> f) {
        return new FromObserverConsumer<In>(f);
    }

    public <A> Consumer.Sync<A, BoxedUnit> cancel() {
        return CancelledConsumer$.MODULE$;
    }

    public <In, R> Consumer.Sync<In, R> raiseError(Throwable ex) {
        return new RaiseErrorConsumer(ex);
    }

    public <S, A> Consumer.Sync<A, S> foldLeft(Function0<S> initial, Function2<S, A, S> f) {
        return new FoldLeftConsumer<A, S>(initial, f);
    }

    public <F, S, A> Consumer<A, S> foldLeftEval(Function0<S> initial, Function2<S, A, F> f, Effect<F> F) {
        return new FoldLeftTaskConsumer(initial, new Serializable(f, F){
            public static final long serialVersionUID = 0L;
            private final Function2 f$1;
            private final Effect F$1;

            public final Task<S> apply(S s, A a) {
                return Task$.MODULE$.fromEffect(this.f$1.apply(s, a), this.F$1);
            }
            {
                this.f$1 = f$1;
                this.F$1 = F$1;
            }
        });
    }

    public <S, A> Consumer<A, S> foldLeftTask(Function0<S> initial, Function2<S, A, Task<S>> f) {
        return new FoldLeftTaskConsumer<A, S>(initial, f);
    }

    public <A> Consumer.Sync<A, A> head() {
        return new HeadConsumer();
    }

    public <A> Consumer.Sync<A, Option<A>> headOption() {
        return new HeadOptionConsumer();
    }

    public <A> Consumer.Sync<A, Notification<A>> firstNotification() {
        return new FirstNotificationConsumer();
    }

    public <A> Consumer.Sync<A, BoxedUnit> complete() {
        return CompleteConsumer$.MODULE$;
    }

    public <A> Consumer.Sync<A, BoxedUnit> foreach(Function1<A, BoxedUnit> cb) {
        return new ForeachConsumer<A>(cb);
    }

    public <F, A> Consumer<A, BoxedUnit> foreachEval(Function1<A, F> cb, Effect<F> F) {
        return this.foreachTask((Function1<A, Task<BoxedUnit>>)new Serializable(cb, F){
            public static final long serialVersionUID = 0L;
            private final Function1 cb$1;
            private final Effect F$2;

            public final Task<BoxedUnit> apply(A a) {
                return Task$.MODULE$.fromEffect(this.cb$1.apply(a), this.F$2);
            }
            {
                this.cb$1 = cb$1;
                this.F$2 = F$2;
            }
        });
    }

    public <A> Consumer<A, BoxedUnit> foreachTask(Function1<A, Task<BoxedUnit>> cb) {
        return new ForeachAsyncConsumer<A>(cb);
    }

    public <A> Consumer<A, BoxedUnit> foreachParallel(int parallelism, Function1<A, BoxedUnit> cb) {
        return this.loadBalance(parallelism, this.foreach(cb)).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(List<BoxedUnit> x$2) {
            }
        });
    }

    public <A> Consumer<A, BoxedUnit> foreachParallelTask(int parallelism, Function1<A, Task<BoxedUnit>> cb) {
        return this.loadBalance(parallelism, this.foreachTask(cb)).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(List<BoxedUnit> x$3) {
            }
        });
    }

    public <A, R> Consumer<A, List<R>> loadBalance(int parallelism, Consumer<A, R> consumer) {
        return new LoadBalanceConsumer(parallelism, (Consumer[])((Object[])new Consumer[]{consumer}));
    }

    public <A, R> Consumer<A, List<R>> loadBalance(Seq<Consumer<A, R>> consumers) {
        return new LoadBalanceConsumer(consumers.length(), (Consumer[])consumers.toArray(ClassTag$.MODULE$.apply(Consumer.class)));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Consumer$() {
        MODULE$ = this;
    }
}

