/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.rstreams;

import monix.execution.Ack;
import monix.execution.Scheduler;
import monix.reactive.observers.Subscriber;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y4Q!\u0001\u0002\u0003\r)\u0011!eU=oGN+(m]2sS\n,'/Q:SK\u0006\u001cG/\u001b<f'V\u00147o\u0019:jE\u0016\u0014(BA\u0002\u0005\u0003!\u00118\u000f\u001e:fC6\u001c(BA\u0003\u0007\u0003!Ig\u000e^3s]\u0006d'BA\u0004\t\u0003!\u0011X-Y2uSZ,'\"A\u0005\u0002\u000b5|g.\u001b=\u0016\u0005-q2c\u0001\u0001\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000fE\u0002\u00165qi\u0011A\u0006\u0006\u0003/a\tqB]3bGRLg/Z:ue\u0016\fWn\u001d\u0006\u00023\u0005\u0019qN]4\n\u0005m1\"AC*vEN\u001c'/\u001b2feB\u0011QD\b\u0007\u0001\t\u0015y\u0002A1\u0001\"\u0005\u0005\t5\u0001A\t\u0003E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012qAT8uQ&tw\r\u0005\u0002$S%\u0011!\u0006\n\u0002\u0004\u0003:L\b\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\rQ\f'oZ3u!\rqC\u0007\b\b\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0019\t\u0011b\u001c2tKJ4XM]:\n\u0005M\u0002\u0014AC*vEN\u001c'/\u001b2fe&\u0011QG\u000e\u0002\u0005'ft7M\u0003\u00024a!A\u0001\b\u0001B\u0001B\u0003%\u0011(\u0001\u0007sKF,Xm\u001d;D_VtG\u000f\u0005\u0002$u%\u00111\b\n\u0002\u0004\u0013:$\b\"B\u001f\u0001\t\u0003q\u0014A\u0002\u001fj]&$h\bF\u0002@\u0003\n\u00032\u0001\u0011\u0001\u001d\u001b\u0005\u0011\u0001\"\u0002\u0017=\u0001\u0004i\u0003\"\u0002\u001d=\u0001\u0004I\u0004B\u0002#\u0001A\u0003-Q)A\u0001t!\t1\u0015*D\u0001H\u0015\tA\u0005\"A\u0005fq\u0016\u001cW\u000f^5p]&\u0011!j\u0012\u0002\n'\u000eDW\rZ;mKJDa\u0001\u0014\u0001!B\u0013i\u0015\u0001D:vEN\u001c'/\u001b9uS>t\u0007CA\u000bO\u0013\tyeC\u0001\u0007Tk\n\u001c8M]5qi&|g\u000e\u0003\u0004R\u0001\u0001\u0006KAU\u0001\u000fKb\u0004Xm\u0019;j]\u001e\u001cu.\u001e8u!\t\u00193+\u0003\u0002UI\t!Aj\u001c8h\u0011\u00191\u0006\u0001)Q\u0005/\u0006Q\u0011n]\"b]\u000e,G.\u001a3\u0011\u0005\rB\u0016BA-%\u0005\u001d\u0011un\u001c7fC:D#!V.\u0011\u0005\rb\u0016BA/%\u0005!1x\u000e\\1uS2,\u0007\"B0\u0001\t\u0003\u0001\u0017aC8o'V\u00147o\u0019:jE\u0016$\"!\u00193\u0011\u0005\r\u0012\u0017BA2%\u0005\u0011)f.\u001b;\t\u000b\u0011s\u0006\u0019A'\t\u000b\u0019\u0004A\u0011A4\u0002\r=tg*\u001a=u)\t\t\u0007\u000eC\u0003jK\u0002\u0007A$\u0001\u0003fY\u0016l\u0007\"B6\u0001\t\u0003a\u0017aB8o\u000bJ\u0014xN\u001d\u000b\u0003C6DQA\u001c6A\u0002=\f!!\u001a=\u0011\u0005ADhBA9w\u001d\t\u0011X/D\u0001t\u0015\t!\b%\u0001\u0004=e>|GOP\u0005\u0002K%\u0011q\u000fJ\u0001\ba\u0006\u001c7.Y4f\u0013\tI(PA\u0005UQJ|w/\u00192mK*\u0011q\u000f\n\u0005\u0006y\u0002!\t!`\u0001\u000b_:\u001cu.\u001c9mKR,G#A1")
public final class SyncSubscriberAsReactiveSubscriber<A>
implements Subscriber<A> {
    private final Subscriber.Sync<A> target;
    private final int requestCount;
    private final Scheduler s;
    private Subscription subscription;
    private long expectingCount;
    private volatile boolean isCanceled;

    public void onSubscribe(Subscription s) {
        if (this.subscription == null && !this.isCanceled) {
            this.subscription = s;
            this.expectingCount = this.requestCount;
            s.request((long)this.requestCount);
        } else {
            s.cancel();
        }
    }

    public void onNext(A elem) {
        if (this.subscription == null) {
            throw new NullPointerException("onSubscription never happened, see rule 2.13 in the Reactive Streams spec");
        }
        if (elem == null) {
            throw new NullPointerException("onNext(null) is forbidden, see rule 2.13 in the Reactive Streams spec");
        }
        if (!this.isCanceled) {
            Ack ack;
            if (this.expectingCount > 0L) {
                --this.expectingCount;
            }
            if (Ack.Continue$.MODULE$.equals(ack = this.target.onNext(elem))) {
                BoxedUnit boxedUnit;
                if (this.expectingCount == 0L) {
                    this.expectingCount = this.requestCount;
                    this.subscription.request((long)this.requestCount);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (Ack.Stop$.MODULE$.equals(ack)) {
                this.isCanceled = true;
                this.subscription.cancel();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)ack);
            }
        }
    }

    public void onError(Throwable ex) {
        block1: {
            if (ex == null) {
                throw new NullPointerException("onError(null) is forbidden, see rule 2.13 in the Reactive Streams spec");
            }
            if (this.isCanceled) break block1;
            this.isCanceled = true;
            this.target.onError(ex);
        }
    }

    public void onComplete() {
        block0: {
            if (this.isCanceled) break block0;
            this.isCanceled = true;
            this.target.onComplete();
        }
    }

    public SyncSubscriberAsReactiveSubscriber(Subscriber.Sync<A> target, int requestCount) {
        this.target = target;
        this.requestCount = requestCount;
        Predef$.MODULE$.require(requestCount > 0, (Function0 & java.io.Serializable & Serializable)() -> "requestCount must be strictly positive, according to the Reactive Streams contract");
        this.s = target.scheduler();
        this.subscription = null;
        this.expectingCount = 0L;
        this.isCanceled = false;
    }
}

