/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.rstreams;

import monix.execution.Ack;
import monix.execution.Ack$Continue$;
import monix.execution.Scheduler;
import monix.reactive.observers.Subscriber;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y4Q\u0001D\u0007\u0003#UA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")Q\t\u0001C\u0001\r\"11\n\u0001Q\u0001\f1CaA\u0015\u0001!B\u0013\u0019\u0006B\u0002,\u0001A\u0003&q\u000b\u0003\u0004[\u0001\u0001\u0006Ka\u0017\u0005\u0006E\u0002!\ta\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006y\u0002!\t! \u0002#'ft7mU;cg\u000e\u0014\u0018NY3s\u0003N\u0014V-Y2uSZ,7+\u001e2tGJL'-\u001a:\u000b\u00059y\u0011\u0001\u0003:tiJ,\u0017-\\:\u000b\u0005A\t\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005I\u0019\u0012\u0001\u0003:fC\u000e$\u0018N^3\u000b\u0003Q\tQ!\\8oSb,\"AF\u0015\u0014\u0007\u00019r\u0004\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005!A.\u00198h\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\r=\u0013'.Z2u!\r\u0001SeJ\u0007\u0002C)\u0011!eI\u0001\u0010e\u0016\f7\r^5wKN$(/Z1ng*\tA%A\u0002pe\u001eL!AJ\u0011\u0003\u0015M+(m]2sS\n,'\u000f\u0005\u0002)S1\u0001A!\u0002\u0016\u0001\u0005\u0004a#!A!\u0004\u0001E\u0011Qf\r\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\b\u001d>$\b.\u001b8h!\tqC'\u0003\u00026_\t\u0019\u0011I\\=\u0002\rQ\f'oZ3u!\rAdh\n\b\u0003sqj\u0011A\u000f\u0006\u0003wE\t\u0011b\u001c2tKJ4XM]:\n\u0005uR\u0014AC*vEN\u001c'/\u001b2fe&\u0011q\b\u0011\u0002\u0005'ft7M\u0003\u0002>u\u0005a!/Z9vKN$8i\\;oiB\u0011afQ\u0005\u0003\t>\u00121!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0019q)\u0013&\u0011\u0007!\u0003q%D\u0001\u000e\u0011\u001514\u00011\u00018\u0011\u0015\t5\u00011\u0001C\u0003\u0005\u0019\bCA'Q\u001b\u0005q%BA(\u0014\u0003%)\u00070Z2vi&|g.\u0003\u0002R\u001d\nI1k\u00195fIVdWM]\u0001\rgV\u00147o\u0019:jaRLwN\u001c\t\u0003AQK!!V\u0011\u0003\u0019M+(m]2sSB$\u0018n\u001c8\u0002\u001d\u0015D\b/Z2uS:<7i\\;oiB\u0011a\u0006W\u0005\u00033>\u0012A\u0001T8oO\u0006Q\u0011n]\"b]\u000e,G.\u001a3\u0011\u00059b\u0016BA/0\u0005\u001d\u0011un\u001c7fC:D#aB0\u0011\u00059\u0002\u0017BA10\u0005!1x\u000e\\1uS2,\u0017aC8o'V\u00147o\u0019:jE\u0016$\"\u0001Z4\u0011\u00059*\u0017B\u000140\u0005\u0011)f.\u001b;\t\u000b-C\u0001\u0019A*\u0002\r=tg*\u001a=u)\t!'\u000eC\u0003l\u0013\u0001\u0007q%\u0001\u0003fY\u0016l\u0017aB8o\u000bJ\u0014xN\u001d\u000b\u0003I:DQa\u001c\u0006A\u0002A\f!!\u001a=\u0011\u0005ELhB\u0001:x\u001d\t\u0019h/D\u0001u\u0015\t)8&\u0001\u0004=e>|GOP\u0005\u0002a%\u0011\u0001pL\u0001\ba\u0006\u001c7.Y4f\u0013\tQ8PA\u0005UQJ|w/\u00192mK*\u0011\u0001pL\u0001\u000b_:\u001cu.\u001c9mKR,G#\u00013")
public final class SyncSubscriberAsReactiveSubscriber<A>
implements Subscriber<A> {
    private final Subscriber.Sync<A> target;
    private final int requestCount;
    private final Scheduler s;
    private Subscription subscription;
    private long expectingCount;
    private volatile boolean isCanceled;
    private volatile byte bitmap$init$0;

    public void onSubscribe(Subscription s) {
        if (this.subscription == null && !this.isCanceled) {
            this.subscription = s;
            this.expectingCount = this.requestCount;
            s.request((long)this.requestCount);
        } else {
            s.cancel();
        }
    }

    public void onNext(A elem) {
        if (this.subscription == null) {
            throw new NullPointerException("onSubscription never happened, see rule 2.13 in the Reactive Streams spec");
        }
        if (elem == null) {
            throw new NullPointerException("onNext(null) is forbidden, see rule 2.13 in the Reactive Streams spec");
        }
        if (!this.isCanceled) {
            Ack ack;
            if (this.expectingCount > 0L) {
                --this.expectingCount;
            }
            if (Ack$Continue$.MODULE$.equals(ack = this.target.onNext(elem))) {
                BoxedUnit boxedUnit;
                if (this.expectingCount == 0L) {
                    this.expectingCount = this.requestCount;
                    this.subscription.request((long)this.requestCount);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (Ack.Stop$.MODULE$.equals(ack)) {
                this.isCanceled = true;
                this.subscription.cancel();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)ack);
            }
        }
    }

    public void onError(Throwable ex) {
        block1: {
            if (ex == null) {
                throw new NullPointerException("onError(null) is forbidden, see rule 2.13 in the Reactive Streams spec");
            }
            if (this.isCanceled) break block1;
            this.isCanceled = true;
            this.target.onError(ex);
        }
    }

    public void onComplete() {
        block0: {
            if (this.isCanceled) break block0;
            this.isCanceled = true;
            this.target.onComplete();
        }
    }

    public SyncSubscriberAsReactiveSubscriber(Subscriber.Sync<A> target, int requestCount) {
        this.target = target;
        this.requestCount = requestCount;
        Predef$.MODULE$.require(requestCount > 0, (Function0 & java.io.Serializable & Serializable)() -> "requestCount must be strictly positive, according to the Reactive Streams contract");
        this.s = target.scheduler();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.subscription = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.expectingCount = 0L;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.isCanceled = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

