/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import monix.execution.Ack;
import monix.execution.Ack$Continue$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.exceptions.APIContractViolationException$;
import monix.execution.internal.Platform$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u00055d!\u0002\u0007\u000e\u0005E)\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u00115\u0002!\u0011!Q\u0001\n9BQ!\r\u0001\u0005\u0002IBaa\u000e\u0001!\u0002\u0013A\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0002(\u0001\t\u0013y\u0005\"\u0002;\u0001\t\u0013)\bbBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\ty\u0005\u0001C\u0005\u0003#B\u0011\"!\u0017\u0001#\u0003%I!a\u0017\u0003+%s\u0007/\u001e;TiJ,\u0017-\\(cg\u0016\u0014h/\u00192mK*\u0011abD\u0001\tEVLG\u000eZ3sg*\u0011\u0001#E\u0001\tS:$XM\u001d8bY*\u0011!cE\u0001\te\u0016\f7\r^5wK*\tA#A\u0003n_:L\u0007p\u0005\u0002\u0001-A\u0019q\u0003\u0007\u000e\u000e\u0003EI!!G\t\u0003\u0015=\u00137/\u001a:wC\ndW\rE\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00037\u0005J!A\t\u000f\u0003\t\tKH/Z\u0001\u0003S:\u001c\u0001\u0001\u0005\u0002'W5\tqE\u0003\u0002)S\u0005\u0011\u0011n\u001c\u0006\u0002U\u0005!!.\u0019<b\u0013\tasEA\u0006J]B,Ho\u0015;sK\u0006l\u0017!C2ik:\\7+\u001b>f!\tYr&\u0003\u000219\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\r\u0019TG\u000e\t\u0003i\u0001i\u0011!\u0004\u0005\u0006G\r\u0001\r!\n\u0005\u0006[\r\u0001\rAL\u0001\u000eo\u0006\u001c8+\u001e2tGJL'-\u001a3\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014AB1u_6L7M\u0003\u0002>'\u0005IQ\r_3dkRLwN\\\u0005\u0003\u007fi\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!E;og\u00064WmU;cg\u000e\u0014\u0018NY3G]R\u0011!I\u0012\t\u0003\u0007\u0012k\u0011\u0001P\u0005\u0003\u000br\u0012!bQ1oG\u0016d\u0017M\u00197f\u0011\u00159U\u00011\u0001I\u0003\ryW\u000f\u001e\t\u0004\u00132SR\"\u0001&\u000b\u0005-\u000b\u0012!C8cg\u0016\u0014h/\u001a:t\u0013\ti%J\u0001\u0006Tk\n\u001c8M]5cKJ\f!B]3tG\",G-\u001e7f)\u0019\u0001\u0016\f\u001a4h_R\u0011\u0011\u000b\u0016\t\u00037IK!a\u0015\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006+\u001a\u0001\u001dAV\u0001\u0002gB\u00111iV\u0005\u00031r\u0012\u0011bU2iK\u0012,H.\u001a:\t\u000bi3\u0001\u0019A.\u0002\u0007\u0005\u001c7\u000eE\u0002]?\u0006l\u0011!\u0018\u0006\u0003=r\t!bY8oGV\u0014(/\u001a8u\u0013\t\u0001WL\u0001\u0004GkR,(/\u001a\t\u0003\u0007\nL!a\u0019\u001f\u0003\u0007\u0005\u001b7\u000eC\u0003f\r\u0001\u0007!$A\u0001c\u0011\u00159e\u00011\u0001I\u0011\u0015Ag\u00011\u0001j\u0003\u0005\u0019\u0007C\u00016n\u001b\u0005Y'B\u00017=\u0003-\u0019\u0017M\\2fY\u0006\u0014G.Z:\n\u00059\\'!\u0005\"p_2,\u0017M\\\"b]\u000e,G.\u00192mK\")\u0001O\u0002a\u0001c\u0006\u0011Q-\u001c\t\u0003\u0007JL!a\u001d\u001f\u0003\u001d\u0015CXmY;uS>tWj\u001c3fY\u0006Aa-Y:u\u0019>|\u0007\u000f\u0006\u0004wqj\\H0 \u000b\u0003#^DQ!V\u0004A\u0004YCQ!_\u0004A\u0002i\taAY;gM\u0016\u0014\b\"B$\b\u0001\u0004A\u0005\"\u00025\b\u0001\u0004I\u0007\"\u00029\b\u0001\u0004\t\b\"\u0002@\b\u0001\u0004q\u0013!C:z]\u000eLe\u000eZ3yQ\r9\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0005\u0015!a\u0002;bS2\u0014XmY\u0001\u000bM&dGNQ;gM\u0016\u0014Hc\u0002\u0018\u0002\u0012\u0005M\u0011Q\u0003\u0005\u0006G!\u0001\r!\n\u0005\u0006s\"\u0001\rA\u0007\u0005\t\u0003/A\u0001\u0013!a\u0001]\u0005ya\u000eV8uC2\u0014\u0015\u0010^3t%\u0016\fG\rK\u0002\t\u0003\u0003\t\u0011b]3oI\u0016\u0013(o\u001c:\u0015\r\u0005}\u0011\u0011FA\u001a)\r\t\u0016\u0011\u0005\u0005\u0007+&\u0001\u001d!a\t\u0011\u0007\r\u000b)#C\u0002\u0002(q\u0012\u0011$\u00168dCV<\u0007\u000e^#yG\u0016\u0004H/[8o%\u0016\u0004xN\u001d;fe\"1q)\u0003a\u0001\u0003W\u0001B!\u0013'\u0002.A\u00191$a\f\n\u0007\u0005EBDA\u0004O_RD\u0017N\\4\t\u000f\u0005U\u0012\u00021\u0001\u00028\u0005\tQ\r\u0005\u0003\u0002:\u0005%c\u0002BA\u001e\u0003\u000brA!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003\"\u0013A\u0002\u001fs_>$h(C\u0001\u001e\u0013\r\t9\u0005H\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY%!\u0014\u0003\u0013QC'o\\<bE2,'bAA$9\u0005i!/\u001a9peR4\u0015-\u001b7ve\u0016$B!a\u0015\u0002XQ\u0019\u0011+!\u0016\t\rUS\u00019AA\u0012\u0011\u001d\t)D\u0003a\u0001\u0003o\tACZ5mY\n+hMZ3sI\u0011,g-Y;mi\u0012\u001aTCAA/U\rq\u0013qL\u0016\u0003\u0003C\u0002B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0005\u0003O\n)!A\u0005v]\u000eDWmY6fI&!\u00111NA3\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public final class InputStreamObservable
extends Observable<byte[]> {
    private final InputStream in;
    private final int chunkSize;
    private final AtomicBoolean wasSubscribed;

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<byte[]> out) {
        Cancelable cancelable;
        if (this.wasSubscribed.compareAndSet(false, true)) {
            void var3_3;
            byte[] buffer = new byte[this.chunkSize];
            BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
            ExecutionModel em = out.scheduler().executionModel();
            this.reschedule((Future<Ack>)Ack$Continue$.MODULE$, buffer, out, cancelable2, em, out.scheduler());
            cancelable = var3_3;
        } else {
            out.onError((Throwable)APIContractViolationException$.MODULE$.apply("InputStreamObservable does not support multiple subscribers"));
            cancelable = Cancelable$.MODULE$.empty();
        }
        return cancelable;
    }

    private void reschedule(Future<Ack> ack, byte[] b, Subscriber<byte[]> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1 & Serializable)x0$1 -> {
            InputStreamObservable.$anonfun$reschedule$1(this, c, b, out, em, s, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)s);
    }

    private void fastLoop(byte[] buffer, Subscriber<byte[]> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block12: {
            BoxedUnit boxedUnit;
            boolean streamErrors;
            Throwable errorThrown;
            block11: {
                Ack$Continue$ ack;
                while (true) {
                    int nextIndex;
                    int n;
                    errorThrown = null;
                    ack = Ack$Continue$.MODULE$;
                    streamErrors = true;
                    try {
                        Future<Ack> future;
                        int length = this.fillBuffer(this.in, buffer, this.fillBuffer$default$3());
                        streamErrors = false;
                        if (length >= 0) {
                            byte[] next = Arrays.copyOf(buffer, length);
                            future = out.onNext(next);
                        } else {
                            out.onComplete();
                            future = Ack.Stop$.MODULE$;
                        }
                        ack = future;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            errorThrown = throwable2;
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                    if (errorThrown != null) break block11;
                    Ack$Continue$ ack$Continue$ = ack;
                    Ack$Continue$ ack$Continue$2 = Ack$Continue$.MODULE$;
                    if (!(ack$Continue$ != null ? !ack$Continue$.equals(ack$Continue$2) : ack$Continue$2 != null)) {
                        n = em.nextFrameIndex(syncIndex);
                    } else {
                        Ack$Continue$ ack$Continue$3 = ack;
                        Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                        n = !(ack$Continue$3 != null ? !ack$Continue$3.equals(stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                    }
                    if (nextIndex < 0 || c.isCanceled()) {
                        boxedUnit = BoxedUnit.UNIT;
                        break block12;
                    }
                    if (nextIndex <= 0) break;
                    syncIndex = nextIndex;
                }
                this.reschedule((Future<Ack>)ack, buffer, out, c, em, s);
                boxedUnit = BoxedUnit.UNIT;
                break block12;
            }
            if (streamErrors) {
                this.sendError(out, errorThrown, (UncaughtExceptionReporter)s);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.reportFailure(errorThrown, (UncaughtExceptionReporter)s);
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private int fillBuffer(InputStream in, byte[] buffer, int nTotalBytesRead) {
        int n;
        block2: {
            int nBytesRead;
            while (true) {
                if (nTotalBytesRead >= buffer.length) {
                    n = nTotalBytesRead;
                    break block2;
                }
                nBytesRead = in.read(buffer, nTotalBytesRead, buffer.length - nTotalBytesRead);
                if (nBytesRead < 0) break;
                nTotalBytesRead += nBytesRead;
            }
            n = nTotalBytesRead <= 0 ? nBytesRead : nTotalBytesRead;
        }
        return n;
    }

    private int fillBuffer$default$3() {
        return 0;
    }

    private void sendError(Subscriber<Nothing$> out, Throwable e, UncaughtExceptionReporter s) {
        try {
            out.onError(e);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e2 = (Throwable)option.get();
                this.reportFailure(Platform$.MODULE$.composeErrors(e, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Throwable[]{e2})), s);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void reportFailure(Throwable e, UncaughtExceptionReporter s) {
        s.reportFailure(e);
        try {
            this.in.close();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$reschedule$1(InputStreamObservable $this, BooleanCancelable c$1, byte[] b$1, Subscriber out$1, ExecutionModel em$1, Scheduler s$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Ack next;
            Success success = (Success)try_;
            Ack ack = next = (Ack)success.value();
            Ack$Continue$ ack$Continue$ = Ack$Continue$.MODULE$;
            BoxedUnit boxedUnit = !(ack != null ? !ack.equals(ack$Continue$) : ack$Continue$ != null) && !c$1.isCanceled() ? (BoxedUnit)package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.fastLoop(b$1, out$1, c$1, em$1, 0, s$1)) : BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            $this.reportFailure(ex, (UncaughtExceptionReporter)s$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public InputStreamObservable(InputStream in, int chunkSize) {
        this.in = in;
        this.chunkSize = chunkSize;
        Predef$.MODULE$.require(chunkSize > 0, (Function0 & Serializable)() -> "chunkSize > 0");
        this.wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    }
}

