/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers.buffers;

import java.util.AbstractQueue;
import monix.reactive.observers.buffers.ConcurrentQueue$;
import org.jctools.queues.MessagePassingQueue;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}bAB\r\u001b\u0003\u0003Q\"\u0005C\u0003+\u0001\u0011\u0005A\u0006C\u0003;\u0001\u0019\u00051\bC\u0003@\u0001\u0019\u0005\u0001\tC\u0003B\u0001\u0019\u0005!\tC\u0003F\u0001\u0019\u0005ai\u0002\u0004Z5!\u0005!D\u0017\u0004\u00073iA\tAG.\t\u000b):A\u0011\u0001/\t\u000bu;A\u0011\u00010\t\u000b\u0015<A\u0011\u00014\u0007\t-<a\u0001\u001c\u0005\tc.\u0011\t\u0011)A\u0005e\")!f\u0003C\u0001u\")!h\u0003C\u0001w!)\u0011i\u0003C\u0001}\"1qh\u0003C\u0001\u0003\u0003Aa!R\u0006\u0005\u0002\u0005\raABA\u0006\u000f\u0019\ti\u0001C\u0005r%\t\u0005\t\u0015!\u0003\u0002\u0018!1!F\u0005C\u0001\u0003WAQA\u000f\n\u0005\u0002mBa!\u0011\n\u0005\u0002\u0005E\u0002BB \u0013\t\u0003\t)\u0004\u0003\u0004F%\u0011\u0005\u0011q\u0007\u0002\u0010\u0007>t7-\u001e:sK:$\u0018+^3vK*\u00111\u0004H\u0001\bEV4g-\u001a:t\u0015\tib$A\u0005pEN,'O^3sg*\u0011q\u0004I\u0001\te\u0016\f7\r^5wK*\t\u0011%A\u0003n_:L\u00070\u0006\u0002$cM\u0011\u0001\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\f\t\u0004]\u0001yS\"\u0001\u000e\u0011\u0005A\nD\u0002\u0001\u0003\u0006e\u0001\u0011\ra\r\u0002\u0002\u0003F\u0011Ag\u000e\t\u0003KUJ!A\u000e\u0014\u0003\u000f9{G\u000f[5oOB\u0011Q\u0005O\u0005\u0003s\u0019\u00121!\u00118z\u0003\u001dI7/R7qif,\u0012\u0001\u0010\t\u0003KuJ!A\u0010\u0014\u0003\u000f\t{w\u000e\\3b]\u0006!\u0001o\u001c7m)\u0005y\u0013!B8gM\u0016\u0014HC\u0001\u001fD\u0011\u0015!E\u00011\u00010\u0003\u0011)G.Z7\u0002\u001b\u0011\u0014\u0018-\u001b8U_\n+hMZ3s)\r9%\n\u0016\t\u0003K!K!!\u0013\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0017\u0016\u0001\r\u0001T\u0001\u0007EV4g-\u001a:\u0011\u00075\u0013v&D\u0001O\u0015\ty\u0005+A\u0004nkR\f'\r\\3\u000b\u0005E3\u0013AC2pY2,7\r^5p]&\u00111K\u0014\u0002\u0007\u0005V4g-\u001a:\t\u000bU+\u0001\u0019\u0001,\u0002\u000b1LW.\u001b;\u0011\u0005\u0015:\u0016B\u0001-'\u0005\rIe\u000e^\u0001\u0010\u0007>t7-\u001e:sK:$\u0018+^3vKB\u0011afB\n\u0003\u000f\u0011\"\u0012AW\u0001\bY&l\u0017\u000e^3e+\ty&\r\u0006\u0002aGB\u0019a\u0006A1\u0011\u0005A\u0012G!\u0002\u001a\n\u0005\u0004\u0019\u0004\"\u00023\n\u0001\u00041\u0016\u0001C2ba\u0006\u001c\u0017\u000e^=\u0002\u0013Ut'm\\;oI\u0016$WCA4k)\u0005A\u0007c\u0001\u0018\u0001SB\u0011\u0001G\u001b\u0003\u0006e)\u0011\ra\r\u0002\u0012\rJ|W.\u00112tiJ\f7\r^)vKV,WCA7q'\tYa\u000eE\u0002/\u0001=\u0004\"\u0001\r9\u0005\u000bIZ!\u0019A\u001a\u0002\u0015UtG-\u001a:ms&tw\rE\u0002tq>l\u0011\u0001\u001e\u0006\u0003kZ\fA!\u001e;jY*\tq/\u0001\u0003kCZ\f\u0017BA=u\u00055\t%m\u001d;sC\u000e$\u0018+^3vKR\u001110 \t\u0004y.yW\"A\u0004\t\u000bEl\u0001\u0019\u0001:\u0015\u0005qz\b\"\u0002#\u0010\u0001\u0004yG#A8\u0015\u000b\u001d\u000b)!!\u0003\t\r-\u000b\u0002\u0019AA\u0004!\ri%k\u001c\u0005\u0006+F\u0001\rA\u0016\u0002\u0018\rJ|W.T3tg\u0006<W\rU1tg&tw-U;fk\u0016,B!a\u0004\u0002\u0016M\u0019!#!\u0005\u0011\t9\u0002\u00111\u0003\t\u0004a\u0005UA!\u0002\u001a\u0013\u0005\u0004\u0019\u0004CBA\r\u0003O\t\u0019\"\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0019\tX/Z;fg*!\u0011\u0011EA\u0012\u0003\u001dQ7\r^8pYNT!!!\n\u0002\u0007=\u0014x-\u0003\u0003\u0002*\u0005m!aE'fgN\fw-\u001a)bgNLgnZ)vKV,G\u0003BA\u0017\u0003_\u0001B\u0001 \n\u0002\u0014!1\u0011\u000f\u0006a\u0001\u0003/!2\u0001PA\u001a\u0011\u0019!e\u00031\u0001\u0002\u0014Q\u0011\u00111\u0003\u000b\u0006\u000f\u0006e\u0012Q\b\u0005\u0007\u0017b\u0001\r!a\u000f\u0011\t5\u0013\u00161\u0003\u0005\u0006+b\u0001\rA\u0016")
public abstract class ConcurrentQueue<A> {
    public static <A> ConcurrentQueue<A> unbounded() {
        return ConcurrentQueue$.MODULE$.unbounded();
    }

    public static <A> ConcurrentQueue<A> limited(int n) {
        return ConcurrentQueue$.MODULE$.limited(n);
    }

    public abstract boolean isEmpty();

    public abstract A poll();

    public abstract boolean offer(A var1);

    public abstract void drainToBuffer(Buffer<A> var1, int var2);

    public static final class FromAbstractQueue<A>
    extends ConcurrentQueue<A> {
        private final AbstractQueue<A> underlying;

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean offer(A elem) {
            return this.underlying.offer(elem);
        }

        @Override
        public A poll() {
            return (A)this.underlying.poll();
        }

        @Override
        public void drainToBuffer(Buffer<A> buffer, int limit) {
            for (int fetched = 0; fetched < limit; ++fetched) {
                Object next = this.underlying.poll();
                if (next == null) {
                    return;
                }
                buffer.$plus$eq(next);
            }
        }

        public FromAbstractQueue(AbstractQueue<A> underlying) {
            this.underlying = underlying;
        }
    }

    public static final class FromMessagePassingQueue<A>
    extends ConcurrentQueue<A> {
        private final MessagePassingQueue<A> underlying;

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public boolean offer(A elem) {
            return this.underlying.relaxedOffer(elem);
        }

        @Override
        public A poll() {
            return (A)this.underlying.relaxedPoll();
        }

        @Override
        public void drainToBuffer(Buffer<A> buffer, int limit) {
            MessagePassingQueue.Consumer consumer = new MessagePassingQueue.Consumer<A>(null, buffer){
                private final Buffer buffer$1;

                public void accept(A e) {
                    this.buffer$1.$plus$eq(e);
                }
                {
                    this.buffer$1 = buffer$1;
                }
            };
            this.underlying.drain(consumer, limit);
        }

        public FromMessagePassingQueue(MessagePassingQueue<A> underlying) {
            this.underlying = underlying;
        }
    }
}

