/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Ack$Continue$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.compat;
import monix.execution.exceptions.APIContractViolationException$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db!B\u0005\u000b\u00059\u0011\u0002\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011]\u0002!\u0011!Q\u0001\naBQa\u000f\u0001\u0005\u0002qBa!\u0011\u0001!\u0002\u0013\u0011\u0005\"\u0002&\u0001\t\u0003Y\u0005\"\u0002-\u0001\t\u0013I\u0006\"\u0002/\u0001\t\u0013i\u0006bBA\u0003\u0001\u0011%\u0011q\u0001\u0002\u001d\u0005V4g-\u001a:fI&#XM]1u_J\f5o\u00142tKJ4\u0018M\u00197f\u0015\tYA\"\u0001\u0005ck&dG-\u001a:t\u0015\tia\"\u0001\u0005j]R,'O\\1m\u0015\ty\u0001#\u0001\u0005sK\u0006\u001cG/\u001b<f\u0015\u0005\t\u0012!B7p]&DXCA\n*'\t\u0001A\u0003E\u0002\u0016-ai\u0011AD\u0005\u0003/9\u0011!b\u00142tKJ4\u0018M\u00197f!\rIBe\n\b\u00035\u0005r!aG\u0010\u000e\u0003qQ!!\b\u0010\u0002\rq\u0012xn\u001c;?\u0007\u0001I\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E\r\nq\u0001]1dW\u0006<WMC\u0001!\u0013\t)cEA\u0002TKFT!AI\u0012\u0011\u0005!JC\u0002\u0001\u0003\u0006U\u0001\u0011\ra\u000b\u0002\u0002\u0003F\u0011A\u0006\r\t\u0003[9j\u0011aI\u0005\u0003_\r\u0012qAT8uQ&tw\r\u0005\u0002.c%\u0011!g\t\u0002\u0004\u0003:L\u0018\u0001C5uKJ\fGo\u001c:\u0011\u0007e)t%\u0003\u00027M\tA\u0011\n^3sCR|'/\u0001\u0006ck\u001a4WM]*ju\u0016\u0004\"!L\u001d\n\u0005i\u001a#aA%oi\u00061A(\u001b8jiz\"2!P A!\rq\u0004aJ\u0007\u0002\u0015!)1g\u0001a\u0001i!)qg\u0001a\u0001q\u0005iq/Y:Tk\n\u001c8M]5cK\u0012\u0004\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\r\u0005$x.\\5d\u0015\t9\u0005#A\u0005fq\u0016\u001cW\u000f^5p]&\u0011\u0011\n\u0012\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002#Ut7/\u00194f'V\u00147o\u0019:jE\u00164e\u000e\u0006\u0002M!B\u0011QJT\u0007\u0002\r&\u0011qJ\u0012\u0002\u000b\u0007\u0006t7-\u001a7bE2,\u0007\"B)\u0006\u0001\u0004\u0011\u0016aA8viB\u00191K\u0016\r\u000e\u0003QS!!\u0016\b\u0002\u0013=\u00147/\u001a:wKJ\u001c\u0018BA,U\u0005)\u0019VOY:de&\u0014WM]\u0001\ngR\f'\u000f\u001e'p_B$\"\u0001\u0014.\t\u000bm3\u0001\u0019\u0001*\u0002\u0015M,(m]2sS\n,'/\u0001\u0006sKN\u001c\u0007.\u001a3vY\u0016$bAX4siVlHCA0c!\ti\u0003-\u0003\u0002bG\t!QK\\5u\u0011\u0015\u0019w\u0001q\u0001e\u0003\u0005\u0019\bCA'f\u0013\t1gIA\u0005TG\",G-\u001e7fe\")\u0001n\u0002a\u0001S\u0006\u0019\u0011mY6\u0011\u0007)lw.D\u0001l\u0015\ta7%\u0001\u0006d_:\u001cWO\u001d:f]RL!A\\6\u0003\r\u0019+H/\u001e:f!\ti\u0005/\u0003\u0002r\r\n\u0019\u0011iY6\t\u000bM<\u0001\u0019\u0001\u001b\u0002\t%$XM\u001d\u0005\u0006#\u001e\u0001\rA\u0015\u0005\u0006m\u001e\u0001\ra^\u0001\u0002GB\u0011\u0001p_\u0007\u0002s*\u0011!PR\u0001\fG\u0006t7-\u001a7bE2,7/\u0003\u0002}s\n\t\"i\\8mK\u0006t7)\u00198dK2\f'\r\\3\t\u000by<\u0001\u0019A@\u0002\u0005\u0015l\u0007cA'\u0002\u0002%\u0019\u00111\u0001$\u0003\u001d\u0015CXmY;uS>tWj\u001c3fY\u0006Aa-Y:u\u0019>|\u0007\u000f\u0006\u0007\u0002\n\u00055\u0011qBA\t\u0003'\t)\u0002F\u0002`\u0003\u0017AQa\u0019\u0005A\u0004\u0011DQa\u001d\u0005A\u0002QBQ!\u0015\u0005A\u0002ICQA\u001e\u0005A\u0002]DQA \u0005A\u0002}Da!a\u0006\t\u0001\u0004A\u0014!C:z]\u000eLe\u000eZ3yQ\rA\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0005}!a\u0002;bS2\u0014Xm\u0019")
public final class BufferedIteratorAsObservable<A>
extends Observable<Seq<A>> {
    private final Iterator<A> iterator;
    private final int bufferSize;
    private final AtomicBoolean wasSubscribed;
    private volatile boolean bitmap$init$0;

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<Seq<A>> out) {
        Cancelable cancelable;
        if (this.wasSubscribed.getAndSet(true)) {
            out.onError((Throwable)APIContractViolationException$.MODULE$.apply("InputStreamObservable"));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            cancelable = this.startLoop(out);
        }
        return cancelable;
    }

    private Cancelable startLoop(Subscriber<Seq<A>> subscriber) {
        Cancelable cancelable;
        block7: {
            boolean streamErrors = true;
            try {
                boolean iteratorHasNext = this.iterator.hasNext();
                streamErrors = false;
                if (!iteratorHasNext) {
                    subscriber.onComplete();
                    cancelable = Cancelable$.MODULE$.empty();
                    break block7;
                }
                BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
                this.fastLoop(this.iterator, subscriber, cancelable2, subscriber.scheduler().executionModel(), 0, subscriber.scheduler());
                cancelable = cancelable2;
            }
            catch (Throwable throwable) {
                Cancelable cancelable3;
                Throwable throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    if (streamErrors) {
                        subscriber.onError(throwable2);
                        cancelable3 = Cancelable$.MODULE$.empty();
                    } else {
                        subscriber.scheduler().reportFailure(throwable2);
                        cancelable3 = Cancelable$.MODULE$.empty();
                    }
                } else {
                    throw throwable;
                }
                Cancelable cancelable4 = cancelable3;
                cancelable = cancelable4;
            }
        }
        return cancelable;
    }

    private void reschedule(Future<Ack> ack, Iterator<A> iter, Subscriber<Seq<A>> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1 & Serializable)x0$1 -> {
            BufferedIteratorAsObservable.$anonfun$reschedule$1(this, iter, out, c, em, s, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)s);
    }

    private void fastLoop(Iterator<A> iter, Subscriber<Seq<A>> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block14: {
            int nextIndex;
            BoxedUnit boxedUnit;
            Future<Ack> ack;
            while (true) {
                int n;
                int size;
                ack = Ack$Continue$.MODULE$;
                boolean streamErrors = true;
                boolean iteratorHasNext = true;
                Throwable iteratorTriggeredError = null;
                Object[] buffer = new Object[this.bufferSize];
                try {
                    for (size = 0; iteratorHasNext && size < this.bufferSize; ++size) {
                        Object next;
                        buffer[size] = next = iter.next();
                        iteratorHasNext = iter.hasNext();
                    }
                    ack = size == this.bufferSize ? out.onNext(compat.internal$.MODULE$.toSeq(buffer)) : out.onNext(compat.internal$.MODULE$.toSeq((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps(buffer), size)));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        if (streamErrors) {
                            iteratorTriggeredError = ex;
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        }
                    }
                    throw throwable;
                }
                if (iteratorTriggeredError != null) {
                    if (!c.isCanceled()) {
                        out.onError(iteratorTriggeredError);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        s.reportFailure(iteratorTriggeredError);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    break block14;
                }
                if (!iteratorHasNext) {
                    streamErrors = true;
                    out.onComplete();
                    boxedUnit = BoxedUnit.UNIT;
                    break block14;
                }
                Future<Ack> future = ack;
                Ack$Continue$ ack$Continue$ = Ack$Continue$.MODULE$;
                if (!(future != null ? !future.equals((Object)ack$Continue$) : ack$Continue$ != null)) {
                    n = em.nextFrameIndex(syncIndex + (size - 1));
                } else {
                    Future<Ack> future2 = ack;
                    Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                    n = !(future2 != null ? !future2.equals((Object)stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                }
                if (nextIndex <= 0) break;
                syncIndex = nextIndex;
            }
            if (nextIndex == 0 && !c.isCanceled()) {
                this.reschedule(ack, iter, out, c, em, s);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$reschedule$1(BufferedIteratorAsObservable $this, Iterator iter$1, Subscriber out$1, BooleanCancelable c$1, ExecutionModel em$1, Scheduler s$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Ack next;
            Success success = (Success)try_;
            Ack ack = next = (Ack)success.value();
            Ack$Continue$ ack$Continue$ = Ack$Continue$.MODULE$;
            if (!(ack != null ? !ack.equals(ack$Continue$) : ack$Continue$ != null)) {
                try {
                    $this.fastLoop(iter$1, out$1, c$1, em$1, 0, s$1);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    s$1.reportFailure(throwable2);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            out$1.onError(ex);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public BufferedIteratorAsObservable(Iterator<A> iterator, int bufferSize) {
        this.iterator = iterator;
        this.bufferSize = bufferSize;
        Predef$.MODULE$.require(bufferSize > 0, (Function0 & Serializable)() -> "bufferSize must be strictly positive");
        this.wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
        this.bitmap$init$0 = true;
    }
}

