/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive;

import java.io.Serializable;
import monix.execution.ChannelType;
import monix.execution.Scheduler;
import monix.reactive.MulticastStrategy;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.Observer;
import monix.reactive.Observer$;
import monix.reactive.OverflowStrategy;
import monix.reactive.OverflowStrategy$Unbounded$;
import monix.reactive.Pipe$;
import monix.reactive.observers.BufferedSubscriber$;
import monix.reactive.observers.Subscriber;
import monix.reactive.observers.Subscriber$;
import monix.reactive.subjects.PublishSubject;
import monix.reactive.subjects.PublishSubject$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.util.control.NonFatal$;

public abstract class Pipe<I, O>
implements Serializable {
    public static <A> Pipe<A, A> apply(MulticastStrategy<A> multicastStrategy) {
        return Pipe$.MODULE$.apply(multicastStrategy);
    }

    public static Pipe async() {
        return Pipe$.MODULE$.async();
    }

    public static <A> Pipe<A, A> behavior(A a) {
        return Pipe$.MODULE$.behavior(a);
    }

    public static Pipe publish() {
        return Pipe$.MODULE$.publish();
    }

    public static Pipe publishToOne() {
        return Pipe$.MODULE$.publishToOne();
    }

    public static Pipe replay() {
        return Pipe$.MODULE$.replay();
    }

    public static <A> Pipe<A, A> replay(Seq<A> seq) {
        return Pipe$.MODULE$.replay(seq);
    }

    public static <A> Pipe<A, A> replayLimited(int n) {
        return Pipe$.MODULE$.replayLimited(n);
    }

    public static <A> Pipe<A, A> replayLimited(int n, Seq<A> seq) {
        return Pipe$.MODULE$.replayLimited(n, seq);
    }

    public abstract Tuple2<Observer<I>, Observable<O>> unicast();

    public Tuple2<Observer<I>, Observable<O>> multicast(Scheduler s) {
        Tuple2<Observer<I>, Observable<O>> tuple2 = this.unicast();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Observer in = (Observer)tuple2._1();
        Observable out = (Observable)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)in, (Object)out);
        Observer in2 = (Observer)tuple22._1();
        Observable out2 = (Observable)tuple22._2();
        PublishSubject proc = PublishSubject$.MODULE$.apply();
        out2.unsafeSubscribeFn(Subscriber$.MODULE$.apply(proc, s));
        return Tuple2$.MODULE$.apply((Object)in2, proc);
    }

    public Tuple2<Observer.Sync<I>, Observable<O>> concurrent(Scheduler s) {
        return this.concurrent(OverflowStrategy$Unbounded$.MODULE$, s);
    }

    public Tuple2<Observer.Sync<I>, Observable<O>> concurrent(OverflowStrategy.Synchronous<I> strategy, Scheduler s) {
        return this.concurrent(strategy, (ChannelType.ProducerSide)ChannelType.MultiProducer$.MODULE$, s);
    }

    public Tuple2<Observer.Sync<I>, Observable<O>> concurrent(OverflowStrategy.Synchronous<I> strategy, ChannelType.ProducerSide producerType, Scheduler s) {
        Tuple2<Observer<I>, Observable<O>> tuple2 = this.multicast(s);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Observer in = (Observer)tuple2._1();
        Observable out = (Observable)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)in, (Object)out);
        Observer in2 = (Observer)tuple22._1();
        Observable out2 = (Observable)tuple22._2();
        Subscriber.Sync buffer = BufferedSubscriber$.MODULE$.synchronous(Subscriber$.MODULE$.apply(in2, s), (OverflowStrategy.Synchronous)strategy, producerType);
        return Tuple2$.MODULE$.apply((Object)buffer, (Object)out2);
    }

    public final <B> Pipe<I, B> liftByOperator(Function1<Subscriber<B>, Subscriber<O>> op) {
        return new LiftedPipe(this, op);
    }

    public final <B> Pipe<I, B> transform(Function1<Observable<O>, Observable<B>> f) {
        return new TransformedPipe(this, f);
    }

    private static final class LiftedPipe<I, O, U>
    extends Pipe<I, U> {
        private final Pipe<I, O> self;
        private final Function1<Subscriber<U>, Subscriber<O>> op;

        public <I, O, U> LiftedPipe(Pipe<I, O> self, Function1<Subscriber<U>, Subscriber<O>> op) {
            this.self = self;
            this.op = op;
        }

        @Override
        public Tuple2<Observer<I>, Observable<U>> unicast() {
            Tuple2<Observer<I>, Observable<O>> tuple2 = this.self.unicast();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Observer in = (Observer)tuple2._1();
            Observable out = (Observable)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)in, (Object)out);
            Observer in2 = (Observer)tuple22._1();
            Observable out2 = (Observable)tuple22._2();
            Observable<U> outU = out2.liftByOperator(this.op);
            return Tuple2$.MODULE$.apply((Object)in2, outU);
        }

        @Override
        public Tuple2<Observer<I>, Observable<U>> multicast(Scheduler s) {
            Tuple2<Observer<I>, Observable<O>> tuple2 = this.self.multicast(s);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Observer in = (Observer)tuple2._1();
            Observable out = (Observable)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)in, (Object)out);
            Observer in2 = (Observer)tuple22._1();
            Observable out2 = (Observable)tuple22._2();
            Observable<U> outU = out2.liftByOperator(this.op);
            return Tuple2$.MODULE$.apply((Object)in2, outU);
        }
    }

    private static final class TransformedPipe<I, O, U>
    extends Pipe<I, U> {
        private final Pipe<I, O> self;
        private final Function1<Observable<O>, Observable<U>> f;

        public <I, O, U> TransformedPipe(Pipe<I, O> self, Function1<Observable<O>, Observable<U>> f) {
            this.self = self;
            this.f = f;
        }

        @Override
        public Tuple2<Observer<I>, Observable<U>> unicast() {
            Tuple2 tuple2;
            try {
                Tuple2<Observer<I>, Observable<O>> tuple22 = this.self.unicast();
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Observer in = (Observer)tuple22._1();
                Observable out = (Observable)tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)in, (Object)out);
                Observer in2 = (Observer)tuple23._1();
                Observable out2 = (Observable)tuple23._2();
                tuple2 = Tuple2$.MODULE$.apply((Object)in2, this.f.apply((Object)out2));
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    tuple2 = Tuple2$.MODULE$.apply(Observer$.MODULE$.stopped(), Observable$.MODULE$.raiseError(e));
                }
                throw throwable;
            }
            return tuple2;
        }

        @Override
        public Tuple2<Observer<I>, Observable<U>> multicast(Scheduler s) {
            Tuple2 tuple2;
            try {
                Tuple2<Observer<I>, Observable<O>> tuple22 = this.self.multicast(s);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Observer in = (Observer)tuple22._1();
                Observable out = (Observable)tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)in, (Object)out);
                Observer in2 = (Observer)tuple23._1();
                Observable out2 = (Observable)tuple23._2();
                tuple2 = Tuple2$.MODULE$.apply((Object)in2, this.f.apply((Object)out2));
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    tuple2 = Tuple2$.MODULE$.apply(Observer$.MODULE$.stopped(), Observable$.MODULE$.raiseError(e));
                }
                throw throwable;
            }
            return tuple2;
        }
    }
}

