/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.compression.internal.operators;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import monix.reactive.compression.CompressionLevel;
import monix.reactive.compression.CompressionStrategy;
import monix.reactive.compression.FlushMode;
import monix.reactive.compression.internal.operators.Deflate$;
import monix.reactive.compression.internal.operators.Gzipper$gzipOperatingSystem$;
import monix.reactive.compression.package$;
import monix.reactive.compression.package$gzipCompressionMethod$;
import monix.reactive.compression.package$gzipExtraFlag$;
import monix.reactive.compression.package$gzipFlag$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Gzipper {
    private final CompressionLevel level;
    private final FlushMode flushMode;
    private final Option<String> fileName;
    private final Option<Instant> modificationTime;
    private final Option<String> comment;
    private final CRC32 crc;
    private final byte[] buffer;
    private boolean headerSent;
    private long inputSize;
    private final Deflater deflater;

    public Gzipper(int bufferSize, CompressionLevel level, CompressionStrategy strategy, FlushMode flushMode, Option<String> fileName, Option<Instant> modificationTime, Option<String> comment) {
        this.level = level;
        this.flushMode = flushMode;
        this.fileName = fileName;
        this.modificationTime = modificationTime;
        this.comment = comment;
        this.crc = new CRC32();
        this.buffer = new byte[bufferSize];
        this.headerSent = false;
        this.inputSize = 0L;
        Deflater deflater = new Deflater(level.value(), true);
        deflater.setStrategy(strategy.jValue());
        this.deflater = deflater;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] finish() {
        void var3_4;
        byte[] byArray;
        this.deflater.finish();
        Object object = Predef$.MODULE$.byteArrayOps(Deflate$.MODULE$.pullOutput(this.deflater, this.buffer, this.flushMode));
        byte[] restAndTrailer = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)this.getTrailer(), ClassTag$.MODULE$.apply(Byte.TYPE));
        if (this.headerSent) {
            byArray = restAndTrailer;
        } else {
            Object object2 = Predef$.MODULE$.byteArrayOps(this.header());
            byArray = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object2, (Object)restAndTrailer, ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        byte[] lastChunk = byArray;
        this.deflater.reset();
        this.crc.reset();
        this.inputSize = 0L;
        this.headerSent = false;
        return var3_4;
    }

    public byte[] onChunk(byte[] chunk) {
        byte[] byArray;
        this.inputSize += (long)chunk.length;
        this.crc.update(chunk);
        this.deflater.setInput(chunk);
        byte[] deflated = Deflate$.MODULE$.pullOutput(this.deflater, this.buffer, this.flushMode);
        if (this.headerSent) {
            byArray = deflated;
        } else {
            this.headerSent = true;
            Object object = Predef$.MODULE$.byteArrayOps(this.header());
            byArray = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)deflated, ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        return byArray;
    }

    public byte[] getTrailer() {
        long v = this.crc.getValue();
        long s = this.inputSize & 0xFFFFL;
        return new byte[]{Gzipper.byte$1(v, 0), Gzipper.byte$1(v, 1), Gzipper.byte$1(v, 2), Gzipper.byte$1(v, 3), Gzipper.byte$1(s, 0), Gzipper.byte$1(s, 1), Gzipper.byte$1(s, 2), Gzipper.byte$1(s, 3)};
    }

    public void close() {
        this.deflater.finish();
    }

    private byte[] header() {
        int n;
        long secondsSince197001010000 = BoxesRunTime.unboxToLong((Object)this.modificationTime.fold(Gzipper::$anonfun$1, (Function1 & Serializable)_$2 -> _$2.getEpochSecond()));
        Object object = Predef$.MODULE$.byteArrayOps(new byte[]{package$.MODULE$.gzipMagicFirstByte(), package$.MODULE$.gzipMagicSecondByte(), package$gzipCompressionMethod$.MODULE$.DEFLATE(), (byte)(package$gzipFlag$.MODULE$.FHCRC() + BoxesRunTime.unboxToByte((Object)this.fileName.fold(Gzipper::$anonfun$3, (Function1 & Serializable)_$3 -> package$gzipFlag$.MODULE$.FNAME())) + BoxesRunTime.unboxToByte((Object)this.comment.fold(Gzipper::$anonfun$5, (Function1 & Serializable)_$4 -> package$gzipFlag$.MODULE$.FCOMMENT()))), (byte)(secondsSince197001010000 & 0xFFL), (byte)(secondsSince197001010000 >> 8 & 0xFFL), (byte)(secondsSince197001010000 >> 16 & 0xFFL), (byte)(secondsSince197001010000 >> 24 & 0xFFL), 9 == (n = this.level.value()) ? package$gzipExtraFlag$.MODULE$.DEFLATE_MAX_COMPRESSION_SLOWEST_ALGO() : (1 == n ? package$gzipExtraFlag$.MODULE$.DEFLATE_FASTEST_ALGO() : package$.MODULE$.zeroByte()), Gzipper$gzipOperatingSystem$.MODULE$.THIS()});
        byte[] header = (byte[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$5 -> BoxesRunTime.unboxToByte((Object)_$5), ClassTag$.MODULE$.apply(Byte.TYPE));
        CRC32 crc32 = new CRC32();
        crc32.update(header);
        Option fileNameEncoded = this.fileName.map((Function1 & Serializable)string -> {
            void var2_2;
            byte[] bytes = string.replaceAll("\u0000", "_").getBytes(StandardCharsets.ISO_8859_1);
            crc32.update(bytes);
            crc32.update(new byte[]{package$.MODULE$.zeroByte()});
            return var2_2;
        });
        Option commentEncoded = this.comment.map((Function1 & Serializable)string -> {
            void var2_2;
            byte[] bytes = string.replaceAll("\u0000", " ").getBytes(StandardCharsets.ISO_8859_1);
            crc32.update(bytes);
            crc32.update(new byte[]{package$.MODULE$.zeroByte()});
            return var2_2;
        });
        long crc32Value = crc32.getValue();
        byte[] crc16 = new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL)};
        Object object2 = Predef$.MODULE$.byteArrayOps(header);
        Object object3 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object2, fileNameEncoded.getOrElse(Gzipper::header$$anonfun$1), ClassTag$.MODULE$.apply(Byte.TYPE)));
        Object object4 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object3, commentEncoded.getOrElse(Gzipper::header$$anonfun$2), ClassTag$.MODULE$.apply(Byte.TYPE)));
        return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object4, (Object)crc16, ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    private static final byte byte$1(long v, int n) {
        return (byte)(v >> n * 8 & 0xFFL);
    }

    private static final long $anonfun$1() {
        return 0L;
    }

    private static final byte $anonfun$3() {
        return package$.MODULE$.zeroByte();
    }

    private static final byte $anonfun$5() {
        return package$.MODULE$.zeroByte();
    }

    private static final byte[] header$$anonfun$1() {
        return Array$.MODULE$.emptyByteArray();
    }

    private static final byte[] header$$anonfun$2() {
        return Array$.MODULE$.emptyByteArray();
    }
}

