/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.compat;
import monix.execution.exceptions.APIContractViolationException$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class BufferedIteratorAsObservable<A>
extends Observable<Seq<A>> {
    private final Iterator<A> iterator;
    private final int bufferSize;
    private final AtomicBoolean wasSubscribed;

    public <A> BufferedIteratorAsObservable(Iterator<A> iterator, int bufferSize) {
        this.iterator = iterator;
        this.bufferSize = bufferSize;
        Predef$.MODULE$.require(bufferSize > 0, BufferedIteratorAsObservable::$init$$$anonfun$1);
        this.wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<Seq<A>> out) {
        Cancelable cancelable;
        if (this.wasSubscribed.getAndSet(true)) {
            out.onError((Throwable)APIContractViolationException$.MODULE$.apply("InputStreamObservable"));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            cancelable = this.startLoop(out);
        }
        return cancelable;
    }

    private Cancelable startLoop(Subscriber<Seq<A>> subscriber) {
        Cancelable cancelable;
        boolean streamErrors = true;
        try {
            boolean iteratorHasNext = this.iterator.hasNext();
            streamErrors = false;
            if (!iteratorHasNext) {
                subscriber.onComplete();
                cancelable = Cancelable$.MODULE$.empty();
            } else {
                BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
                this.fastLoop(this.iterator, subscriber, cancelable2, subscriber.scheduler().executionModel(), 0, subscriber.scheduler());
                cancelable = cancelable2;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                if (streamErrors) {
                    subscriber.onError(ex);
                    cancelable = Cancelable$.MODULE$.empty();
                } else {
                    subscriber.scheduler().reportFailure(ex);
                    cancelable = Cancelable$.MODULE$.empty();
                }
            }
            throw throwable;
        }
        return cancelable;
    }

    private void reschedule(Future<Ack> ack, Iterator<A> iter, Subscriber<Seq<A>> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Ack next;
                Ack ack = next = (Ack)((Success)try_).value();
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(ack != null ? !ack.equals(continue$) : continue$ != null)) {
                    this.liftedTree1$1(iter, out, c, em, s);
                }
            } else if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                out.onError(ex);
            } else {
                throw new MatchError((Object)try_);
            }
        }, (ExecutionContext)s);
    }

    private void fastLoop(Iterator<A> iter, Subscriber<Seq<A>> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block15: {
            int nextIndex;
            Future<Ack> ack;
            BufferedIteratorAsObservable bufferedIteratorAsObservable = this;
            int n = syncIndex;
            while (true) {
                int n2;
                int size;
                ack = Ack.Continue$.MODULE$;
                boolean streamErrors = true;
                boolean iteratorHasNext = true;
                Throwable iteratorTriggeredError = null;
                Object[] buffer = new Object[bufferedIteratorAsObservable.bufferSize];
                try {
                    Future<Ack> future;
                    for (size = 0; iteratorHasNext && size < bufferedIteratorAsObservable.bufferSize; ++size) {
                        Object next;
                        buffer[size] = next = iter.next();
                        iteratorHasNext = iter.hasNext();
                    }
                    if (size == bufferedIteratorAsObservable.bufferSize) {
                        future = out.onNext(compat.internal$.MODULE$.toSeq(buffer));
                    } else {
                        Object object = Predef$.MODULE$.refArrayOps(buffer);
                        future = out.onNext(compat.internal$.MODULE$.toSeq((Object[])ArrayOps$.MODULE$.take$extension(object, size)));
                    }
                    ack = future;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = (Throwable)option.get();
                        if (streamErrors) {
                            iteratorTriggeredError = ex;
                        }
                    }
                    throw throwable;
                }
                if (iteratorTriggeredError != null) {
                    if (!c.isCanceled()) {
                        out.onError(iteratorTriggeredError);
                    } else {
                        s.reportFailure(iteratorTriggeredError);
                    }
                    break block15;
                }
                if (!iteratorHasNext) {
                    streamErrors = true;
                    out.onComplete();
                    break block15;
                }
                Future<Ack> future = ack;
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(future != null ? !future.equals((Object)continue$) : continue$ != null)) {
                    n2 = em.nextFrameIndex(n + (size - 1));
                } else {
                    Future<Ack> future2 = ack;
                    Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                    n2 = !(future2 != null ? !future2.equals((Object)stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                }
                if (nextIndex <= 0) break;
                BufferedIteratorAsObservable bufferedIteratorAsObservable2 = bufferedIteratorAsObservable;
                int n3 = nextIndex;
                bufferedIteratorAsObservable = bufferedIteratorAsObservable2;
                n = n3;
            }
            if (nextIndex == 0 && !c.isCanceled()) {
                bufferedIteratorAsObservable.reschedule(ack, iter, out, c, em, s);
            }
        }
    }

    private static final String $init$$$anonfun$1() {
        return "bufferSize must be strictly positive";
    }

    private final void liftedTree1$1(Iterator iter$2, Subscriber out$2, BooleanCancelable c$2, ExecutionModel em$2, Scheduler s$2) {
        try {
            this.fastLoop(iter$2, out$2, c$2, em$2, 0, s$2);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                s$2.reportFailure(ex);
            }
            throw throwable;
        }
    }
}

