/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ChannelType;
import monix.reactive.Observable;
import monix.reactive.OverflowStrategy;
import monix.reactive.observers.BufferedSubscriber$;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.util.control.NonFatal$;

public final class CreateObservable<A>
extends Observable<A> {
    private final OverflowStrategy.Synchronous<A> overflowStrategy;
    private final ChannelType.ProducerSide producerType;
    private final Function1<Subscriber.Sync<A>, Cancelable> f;

    public <A> CreateObservable(OverflowStrategy.Synchronous<A> overflowStrategy, ChannelType.ProducerSide producerType, Function1<Subscriber.Sync<A>, Cancelable> f) {
        this.overflowStrategy = overflowStrategy;
        this.producerType = producerType;
        this.f = f;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        Cancelable cancelable;
        Subscriber.Sync out = BufferedSubscriber$.MODULE$.synchronous((Subscriber)subscriber, (OverflowStrategy.Synchronous)this.overflowStrategy, this.producerType);
        try {
            cancelable = (Cancelable)this.f.apply((Object)out);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                subscriber.scheduler().reportFailure(ex);
                cancelable = Cancelable$.MODULE$.empty();
            }
            throw throwable;
        }
        return cancelable;
    }
}

