/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class EvalOnceObservable<A>
extends Observable<A> {
    private final Function0<A> a;
    private A result;
    private Throwable errorThrown;
    private volatile boolean hasResult;

    public <A> EvalOnceObservable(Function0<A> a) {
        this.a = a;
        this.errorThrown = null;
        this.hasResult = false;
    }

    private void signalResult(Subscriber<A> out, A value, Throwable ex) {
        if (ex == null) {
            out.onNext(value);
            out.onComplete();
        } else {
            out.onError(ex);
        }
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        if (this.hasResult) {
            this.signalResult(subscriber, this.result, this.errorThrown);
        } else {
            EvalOnceObservable evalOnceObservable = this;
            synchronized (evalOnceObservable) {
                BoxedUnit boxedUnit;
                if (this.hasResult) {
                    this.signalResult(subscriber, this.result, this.errorThrown);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.liftedTree1$1();
                    this.hasResult = true;
                    this.signalResult(subscriber, this.result, this.errorThrown);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        return Cancelable$.MODULE$.empty();
    }

    private final void liftedTree1$1() {
        try {
            this.result = this.a.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                this.errorThrown = ex;
            }
            throw throwable;
        }
    }
}

