/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.concurrent.Future;
import scala.util.control.NonFatal$;

public final class ExecuteWithModelObservable<A>
extends Observable<A> {
    private final Observable<A> source;
    private final ExecutionModel em;

    public <A> ExecuteWithModelObservable(Observable<A> source, ExecutionModel em) {
        this.source = source;
        this.em = em;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> out) {
        Cancelable cancelable;
        boolean streamErrors = true;
        try {
            Scheduler newS = out.scheduler().withExecutionModel(this.em);
            streamErrors = false;
            cancelable = this.source.unsafeSubscribeFn(new Subscriber<A>(out, newS){
                private final Subscriber out$1;
                private final Scheduler scheduler;
                {
                    this.out$1 = out$1;
                    this.scheduler = newS$1;
                }

                public Scheduler scheduler() {
                    return this.scheduler;
                }

                public void onError(Throwable ex) {
                    this.out$1.onError(ex);
                }

                public void onComplete() {
                    this.out$1.onComplete();
                }

                public Future onNext(Object elem) {
                    return this.out$1.onNext(elem);
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                if (streamErrors) {
                    out.onError(ex);
                } else {
                    out.scheduler().reportFailure(ex);
                }
                cancelable = Cancelable$.MODULE$.empty();
            }
            throw throwable;
        }
        return cancelable;
    }
}

