/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.exceptions.APIContractViolationException$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class IteratorAsObservable<A>
extends Observable<A> {
    private final Iterator<A> iterator;
    private final AtomicBoolean wasSubscribed;

    public <A> IteratorAsObservable(Iterator<A> iterator) {
        this.iterator = iterator;
        this.wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> out) {
        Cancelable cancelable;
        if (this.wasSubscribed.getAndSet(true)) {
            out.onError((Throwable)APIContractViolationException$.MODULE$.apply("InputStreamObservable"));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            cancelable = this.startLoop(out);
        }
        return cancelable;
    }

    private Cancelable startLoop(Subscriber<A> subscriber) {
        Cancelable cancelable;
        boolean streamErrors = true;
        try {
            boolean iteratorHasNext = this.iterator.hasNext();
            streamErrors = false;
            if (!iteratorHasNext) {
                subscriber.onComplete();
                cancelable = Cancelable$.MODULE$.empty();
            } else {
                BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
                this.fastLoop(this.iterator, subscriber, cancelable2, subscriber.scheduler().executionModel(), 0, subscriber.scheduler());
                cancelable = cancelable2;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                if (streamErrors) {
                    subscriber.onError(ex);
                    cancelable = Cancelable$.MODULE$.empty();
                } else {
                    subscriber.scheduler().reportFailure(ex);
                    cancelable = Cancelable$.MODULE$.empty();
                }
            }
            throw throwable;
        }
        return cancelable;
    }

    private void reschedule(Future<Ack> ack, Iterator<A> iter, Subscriber<A> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Ack next;
                Ack ack = next = (Ack)((Success)try_).value();
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(ack != null ? !ack.equals(continue$) : continue$ != null)) {
                    this.liftedTree1$1(iter, out, c, em, s);
                }
            } else if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                out.onError(ex);
            } else {
                throw new MatchError((Object)try_);
            }
        }, (ExecutionContext)s);
    }

    private void fastLoop(Iterator<A> iter, Subscriber<A> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block12: {
            int nextIndex;
            Future<Ack> ack;
            IteratorAsObservable iteratorAsObservable = this;
            int n = syncIndex;
            while (true) {
                int n2;
                ack = Ack.Continue$.MODULE$;
                boolean streamErrors = true;
                boolean iteratorHasNext = true;
                Throwable iteratorTriggeredError = null;
                try {
                    Object next = iter.next();
                    iteratorHasNext = iter.hasNext();
                    ack = out.onNext(next);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = (Throwable)option.get();
                        if (streamErrors) {
                            iteratorTriggeredError = ex;
                        }
                    }
                    throw throwable;
                }
                if (iteratorTriggeredError != null) {
                    if (!c.isCanceled()) {
                        out.onError(iteratorTriggeredError);
                    } else {
                        s.reportFailure(iteratorTriggeredError);
                    }
                    break block12;
                }
                if (!iteratorHasNext) {
                    streamErrors = true;
                    out.onComplete();
                    break block12;
                }
                Future<Ack> future = ack;
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(future != null ? !future.equals((Object)continue$) : continue$ != null)) {
                    n2 = em.nextFrameIndex(n);
                } else {
                    Future<Ack> future2 = ack;
                    Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                    n2 = !(future2 != null ? !future2.equals((Object)stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                }
                if (nextIndex <= 0) break;
                IteratorAsObservable iteratorAsObservable2 = iteratorAsObservable;
                int n3 = nextIndex;
                iteratorAsObservable = iteratorAsObservable2;
                n = n3;
            }
            if (nextIndex == 0 && !c.isCanceled()) {
                iteratorAsObservable.reschedule(ack, iter, out, c, em, s);
            }
        }
    }

    private final void liftedTree1$1(Iterator iter$2, Subscriber out$2, BooleanCancelable c$2, ExecutionModel em$2, Scheduler s$2) {
        try {
            this.fastLoop(iter$2, out$2, c$2, em$2, 0, s$2);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                s$2.reportFailure(ex);
            }
            throw throwable;
        }
    }
}

