/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class PaginateObservable<S, A>
extends Observable<A> {
    private final Function0<S> seed;
    private final Function1<S, Tuple2<A, Option<S>>> f;

    public <S, A> PaginateObservable(Function0<S> seed, Function1<S, Tuple2<A, Option<S>>> f) {
        this.seed = seed;
        this.f = f;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        Cancelable cancelable;
        boolean streamErrors = true;
        try {
            Object init = this.seed.apply();
            BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
            streamErrors = false;
            new StateRunLoop(subscriber, cancelable2, init, this.f).run();
            cancelable = cancelable2;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                if (streamErrors) {
                    subscriber.onError(ex);
                } else {
                    subscriber.scheduler().reportFailure(ex);
                }
                cancelable = Cancelable$.MODULE$.empty();
            }
            throw throwable;
        }
        return cancelable;
    }

    private final class StateRunLoop
    implements Runnable {
        private final Subscriber<A> o;
        private final BooleanCancelable c;
        private final Function1<S, Tuple2<A, Option<S>>> f;
        private S seed;
        private final ExecutionModel em;
        private final Function1<Try<Ack>, BoxedUnit> asyncReschedule;

        public StateRunLoop(Subscriber<A> o, BooleanCancelable c, S initialSeed, Function1<S, Tuple2<A, Option<S>>> f) {
            this.o = o;
            this.c = c;
            this.f = f;
            this.seed = initialSeed;
            this.em = o.scheduler().executionModel();
            this.asyncReschedule = (JProcedure1 & Serializable)x$1 -> {
                block1: {
                    Try try_;
                    block0: {
                        try_ = x$1;
                        Success success = Ack.Continue$.MODULE$.AsSuccess();
                        Try try_2 = try_;
                        if (success != null ? !success.equals(try_2) : try_2 != null) break block0;
                        this.run();
                        break block1;
                    }
                    if (!(try_ instanceof Failure)) break block1;
                    Throwable ex = ((Failure)try_).exception();
                    o.onError(ex);
                }
            };
        }

        public void fastLoop(int syncIndex) {
            int nextIndex;
            Ack.Stop$ ack;
            StateRunLoop stateRunLoop = this;
            int n = syncIndex;
            while (true) {
                int n2;
                Ack.Stop$ stop$;
                block10: {
                    try {
                        Tuple2 tuple2 = (Tuple2)stateRunLoop.f.apply(stateRunLoop.seed);
                        if (tuple2 != null) {
                            Object object = tuple2._1();
                            Option option = (Option)tuple2._2();
                            Object nextA = object;
                            if (option instanceof Some) {
                                Object nextS = ((Some)option).value();
                                stateRunLoop.seed = nextS;
                                stop$ = stateRunLoop.o.onNext(nextA);
                                break block10;
                            }
                            Object nextA2 = object;
                            if (None$.MODULE$.equals(option)) {
                                stateRunLoop.o.onNext(nextA2);
                                stateRunLoop.o.onComplete();
                                stop$ = Ack.Stop$.MODULE$;
                                break block10;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(ex)) {
                            stateRunLoop.o.onError(ex);
                            stop$ = Ack.Stop$.MODULE$;
                        }
                        throw throwable;
                    }
                }
                Ack.Stop$ stop$2 = ack = stop$;
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(stop$2 != null ? !stop$2.equals(continue$) : continue$ != null)) {
                    n2 = stateRunLoop.em.nextFrameIndex(n);
                } else {
                    Ack.Stop$ stop$3 = ack;
                    Ack.Stop$ stop$4 = Ack.Stop$.MODULE$;
                    n2 = !(stop$3 != null ? !stop$3.equals(stop$4) : stop$4 != null) ? -1 : (nextIndex = 0);
                }
                if (nextIndex <= 0) break;
                StateRunLoop stateRunLoop2 = stateRunLoop;
                int n3 = nextIndex;
                stateRunLoop = stateRunLoop2;
                n = n3;
            }
            if (nextIndex == 0 && !stateRunLoop.c.isCanceled()) {
                ack.onComplete(stateRunLoop.asyncReschedule, (ExecutionContext)stateRunLoop.o.scheduler());
            }
        }

        @Override
        public void run() {
            try {
                this.fastLoop(0);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable ex = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(ex)) {
                    this.o.scheduler().reportFailure(ex);
                }
                throw throwable;
            }
        }
    }
}

