/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.Callback$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.UncaughtExceptionReporter;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class UnfoldEvalObservable<S, A>
extends Observable<A> {
    private final S seed;
    private final Function1<S, Task<Option<Tuple2<A, S>>>> f;

    public <S, A> UnfoldEvalObservable(S seed, Function1<S, Task<Option<Tuple2<A, S>>>> f) {
        this.seed = seed;
        this.f = f;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        Cancelable cancelable;
        boolean streamErrors = true;
        try {
            S init = this.seed;
            streamErrors = false;
            cancelable = Task$.MODULE$.defer(() -> this.unsafeSubscribeFn$$anonfun$1(subscriber, init)).executeWithOptions((Function1 & Serializable)_$1 -> _$1.enableAutoCancelableRunLoops()).runAsync((Function1)Callback$.MODULE$.empty((UncaughtExceptionReporter)subscriber.scheduler()), subscriber.scheduler());
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                if (streamErrors) {
                    subscriber.onError(ex);
                } else {
                    subscriber.scheduler().reportFailure(ex);
                }
                cancelable = Cancelable$.MODULE$.empty();
            }
            throw throwable;
        }
        return cancelable;
    }

    public Task<BoxedUnit> loop(Subscriber<A> subscriber, S state) {
        Task task;
        try {
            task = ((Task)this.f.apply(state)).redeemWith((Function1 & Serializable)ex -> {
                subscriber.onError((Throwable)ex);
                return Task$.MODULE$.unit();
            }, (Function1 & Serializable)x$12 -> {
                Task task;
                Tuple2 tuple2;
                Option option = x$12;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Object a = tuple2._1();
                    Object newState = tuple2._2();
                    task = Task$.MODULE$.fromFuture(subscriber.onNext(a)).flatMap((Function1 & Serializable)x$1 -> {
                        Task task;
                        Ack ack = x$1;
                        if (Ack.Continue$.MODULE$.equals(ack)) {
                            task = this.loop(subscriber, newState);
                        } else if (Ack.Stop$.MODULE$.equals(ack)) {
                            task = Task$.MODULE$.unit();
                        } else {
                            throw new MatchError((Object)ack);
                        }
                        return task;
                    });
                } else if (None$.MODULE$.equals(option)) {
                    subscriber.onComplete();
                    task = Task$.MODULE$.unit();
                } else {
                    throw new MatchError((Object)option);
                }
                return task;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex2 = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex2)) {
                task = Task$.MODULE$.raiseError(ex2);
            }
            throw throwable;
        }
        return task;
    }

    private final Task unsafeSubscribeFn$$anonfun$1(Subscriber subscriber$1, Object init$1) {
        return this.loop(subscriber$1, init$1);
    }
}

