/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class UnfoldObservable<S, A>
extends Observable<A> {
    private final Function0<S> seed;
    private final Function1<S, Option<Tuple2<A, S>>> f;

    public <S, A> UnfoldObservable(Function0<S> seed, Function1<S, Option<Tuple2<A, S>>> f) {
        this.seed = seed;
        this.f = f;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        Cancelable cancelable;
        boolean streamErrors = true;
        try {
            Object init = this.seed.apply();
            BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
            streamErrors = false;
            new StateRunLoop(subscriber, cancelable2, init, this.f).run();
            cancelable = cancelable2;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                if (streamErrors) {
                    subscriber.onError(ex);
                } else {
                    subscriber.scheduler().reportFailure(ex);
                }
                cancelable = Cancelable$.MODULE$.empty();
            }
            throw throwable;
        }
        return cancelable;
    }

    private final class StateRunLoop
    implements Runnable {
        private final Subscriber<A> o;
        private final BooleanCancelable c;
        private final Function1<S, Option<Tuple2<A, S>>> f;
        private S seed;
        private final ExecutionModel em;
        private final Function1<Try<Ack>, BoxedUnit> asyncReschedule;

        public StateRunLoop(Subscriber<A> o, BooleanCancelable c, S initialSeed, Function1<S, Option<Tuple2<A, S>>> f) {
            this.o = o;
            this.c = c;
            this.f = f;
            this.seed = initialSeed;
            this.em = o.scheduler().executionModel();
            this.asyncReschedule = (JProcedure1 & Serializable)x$1 -> {
                block1: {
                    Try try_;
                    block0: {
                        try_ = x$1;
                        Success success = Ack.Continue$.MODULE$.AsSuccess();
                        Try try_2 = try_;
                        if (success != null ? !success.equals(try_2) : try_2 != null) break block0;
                        this.run();
                        break block1;
                    }
                    if (!(try_ instanceof Failure)) break block1;
                    Throwable ex = ((Failure)try_).exception();
                    o.onError(ex);
                }
            };
        }

        public void fastLoop(int syncIndex) {
            int nextIndex;
            Future<Ack> ack;
            StateRunLoop stateRunLoop = this;
            int n = syncIndex;
            while (true) {
                int n2;
                Future<Ack> future;
                block9: {
                    try {
                        Tuple2 tuple2;
                        Option option = (Option)stateRunLoop.f.apply(stateRunLoop.seed);
                        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                            Object nextA = tuple2._1();
                            Object newState = tuple2._2();
                            stateRunLoop.seed = newState;
                            future = stateRunLoop.o.onNext(nextA);
                            break block9;
                        }
                        if (None$.MODULE$.equals(option)) {
                            stateRunLoop.o.onComplete();
                            future = Ack.Stop$.MODULE$;
                            break block9;
                        }
                        throw new MatchError((Object)option);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(ex)) {
                            stateRunLoop.o.onError(ex);
                            future = Ack.Stop$.MODULE$;
                        }
                        throw throwable;
                    }
                }
                Future<Ack> future2 = ack = future;
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(future2 != null ? !future2.equals((Object)continue$) : continue$ != null)) {
                    n2 = stateRunLoop.em.nextFrameIndex(n);
                } else {
                    Future<Ack> future3 = ack;
                    Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                    n2 = !(future3 != null ? !future3.equals((Object)stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                }
                if (nextIndex <= 0) break;
                StateRunLoop stateRunLoop2 = stateRunLoop;
                int n3 = nextIndex;
                stateRunLoop = stateRunLoop2;
                n = n3;
            }
            if (nextIndex == 0 && !stateRunLoop.c.isCanceled()) {
                ack.onComplete(stateRunLoop.asyncReschedule, (ExecutionContext)stateRunLoop.o.scheduler());
            }
        }

        @Override
        public void run() {
            try {
                this.fastLoop(0);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable ex = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(ex)) {
                    this.o.scheduler().reportFailure(ex);
                }
                throw throwable;
            }
        }
    }
}

