/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.consumers;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Callback;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.AssignableCancelable;
import monix.execution.cancelables.SingleAssignCancelable;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.reactive.Consumer;
import monix.reactive.internal.consumers.LoadBalanceConsumer$;
import monix.reactive.internal.consumers.LoadBalanceConsumer$Available$;
import monix.reactive.internal.consumers.LoadBalanceConsumer$IndexedSubscriber$;
import monix.reactive.internal.consumers.LoadBalanceConsumer$Waiting$;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.List;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class LoadBalanceConsumer<In, R>
extends Consumer<In, List<R>> {
    public final int monix$reactive$internal$consumers$LoadBalanceConsumer$$parallelism;
    public final Consumer<In, R>[] monix$reactive$internal$consumers$LoadBalanceConsumer$$consumers;

    public <In, R> LoadBalanceConsumer(int parallelism, Consumer<In, R>[] consumers) {
        this.monix$reactive$internal$consumers$LoadBalanceConsumer$$parallelism = parallelism;
        this.monix$reactive$internal$consumers$LoadBalanceConsumer$$consumers = consumers;
        Predef$.MODULE$.require(parallelism > 0, () -> LoadBalanceConsumer.$init$$$anonfun$1(parallelism));
        Predef$.MODULE$.require(consumers.length > 0, LoadBalanceConsumer::$init$$$anonfun$2);
    }

    @Override
    public Tuple2<Subscriber<In>, AssignableCancelable> createSubscriber(Callback<Throwable, List<R>> onFinish, Scheduler s) {
        SingleAssignCancelable mainCancelable = SingleAssignCancelable$.MODULE$.apply();
        Subscriber balanced = new Subscriber<In>(onFinish, s, mainCancelable, this){
            private final Callback onFinish$1;
            private final Scheduler s$1;
            private final SingleAssignCancelable mainCancelable$1;
            private final Scheduler scheduler;
            private boolean isUpstreamComplete;
            private boolean isDownstreamDone;
            private Throwable reportedError;
            private final ListBuffer accumulator;
            private final AsyncQueue subscribersQueue;
            private final LoadBalanceConsumer $outer;
            {
                AsyncQueue<In> asyncQueue;
                this.onFinish$1 = onFinish$1;
                this.s$1 = s$1;
                this.mainCancelable$1 = mainCancelable$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.scheduler = s$1;
                this.isUpstreamComplete = false;
                this.isDownstreamDone = false;
                this.accumulator = ListBuffer$.MODULE$.empty();
                $anon$1 var5_5 = this;
                synchronized (var5_5) {
                    Queue initial = Queue$.MODULE$.empty();
                    Callback<Throwable, R> callback = new Callback<Throwable, R>(this){
                        private final $anon$1 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public void onSuccess(Object value) {
                            this.$outer.monix$reactive$internal$consumers$LoadBalanceConsumer$$anon$1$$accumulate(value);
                        }

                        public void onError(Throwable ex) {
                            this.$outer.monix$reactive$internal$consumers$LoadBalanceConsumer$$anon$1$$interruptAll(ex);
                        }
                    };
                    int arrLen = $outer.monix$reactive$internal$consumers$LoadBalanceConsumer$$consumers.length;
                    for (int i = 0; i < $outer.monix$reactive$internal$consumers$LoadBalanceConsumer$$parallelism; ++i) {
                        Tuple2<Subscriber<In>, AssignableCancelable> tuple2 = $outer.monix$reactive$internal$consumers$LoadBalanceConsumer$$consumers[i % arrLen].createSubscriber(callback, s$1);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Subscriber out = (Subscriber)tuple2._1();
                        AssignableCancelable c = (AssignableCancelable)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)out, (Object)c);
                        Subscriber out2 = (Subscriber)tuple22._1();
                        AssignableCancelable c2 = (AssignableCancelable)tuple22._2();
                        IndexedSubscriber<In> indexed = LoadBalanceConsumer$IndexedSubscriber$.MODULE$.apply(i, out2);
                        c2.$colon$eq(this.newCancelableFor(indexed));
                        initial = initial.enqueue(indexed);
                    }
                    asyncQueue = new AsyncQueue<In>(initial, $outer.monix$reactive$internal$consumers$LoadBalanceConsumer$$parallelism);
                }
                this.subscribersQueue = asyncQueue;
            }

            public Scheduler scheduler() {
                return this.scheduler;
            }

            private Cancelable newCancelableFor(IndexedSubscriber out) {
                return new Cancelable(out, this){
                    private final IndexedSubscriber out$1;
                    private boolean isCanceled;
                    private final $anon$1 $outer;
                    {
                        this.out$1 = out$5;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.isCanceled = false;
                    }

                    public void cancel() {
                        this.$outer.scheduler().execute(() -> {
                            $anon$1 var1_1 = this.$outer;
                            synchronized (var1_1) {
                                BoxedUnit boxedUnit;
                                if (!this.isCanceled) {
                                    this.isCanceled = true;
                                    this.$outer.monix$reactive$internal$consumers$LoadBalanceConsumer$$anon$1$$interruptOne(this.out$1, null);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                        });
                    }
                };
            }

            public Future onNext(Object elem) {
                Future future;
                Try try_;
                Future<IndexedSubscriber<In>> sf = this.subscribersQueue.poll();
                Option option = sf.value();
                if (option instanceof Some && (try_ = (Try)((Some)option).value()) instanceof Success) {
                    IndexedSubscriber subscriber = (IndexedSubscriber)((Success)try_).value();
                    if (subscriber == null) {
                        future = this.stop$1();
                    } else {
                        this.signalNext(subscriber, elem);
                        future = Ack.Continue$.MODULE$;
                    }
                } else {
                    future = sf.map((Function1 & Serializable)x$1 -> {
                        Ack ack;
                        IndexedSubscriber indexedSubscriber = x$1;
                        if (indexedSubscriber == null) {
                            ack = this.stop$1();
                        } else {
                            IndexedSubscriber subscriber = indexedSubscriber;
                            this.signalNext(subscriber, elem);
                            ack = Ack.Continue$.MODULE$;
                        }
                        return ack;
                    }, (ExecutionContext)this.scheduler());
                }
                return future;
            }

            public void monix$reactive$internal$consumers$LoadBalanceConsumer$$anon$1$$accumulate(Object value) {
                $anon$1 var2_2 = this;
                synchronized (var2_2) {
                    BoxedUnit boxedUnit;
                    if (!this.isDownstreamDone) {
                        this.accumulator.$plus$eq(value);
                        if (this.accumulator.length() == this.$outer.monix$reactive$internal$consumers$LoadBalanceConsumer$$parallelism) {
                            this.isDownstreamDone = true;
                            this.onFinish$1.onSuccess((Object)this.accumulator.toList());
                            this.accumulator.clear();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            private void reportErrorUpstream(Throwable ex) {
                $anon$1 var2_2 = this;
                synchronized (var2_2) {
                    BoxedUnit boxedUnit;
                    if (this.isDownstreamDone) {
                        Throwable throwable = this.reportedError;
                        Throwable throwable2 = ex;
                        if (throwable == null ? throwable2 != null : !throwable.equals(throwable2)) {
                            this.scheduler().reportFailure(ex);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        this.isDownstreamDone = true;
                        this.reportedError = ex;
                        this.onFinish$1.onError((Object)ex);
                        this.accumulator.clear();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public void monix$reactive$internal$consumers$LoadBalanceConsumer$$anon$1$$interruptOne(IndexedSubscriber out, Throwable ex) {
                if (this.subscribersQueue.deactivate(out)) {
                    this.monix$reactive$internal$consumers$LoadBalanceConsumer$$anon$1$$interruptAll(ex);
                }
            }

            public void monix$reactive$internal$consumers$LoadBalanceConsumer$$anon$1$$interruptAll(Throwable ex) {
                $anon$1 var2_2 = this;
                synchronized (var2_2) {
                    BoxedUnit boxedUnit;
                    this.isUpstreamComplete = true;
                    this.mainCancelable$1.cancel();
                    this.subscribersQueue.deactivateAll();
                    if (ex != null) {
                        this.reportErrorUpstream(ex);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            private void signalNext(IndexedSubscriber out, Object elem) {
                this.scheduler().execute(() -> this.liftedTree1$2(out, elem));
            }

            public void onComplete() {
                this.signalComplete(null);
            }

            public void onError(Throwable ex) {
                this.signalComplete(ex);
            }

            private void signalComplete(Throwable ex) {
                $anon$1 var2_2 = this;
                synchronized (var2_2) {
                    BoxedUnit boxedUnit;
                    if (!this.isUpstreamComplete) {
                        this.isUpstreamComplete = true;
                        this.loop$1(ex, this.subscribersQueue.activeCount()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                            Try try_ = x$1;
                            if (try_ instanceof Success) {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                Object object = ((Success)try_).value();
                                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                                    if (ex == null) return;
                                    this.reportErrorUpstream(ex);
                                    return;
                                }
                            }
                            if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                            Throwable err = ((Failure)try_).exception();
                            this.reportErrorUpstream(err);
                        }, (ExecutionContext)this.scheduler());
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (ex != null) {
                        this.reportErrorUpstream(ex);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            private final Ack stop$1() {
                Ack.Stop$ stop$;
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    this.isUpstreamComplete = true;
                    stop$ = Ack.Stop$.MODULE$;
                }
                return stop$;
            }

            private final void liftedTree1$2(IndexedSubscriber out$3, Object elem$3) {
                try {
                    Future future = Ack$.MODULE$.AckExtensions(out$3.out().onNext(elem$3));
                    Ack.AckExtensions$.MODULE$.syncOnComplete$extension(future, (Function1)(JProcedure1 & Serializable)x$1 -> {
                        Try try_ = x$1;
                        if (try_ instanceof Success) {
                            Ack ack = (Ack)((Success)try_).value();
                            Ack ack2 = ack;
                            if (Ack.Continue$.MODULE$.equals(ack2)) {
                                this.subscribersQueue.offer(out$3);
                                return;
                            } else {
                                if (!Ack.Stop$.MODULE$.equals(ack2)) throw new MatchError((Object)ack2);
                                this.monix$reactive$internal$consumers$LoadBalanceConsumer$$anon$1$$interruptOne(out$3, null);
                            }
                            return;
                        } else {
                            if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                            Throwable ex = ((Failure)try_).exception();
                            this.monix$reactive$internal$consumers$LoadBalanceConsumer$$anon$1$$interruptAll(ex);
                        }
                    }, (UncaughtExceptionReporter)this.scheduler());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        this.monix$reactive$internal$consumers$LoadBalanceConsumer$$anon$1$$interruptAll(ex);
                    }
                    throw throwable;
                }
            }

            private final void liftedTree2$1(Throwable ex$3, IndexedSubscriber subscriber$1) {
                try {
                    if (ex$3 == null) {
                        subscriber$1.out().onComplete();
                    } else {
                        subscriber$1.out().onError(ex$3);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable err = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(err)) {
                        this.s$1.reportFailure(err);
                    }
                    throw throwable;
                }
            }

            private final Future loop$1(Throwable ex$1, int activeCount) {
                return activeCount <= 0 ? Future$.MODULE$.successful((Object)BoxedUnit.UNIT) : this.subscribersQueue.poll().flatMap((Function1 & Serializable)x$1 -> {
                    Future future;
                    IndexedSubscriber indexedSubscriber = x$1;
                    if (indexedSubscriber == null) {
                        future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                    } else {
                        IndexedSubscriber subscriber = indexedSubscriber;
                        this.liftedTree2$1(ex$1, subscriber);
                        future = activeCount > 0 ? this.loop$1(ex$1, activeCount - 1) : Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                    }
                    return future;
                }, (ExecutionContext)this.scheduler());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onNext$$anonfun$1(java.lang.Object monix.reactive.internal.consumers.LoadBalanceConsumer$IndexedSubscriber ), signalComplete$$anonfun$1(java.lang.Throwable scala.util.Try ), liftedTree1$1$$anonfun$1(monix.reactive.internal.consumers.LoadBalanceConsumer$IndexedSubscriber scala.util.Try ), loop$2$$anonfun$1(java.lang.Throwable int monix.reactive.internal.consumers.LoadBalanceConsumer$IndexedSubscriber )}, serializedLambda);
            }
        };
        return Tuple2$.MODULE$.apply((Object)balanced, (Object)mainCancelable);
    }

    private static final String $init$$$anonfun$1(int parallelism$1) {
        return "parallelism = " + parallelism$1 + ", should be > 0";
    }

    private static final String $init$$$anonfun$2() {
        return "consumers list must not be empty";
    }

    private static final class AsyncQueue<In> {
        private final AtomicAny<State<In>> stateRef;

        public <In> AsyncQueue(Queue<IndexedSubscriber<In>> initialQueue, int parallelism) {
            Available<In> initial = LoadBalanceConsumer$Available$.MODULE$.apply(initialQueue, BitSet$.MODULE$.empty(), parallelism);
            AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
            this.stateRef = (AtomicAny)builder$proxy1.buildInstance(initial, (PaddingStrategy)PaddingStrategy.LeftRight256$.MODULE$, true);
        }

        public int activeCount() {
            return ((State)this.stateRef.get()).activeCount();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void offer(IndexedSubscriber<In> value) {
            Promise promise;
            AsyncQueue asyncQueue = this;
            while (true) {
                State state;
                if ((state = (State)asyncQueue.stateRef.get()) instanceof Available) {
                    Available update;
                    Available available = (Available)state;
                    Available available2 = LoadBalanceConsumer$Available$.MODULE$.unapply(available);
                    Queue queue = available2._1();
                    BitSet bitSet = available2._2();
                    int n = available2._3();
                    Queue queue2 = queue;
                    BitSet canceledIDs = bitSet;
                    int ac = n;
                    Available current = available;
                    if (ac <= 0 || canceledIDs.apply$mcZI$sp(value.id()) || asyncQueue.stateRef.compareAndSet((Object)current, update = LoadBalanceConsumer$Available$.MODULE$.apply(queue2.enqueue(value), canceledIDs, ac))) return;
                    continue;
                }
                if (!(state instanceof Waiting)) throw new MatchError((Object)state);
                Waiting waiting = (Waiting)state;
                Waiting waiting2 = LoadBalanceConsumer$Waiting$.MODULE$.unapply(waiting);
                Promise promise2 = waiting2._1();
                BitSet bitSet = waiting2._2();
                int n = waiting2._3();
                promise = promise2;
                BitSet canceledIDs = bitSet;
                int ac = n;
                Waiting current = waiting;
                if (canceledIDs.apply$mcZI$sp(value.id())) return;
                Available update = LoadBalanceConsumer$Available$.MODULE$.apply(Queue$.MODULE$.empty(), canceledIDs, ac);
                if (asyncQueue.stateRef.compareAndSet((Object)current, update)) break;
            }
            promise.success(value);
        }

        public Future<IndexedSubscriber<In>> poll() {
            Future future;
            block8: {
                State state;
                AsyncQueue asyncQueue = this;
                while ((state = (State)asyncQueue.stateRef.get()) instanceof Available) {
                    Available available = (Available)state;
                    Available available2 = LoadBalanceConsumer$Available$.MODULE$.unapply(available);
                    Queue queue = available2._1();
                    BitSet bitSet = available2._2();
                    int n = available2._3();
                    Queue queue2 = queue;
                    BitSet canceledIDs = bitSet;
                    int ac = n;
                    Available current = available;
                    if (ac <= 0) {
                        future = Future$.MODULE$.successful(null);
                    } else if (queue2.isEmpty()) {
                        Promise p = Promise$.MODULE$.apply();
                        Waiting update = LoadBalanceConsumer$Waiting$.MODULE$.apply(p, canceledIDs, ac);
                        if (!asyncQueue.stateRef.compareAndSet((Object)current, update)) continue;
                        future = p.future();
                    } else {
                        Tuple2 tuple2 = queue2.dequeue();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        IndexedSubscriber ref = (IndexedSubscriber)tuple2._1();
                        Queue newQueue = (Queue)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)ref, (Object)newQueue);
                        IndexedSubscriber ref2 = (IndexedSubscriber)tuple22._1();
                        Queue newQueue2 = (Queue)tuple22._2();
                        Available update = LoadBalanceConsumer$Available$.MODULE$.apply(newQueue2, canceledIDs, ac);
                        if (!asyncQueue.stateRef.compareAndSet((Object)current, update)) continue;
                        future = Future$.MODULE$.successful((Object)ref2);
                    }
                    break block8;
                }
                if (state instanceof Waiting) {
                    Waiting waiting = LoadBalanceConsumer$Waiting$.MODULE$.unapply((Waiting)state);
                    Promise promise = waiting._1();
                    BitSet bitSet = waiting._2();
                    int n = waiting._3();
                    future = Future$.MODULE$.failed((Throwable)new IllegalStateException("waiting in poll()"));
                } else {
                    throw new MatchError((Object)state);
                }
            }
            return future;
        }

        public void deactivateAll() {
            block3: {
                State state;
                block4: {
                    Promise promise;
                    AsyncQueue asyncQueue = this;
                    while (true) {
                        if ((state = (State)asyncQueue.stateRef.get()) instanceof Available) {
                            Available available = (Available)state;
                            Available available2 = LoadBalanceConsumer$Available$.MODULE$.unapply(available);
                            Queue queue = available2._1();
                            BitSet bitSet = available2._2();
                            int n = available2._3();
                            BitSet canceledIDs = bitSet;
                            Available current = available;
                            Available update = LoadBalanceConsumer$Available$.MODULE$.apply(Queue$.MODULE$.empty(), canceledIDs, 0);
                            if (!asyncQueue.stateRef.compareAndSet((Object)current, update)) {
                                continue;
                            }
                            break block3;
                        }
                        if (!(state instanceof Waiting)) break block4;
                        Waiting waiting = (Waiting)state;
                        Waiting waiting2 = LoadBalanceConsumer$Waiting$.MODULE$.unapply(waiting);
                        Promise promise2 = waiting2._1();
                        BitSet bitSet = waiting2._2();
                        int n = waiting2._3();
                        promise = promise2;
                        BitSet canceledIDs = bitSet;
                        Waiting current = waiting;
                        Available update = LoadBalanceConsumer$Available$.MODULE$.apply(Queue$.MODULE$.empty(), canceledIDs, 0);
                        if (asyncQueue.stateRef.compareAndSet((Object)current, update)) break;
                    }
                    promise.success(null);
                    break block3;
                }
                throw new MatchError((Object)state);
            }
        }

        public boolean deactivate(IndexedSubscriber<In> ref) {
            boolean bl;
            block11: {
                State state;
                block12: {
                    State update;
                    Promise promise;
                    AsyncQueue asyncQueue = this;
                    while (true) {
                        if ((state = (State)asyncQueue.stateRef.get()) instanceof Available) {
                            Available available = (Available)state;
                            Available available2 = LoadBalanceConsumer$Available$.MODULE$.unapply(available);
                            Queue queue = available2._1();
                            BitSet bitSet = available2._2();
                            int n = available2._3();
                            Queue queue2 = queue;
                            BitSet canceledIDs = bitSet;
                            int count = n;
                            Available current = available;
                            if (count <= 0) {
                                bl = true;
                            } else {
                                Available update2;
                                Available available3;
                                if (canceledIDs.apply$mcZI$sp(ref.id())) {
                                    available3 = current;
                                } else {
                                    Queue newQueue = (Queue)queue2.filterNot((Function1 & Serializable)_$2 -> _$2.id() == ref.id());
                                    available3 = update2 = LoadBalanceConsumer$Available$.MODULE$.apply(newQueue, (BitSet)canceledIDs.$plus((Object)BoxesRunTime.boxToInteger((int)ref.id())), count - 1);
                                }
                                if (update2.activeCount() == current.activeCount()) {
                                    bl = false;
                                } else {
                                    if (!asyncQueue.stateRef.compareAndSet((Object)current, (Object)update2)) continue;
                                    bl = update2.activeCount() == 0;
                                }
                            }
                            break block11;
                        }
                        if (!(state instanceof Waiting)) break block12;
                        Waiting waiting = (Waiting)state;
                        Waiting waiting2 = LoadBalanceConsumer$Waiting$.MODULE$.unapply(waiting);
                        Promise promise2 = waiting2._1();
                        BitSet bitSet = waiting2._2();
                        int n = waiting2._3();
                        promise = promise2;
                        BitSet canceledIDs = bitSet;
                        int count = n;
                        Waiting current = waiting;
                        if (canceledIDs.apply$mcZI$sp(ref.id())) {
                            bl = count <= 0;
                            break block11;
                        }
                        update = (State)(count - 1 > 0 ? LoadBalanceConsumer$Waiting$.MODULE$.apply(promise, (BitSet)canceledIDs.$plus((Object)BoxesRunTime.boxToInteger((int)ref.id())), count - 1) : LoadBalanceConsumer$Available$.MODULE$.apply(Queue$.MODULE$.empty(), (BitSet)canceledIDs.$plus((Object)BoxesRunTime.boxToInteger((int)ref.id())), 0));
                        if (asyncQueue.stateRef.compareAndSet((Object)current, (Object)update)) break;
                    }
                    if (update.activeCount() <= 0) {
                        promise.success(null);
                        bl = true;
                    } else {
                        bl = false;
                    }
                    break block11;
                }
                throw new MatchError((Object)state);
            }
            return bl;
        }
    }

    public static final class Available<In>
    implements State<In>,
    Product,
    Serializable {
        private final Queue available;
        private final BitSet canceledIDs;
        private final int activeCount;

        public static <In> Available<In> apply(Queue<IndexedSubscriber<In>> queue, BitSet bitSet, int n) {
            return LoadBalanceConsumer$Available$.MODULE$.apply(queue, bitSet, n);
        }

        public static Available fromProduct(Product product) {
            return LoadBalanceConsumer$Available$.MODULE$.fromProduct(product);
        }

        public static <In> Available<In> unapply(Available<In> available) {
            return LoadBalanceConsumer$Available$.MODULE$.unapply(available);
        }

        public <In> Available(Queue<IndexedSubscriber<In>> available, BitSet canceledIDs, int activeCount) {
            this.available = available;
            this.canceledIDs = canceledIDs;
            this.activeCount = activeCount;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.available()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.canceledIDs()));
            n = Statics.mix((int)n, (int)this.activeCount());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Available)) return false;
            Available available = (Available)object;
            if (this.activeCount() != available.activeCount()) return false;
            Queue<IndexedSubscriber<In>> queue = this.available();
            Queue<IndexedSubscriber<In>> queue2 = available.available();
            if (queue == null) {
                if (queue2 != null) {
                    return false;
                }
            } else if (!queue.equals(queue2)) return false;
            BitSet bitSet = this.canceledIDs();
            BitSet bitSet2 = available.canceledIDs();
            if (bitSet == null) {
                if (bitSet2 == null) return true;
                return false;
            } else {
                if (!bitSet.equals(bitSet2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Available;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Available";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this._3());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "available";
                    break;
                }
                case 1: {
                    string = "canceledIDs";
                    break;
                }
                case 2: {
                    string = "activeCount";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Queue<IndexedSubscriber<In>> available() {
            return this.available;
        }

        public BitSet canceledIDs() {
            return this.canceledIDs;
        }

        @Override
        public int activeCount() {
            return this.activeCount;
        }

        public <In> Available<In> copy(Queue<IndexedSubscriber<In>> available, BitSet canceledIDs, int activeCount) {
            return new Available<In>(available, canceledIDs, activeCount);
        }

        public <In> Queue<IndexedSubscriber<In>> copy$default$1() {
            return this.available();
        }

        public <In> BitSet copy$default$2() {
            return this.canceledIDs();
        }

        public int copy$default$3() {
            return this.activeCount();
        }

        public Queue<IndexedSubscriber<In>> _1() {
            return this.available();
        }

        public BitSet _2() {
            return this.canceledIDs();
        }

        public int _3() {
            return this.activeCount();
        }
    }

    public static final class IndexedSubscriber<In>
    implements Product,
    Serializable {
        private final int id;
        private final Subscriber out;

        public static <In> IndexedSubscriber<In> apply(int n, Subscriber<In> subscriber) {
            return LoadBalanceConsumer$IndexedSubscriber$.MODULE$.apply(n, subscriber);
        }

        public static IndexedSubscriber fromProduct(Product product) {
            return LoadBalanceConsumer$IndexedSubscriber$.MODULE$.fromProduct(product);
        }

        public static <In> IndexedSubscriber<In> unapply(IndexedSubscriber<In> indexedSubscriber) {
            return LoadBalanceConsumer$IndexedSubscriber$.MODULE$.unapply(indexedSubscriber);
        }

        public <In> IndexedSubscriber(int id, Subscriber<In> out) {
            this.id = id;
            this.out = out;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.out()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IndexedSubscriber)) return false;
            IndexedSubscriber indexedSubscriber = (IndexedSubscriber)object;
            if (this.id() != indexedSubscriber.id()) return false;
            Subscriber<In> subscriber = this.out();
            Subscriber<In> subscriber2 = indexedSubscriber.out();
            if (subscriber != null) {
                if (!subscriber.equals(subscriber2)) return false;
                return true;
            }
            if (subscriber2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof IndexedSubscriber;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "IndexedSubscriber";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            if (0 == n2) {
                serializable = BoxesRunTime.boxToInteger((int)this._1());
            } else if (1 == n2) {
                serializable = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "id";
            } else if (1 == n2) {
                string = "out";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public int id() {
            return this.id;
        }

        public Subscriber<In> out() {
            return this.out;
        }

        public <In> IndexedSubscriber<In> copy(int id, Subscriber<In> out) {
            return new IndexedSubscriber<In>(id, out);
        }

        public int copy$default$1() {
            return this.id();
        }

        public <In> Subscriber<In> copy$default$2() {
            return this.out();
        }

        public int _1() {
            return this.id();
        }

        public Subscriber<In> _2() {
            return this.out();
        }
    }

    public static interface State<In> {
        public int activeCount();

        public Set<Object> canceledIDs();
    }

    public static final class Waiting<In>
    implements State<In>,
    Product,
    Serializable {
        private final Promise promise;
        private final BitSet canceledIDs;
        private final int activeCount;

        public static <In> Waiting<In> apply(Promise<IndexedSubscriber<In>> promise, BitSet bitSet, int n) {
            return LoadBalanceConsumer$Waiting$.MODULE$.apply(promise, bitSet, n);
        }

        public static Waiting fromProduct(Product product) {
            return LoadBalanceConsumer$Waiting$.MODULE$.fromProduct(product);
        }

        public static <In> Waiting<In> unapply(Waiting<In> waiting) {
            return LoadBalanceConsumer$Waiting$.MODULE$.unapply(waiting);
        }

        public <In> Waiting(Promise<IndexedSubscriber<In>> promise, BitSet canceledIDs, int activeCount) {
            this.promise = promise;
            this.canceledIDs = canceledIDs;
            this.activeCount = activeCount;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.promise()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.canceledIDs()));
            n = Statics.mix((int)n, (int)this.activeCount());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Waiting)) return false;
            Waiting waiting = (Waiting)object;
            if (this.activeCount() != waiting.activeCount()) return false;
            Promise<IndexedSubscriber<In>> promise = this.promise();
            Promise<IndexedSubscriber<In>> promise2 = waiting.promise();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            BitSet bitSet = this.canceledIDs();
            BitSet bitSet2 = waiting.canceledIDs();
            if (bitSet == null) {
                if (bitSet2 == null) return true;
                return false;
            } else {
                if (!bitSet.equals(bitSet2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Waiting;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Waiting";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this._3());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "promise";
                    break;
                }
                case 1: {
                    string = "canceledIDs";
                    break;
                }
                case 2: {
                    string = "activeCount";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Promise<IndexedSubscriber<In>> promise() {
            return this.promise;
        }

        public BitSet canceledIDs() {
            return this.canceledIDs;
        }

        @Override
        public int activeCount() {
            return this.activeCount;
        }

        public <In> Waiting<In> copy(Promise<IndexedSubscriber<In>> promise, BitSet canceledIDs, int activeCount) {
            return new Waiting<In>(promise, canceledIDs, activeCount);
        }

        public <In> Promise<IndexedSubscriber<In>> copy$default$1() {
            return this.promise();
        }

        public <In> BitSet copy$default$2() {
            return this.canceledIDs();
        }

        public int copy$default$3() {
            return this.activeCount();
        }

        public Promise<IndexedSubscriber<In>> _1() {
            return this.promise();
        }

        public BitSet _2() {
            return this.canceledIDs();
        }

        public int _3() {
            return this.activeCount();
        }
    }
}

