/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.execution.Ack;
import monix.execution.Ack$;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.compat;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class BufferSlidingOperator<A>
implements Function1<Subscriber<Seq<A>>, Subscriber<A>> {
    public final int monix$reactive$internal$operators$BufferSlidingOperator$$count;
    public final int monix$reactive$internal$operators$BufferSlidingOperator$$skip;

    public <A> BufferSlidingOperator(int count, int skip) {
        this.monix$reactive$internal$operators$BufferSlidingOperator$$count = count;
        this.monix$reactive$internal$operators$BufferSlidingOperator$$skip = skip;
        Predef$.MODULE$.require(count > 0, BufferSlidingOperator::$init$$$anonfun$1);
        Predef$.MODULE$.require(skip > 0, BufferSlidingOperator::$init$$$anonfun$2);
    }

    public Subscriber<A> apply(Subscriber<Seq<A>> out) {
        return new Subscriber<A>(out, this){
            private final Subscriber out$1;
            private final Scheduler scheduler;
            private boolean isDone;
            private Future ack;
            private final int toDrop;
            private final int toRepeat;
            private Object[] buffer;
            private int dropped;
            private int length;
            private final BufferSlidingOperator $outer;
            {
                this.out$1 = out$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.scheduler = out$1.scheduler();
                this.isDone = false;
                this.toDrop = $outer.monix$reactive$internal$operators$BufferSlidingOperator$$count > $outer.monix$reactive$internal$operators$BufferSlidingOperator$$skip ? 0 : $outer.monix$reactive$internal$operators$BufferSlidingOperator$$skip - $outer.monix$reactive$internal$operators$BufferSlidingOperator$$count;
                this.toRepeat = $outer.monix$reactive$internal$operators$BufferSlidingOperator$$skip > $outer.monix$reactive$internal$operators$BufferSlidingOperator$$count ? 0 : $outer.monix$reactive$internal$operators$BufferSlidingOperator$$count - $outer.monix$reactive$internal$operators$BufferSlidingOperator$$skip;
                this.buffer = new Object[$outer.monix$reactive$internal$operators$BufferSlidingOperator$$count];
                this.dropped = 0;
                this.length = 0;
            }

            public Scheduler scheduler() {
                return this.scheduler;
            }

            public Future onNext(Object elem) {
                Ack.Stop$ stop$;
                if (this.isDone) {
                    stop$ = Ack.Stop$.MODULE$;
                } else if (this.dropped > 0) {
                    --this.dropped;
                    stop$ = Ack.Continue$.MODULE$;
                } else {
                    this.buffer[this.length] = elem;
                    ++this.length;
                    if (this.length < this.$outer.monix$reactive$internal$operators$BufferSlidingOperator$$count) {
                        stop$ = Ack.Continue$.MODULE$;
                    } else {
                        Object[] oldBuffer = this.buffer;
                        this.buffer = new Object[this.$outer.monix$reactive$internal$operators$BufferSlidingOperator$$count];
                        if (this.toRepeat > 0) {
                            System.arraycopy(oldBuffer, this.$outer.monix$reactive$internal$operators$BufferSlidingOperator$$count - this.toRepeat, this.buffer, 0, this.toRepeat);
                            this.length = this.toRepeat;
                        } else {
                            this.dropped = this.toDrop;
                            this.length = 0;
                        }
                        this.ack = this.out$1.onNext(compat.internal$.MODULE$.toSeq(oldBuffer));
                        stop$ = this.ack;
                    }
                }
                return stop$;
            }

            public void onError(Throwable ex) {
                if (!this.isDone) {
                    this.isDone = true;
                    this.buffer = null;
                    this.out$1.onError(ex);
                }
            }

            public void onComplete() {
                if (!this.isDone) {
                    int threshold;
                    this.isDone = true;
                    int n = threshold = this.ack == null ? 0 : this.toRepeat;
                    if (this.length > threshold) {
                        if (this.ack == null) {
                            this.ack = Ack.Continue$.MODULE$;
                        }
                        Future future = Ack$.MODULE$.AckExtensions(this.ack);
                        Ack.AckExtensions$.MODULE$.syncOnContinue$extension(future, (Function0)((JFunction0.mcV.sp & Serializable)this::onComplete$$anonfun$1), (UncaughtExceptionReporter)this.scheduler());
                    } else {
                        this.out$1.onComplete();
                    }
                }
            }

            private final void onComplete$$anonfun$1() {
                Object object = Predef$.MODULE$.refArrayOps(this.buffer);
                this.out$1.onNext(compat.internal$.MODULE$.toSeq((Object[])ArrayOps$.MODULE$.take$extension(object, this.length)));
                this.out$1.onComplete();
                this.buffer = null;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onComplete$$anonfun$1()}, serializedLambda);
            }
        };
    }

    private static final String $init$$$anonfun$1() {
        return "count must be strictly positive";
    }

    private static final String $init$$$anonfun$2() {
        return "skip must be strictly positive";
    }
}

